
#ifndef VIDEOPRODUCER_H
#define VIDEOPRODUCER_H

#include "osd/VideoOutputDevice.h"

class VideoProducer
{

    public:
        virtual void getOutputImageSize(UINT16* width, UINT16* height) = 0;
        virtual void getPalette(const UINT32** palette, UINT16* numEntries) = 0;
        inline BOOL inVerticalBlank() { return inVBlank; }
        virtual void render(VideoOutputDevice*) = 0;

    protected:
        VideoProducer() : inVBlank(FALSE) {}
        BOOL inVBlank;

};

#endif
