
#ifndef BLISS32_H
#define BLISS32_H

#ifdef _WIN32
#include <xtl.h>
#endif
#include "../core/Bliss.h"
#include "../core/Container.h"
#include "../plugin/SDLVideoOutputDevice.h"
#include "../plugin/SDLAudioOutputDevice.h"
#include "../plugin/SDLInputDevice.h"
#ifdef _WIN32
#include "../plugin/Win32ClockDevice.h"
#include "../core/Win32ReadDir.h"
#else
#include "../plugin/RDTSCClockDevice.h"
#include "../core/UNIXReadDir.h"
#endif
#include "../intellivision/Intellivision.h"

#define BLISS_VERSION	"v1.9d"
#define MAX_GAMES		512

#define SAFE_DELETE(p)       { if(p) { delete (p);     (p)=NULL; } }
#define SAFE_DELETE_ARRAY(p) { if(p) { delete[] (p);   (p)=NULL; } }
#define SAFE_RELEASE(p)      { if(p) { (p)->Release(); (p)=NULL; } }

using namespace std;

#ifndef _MAX_DIR
#define _MAX_DIR 255
#endif

#ifndef MAX_PATH
#define MAX_PATH 255
#endif

#ifndef _MAX_FNAME
#define _MAX_FNAME 255
#endif

class Bliss32
{

    friend void changeGame(void* lItem);

    public:
        Bliss32();
        ~Bliss32();

        INT32 run(char* sCart);
        INT32 loadSystemROMs();
        void setProgramName(CHAR *prog) {strcpy((char*)programName, (char*)prog);}
        INT32 getProgramDir(CHAR* sdir, UINT32 maxLen);

		void updateSplash(image* Image, font* StatFont, char* Status, font* VerFont);

        void clearCartList_Intv();
        static Intellivision inty;

    private:
        static Bliss bliss;

        static SDLVideoOutputDevice vod;
        static SDLAudioOutputDevice aod;
        static SDLInputDevice id;
#ifdef _WIN32
        static Win32ClockDevice cd;
#else
        static RDTSCClockDevice cd;
#endif

        UINT16*     execImage;
        UINT16*     gromImage;
        UINT16*     ecsImage;
        UINT16*     ivoiceImage;

        static const UINT32 CRC_EXECUTIVE_ROM;
        static const UINT32 CRC_GROM;
        static const UINT32 CRC_ECS_ROM;
        static const UINT32 CRC_IVOICE_ROM;
        static const CHAR* FILENAME_EXECUTIVE_ROM;
        static const CHAR* FILENAME_GROM;
        static const CHAR* FILENAME_ECS_ROM;
        static const CHAR* FILENAME_IVOICE_ROM;

        CHAR programName[_MAX_FNAME];
        char romdir_intv[_MAX_DIR];
        char romdir_5200[_MAX_DIR];

        ListItem itmIntvGame[MAX_GAMES];
};

#endif
