#include <stdio.h>
#include <stdlib.h>
//#include <unistd.h>

#include "mp3.h"

//#include "getch2.h"
//#include "keycodes.h"

void print_help(){
  printf("Usage: mp3 file1.mp3 [file2..]\n");
}

int main(int argc,char* argv[]){
int e;
int hdrflag;
int i;
int fsize;
int quitflag=0;
  printf("\n\nAmpg123 v0.1 (C) 1998-2000 A'rpi/ESP-team and mpg123 developers.\n\n");
  if(argc<=1){ print_help();return 0;}
  // Init decoder:
  MP3_Init();
  // Init audio device:
  if(!MP3_OpenDevice(NULL)){ printf("Can't open audio device\n");exit(1);}
  load_termcap(NULL);
  getch2_enable();

for(i=1;i<argc && !quitflag;i++){
  printf("\n==============================================================================\n");
  printf("Playing  %s\n",argv[i]);
  printf("------------------------------------------------------------------------------\n");
  // Open MP3 file and init buffers:
  fsize=MP3_Open(argv[i],128*1024);
  if(!fsize){printf("File not found!\n");continue;}
  hdrflag=0; e=0;
  // Start player:
  MP3_Play();
  // Wait for EOF
  while(!MP3_eof){
     int len=MP3_FillBuffers(); // You have to call this if you're using buffers
     if(len) printf("FillBuffers %d\n",len);
     if(!hdrflag && MP3_frames>2){MP3_PrintHeader();hdrflag=1;}
     if(hdrflag && MP3_frames!=e && MP3_framesize>0){
       int tframes=fsize/MP3_framesize;
       int ftime=(MP3_frames*1152)/(MP3_samplerate?MP3_samplerate:44100);
//       int ttime=(tframes*1152)/44100;
//       int ftime=MP3_fpos/(125*MP3_bitrate);
       int ttime=fsize/(125*MP3_bitrate);
       printf("\rFrame:%7d/%5d (%2d%%)  Time: %2d:%02d [%d:%02d]  BR: %3d  FS: %3d  SR: %5d ",
         MP3_frames,tframes,(int)(100.0f*(float)MP3_fpos/fsize),
         ftime/60,ftime%60, ttime/60,ttime%60,
         MP3_bitrate,MP3_framesize,MP3_samplerate);
       fflush(stdout);
       e=MP3_frames;
     }
     usleep(10000); // don't eat all of CPU
     switch(getch2(0)){
       case KEY_RIGHT:
       case '.':
          MP3_SeekForward(30); break;      // >> 1 sec
       case KEY_UP:
       case '>':
          MP3_SeekForward(300); break;     // >> 10 sec
       case KEY_LEFT:
       case ',':
          MP3_SeekFrame(-30,SEEK_CUR); break;   // << 1 sec
       case KEY_DOWN:
       case '<':
          MP3_SeekFrame(-300,SEEK_CUR); break;  // << 10 sec
       case KEY_HOME:
       case 'h':
          MP3_SeekFrame(0,SEEK_SET); break;  // re-start track
       case KEY_END:
       case 'e':
          MP3_SeekFrame(-(10*38),SEEK_END); break;  // last 10 seconds
       case 'p':
          MP3_pause=1-MP3_pause; break; // toggle pause playing
       case 'P':
          MP3_pause=1; break;           // pause playing
       case KEY_ENTER: MP3_eof=1; break;  // skip this track
       case 'q':
       case KEY_ESC:
          MP3_eof=1;quitflag=1;break; // quit player
     }
  }
//  printf("\r                        \n");
  printf("\n");
  // Stop player:
  MP3_Stop();
  // Close file & buffers:
  MP3_Close();
}
  getch2_disable();
  // Close audio device:
  MP3_CloseDevice();
return 0;
}
