


CXBoxSample *g_app ;
CDebugClient *g_debugClient ;

#ifdef __cplusplus
extern "C" {
#endif

void writexbox( char *msg ) ;
char global_error_message[1024] ;

#ifdef __cplusplus
}
#endif

#define IN_GAME						0
#define IN_GAME_PAUSED				1
#define MAIN_MENU					2
#define INIT_SYSTEM					3
#define INIT_SYSTEM_SHOW_SCREEN     4

#define NAMES_PER_PAGE 25



SoundXBOX *g_sound ;
Mp3Player *g_mp3player ;
float     *g_apptime ;
UINT32    *g_numframes ;
DWORD     g_dwStartTime ;
DWORD     g_dwTimePaused ;

void CXBoxSample::fillPresentationParams()
{
	IDirect3D8 *pD3D ;

    ZeroMemory( &m_d3dpp, sizeof(m_d3dpp) );
    m_d3dpp.BackBufferWidth        = 640;
    m_d3dpp.BackBufferHeight       = 480;
    m_d3dpp.BackBufferFormat       = D3DFMT_A8R8G8B8 ;
    m_d3dpp.BackBufferCount        = 1;
    m_d3dpp.EnableAutoDepthStencil	=	TRUE;
    m_d3dpp.AutoDepthStencilFormat	=	D3DFMT_D24S8;
    m_d3dpp.SwapEffect             = D3DSWAPEFFECT_DISCARD;
    m_d3dpp.MultiSampleType			=	D3DMULTISAMPLE_NONE;


	bool bProgressive=false;
	/*
	DWORD XVideoStandard = XGetVideoStandard();
	DWORD XVidMode = XGetVideoFlags();
	if ( XVidMode & XC_VIDEO_FLAGS_HDTV_720p) bProgressive=true;
	if ( XVidMode & XC_VIDEO_FLAGS_HDTV_480p) bProgressive=true;

	if( NULL != ( pD3D = Direct3DCreate8(D3D_SDK_VERSION) ) )
	{
		DWORD XNumModes = pD3D->GetAdapterModeCount( D3DADAPTER_DEFAULT );

		for( DWORD i = 0; i < XNumModes; i++ )
		{
			D3DDISPLAYMODE Mode;
			if( FAILED( pD3D->EnumAdapterModes( D3DADAPTER_DEFAULT, i, &Mode ) ) )
				break;

			if (Mode.RefreshRate==60)
			{
				//mp_msg(0,0,"%ix%i\n", Mode.Width,Mode.Height);
			}


			if (Mode.Width != 640)
				continue;


			if( ((XVidMode & XC_VIDEO_FLAGS_WIDESCREEN) != 0) &&
			    ((Mode.Flags & D3DPRESENTFLAG_WIDESCREEN) == 0) )
				continue;

			if( ((XVidMode & XC_VIDEO_FLAGS_WIDESCREEN) == 0) &&
			    ((Mode.Flags & D3DPRESENTFLAG_WIDESCREEN) != 0) )
				continue;

			if( (XVidMode & XC_VIDEO_FLAGS_HDTV_720p) != 0)
			{
				if( (Mode.Flags & D3DPRESENTFLAG_PROGRESSIVE) == 0)
					continue;
				if (Mode.Height != 720)
					continue;
			}
			
			if( (XVidMode & XC_VIDEO_FLAGS_HDTV_480p) != 0)
			{
				if( (Mode.Flags & D3DPRESENTFLAG_PROGRESSIVE) == 0)
					continue;
				if( Mode.Height != 480 )
					continue;
			}

			if( (XVidMode & (XC_VIDEO_FLAGS_HDTV_720p|XC_VIDEO_FLAGS_HDTV_480p)) == 0 &&
				(Mode.Flags & D3DPRESENTFLAG_PROGRESSIVE) != 0) 
				continue;

			if( (XVidMode & XC_VIDEO_FLAGS_HDTV_1080i) != 0 )
			{
				if( (Mode.Flags & D3DPRESENTFLAG_INTERLACED) == 0)
					continue;
				if( Mode.Height != 1080 )
					continue;
			}
			else if( (Mode.Flags & D3DPRESENTFLAG_PROGRESSIVE) &&  !bProgressive)
				continue;
			else if( (Mode.Flags & D3DPRESENTFLAG_INTERLACED) &&  bProgressive)
				continue;

			if ( XVideoStandard==XC_VIDEO_STANDARD_PAL_I)
			{
				// pal, disable ntsc resolutions
				if (Mode.Width==640 && Mode.Height==480 && (Mode.Flags & D3DPRESENTFLAG_INTERLACED)) continue;
				if (Mode.Width==720 && Mode.Height==480 && (Mode.Flags & D3DPRESENTFLAG_INTERLACED)) continue;
			}
			else
			{
				// ntsc, disable pal resolutions
				if (Mode.Width=640 && Mode.Height==576 && (Mode.Flags & D3DPRESENTFLAG_INTERLACED)) continue;
				if (Mode.Width=720 && Mode.Height==576 && (Mode.Flags & D3DPRESENTFLAG_INTERLACED)) continue;
			}

			// As near as we can tell, this is the video mode that matches
			// what the dashboard set.
			if ( (m_d3dpp.BackBufferWidth	< Mode.Width || m_d3dpp.BackBufferHeight < Mode.Height) )
			{
				m_d3dpp.BackBufferWidth	= Mode.Width;
				m_d3dpp.BackBufferHeight = Mode.Height;
				m_d3dpp.BackBufferFormat = Mode.Format;
				//
			}
		}
		SAFE_RELEASE(pD3D);
	}
*/

	if(XGetVideoStandard() == XC_VIDEO_STANDARD_PAL_I)
	{
		//get supported video flags
		DWORD videoFlags = XGetVideoFlags();
		
		//set pal60 if available.
		if(videoFlags & XC_VIDEO_FLAGS_PAL_60Hz)
			m_d3dpp.FullScreen_RefreshRateInHz = 60 ;
		else
			m_d3dpp.FullScreen_RefreshRateInHz = 50 ;
	}
	else
		m_d3dpp.FullScreen_RefreshRateInHz = 60 ;


	//m_d3dpp.Flags |= ((XGetVideoFlags() & XC_VIDEO_FLAGS_WIDESCREEN)) ? D3DPRESENTFLAG_WIDESCREEN : 0;
	//m_d3dpp.Flags |= bProgressive ? D3DPRESENTFLAG_PROGRESSIVE : D3DPRESENTFLAG_INTERLACED;

	//xbApp.m_d3dpp.FullScreen_RefreshRateInHz			 =50 ;
	//m_d3dpp.FullScreen_RefreshRateInHz			 =D3DPRESENT_RATE_DEFAULT ;
	//xbApp.m_d3dpp.BackBufferWidth									= (INT) g_graphicsContext.GetWidth();
	//xbApp.m_d3dpp.BackBufferHeight								= (INT) g_graphicsContext.GetHeight();
	m_d3dpp.BackBufferFormat								= D3DFMT_A8R8G8B8 ;
	m_d3dpp.BackBufferCount									= 1;
	m_d3dpp.EnableAutoDepthStencil					= FALSE;
	m_d3dpp.SwapEffect                      = D3DSWAPEFFECT_DISCARD;
	m_d3dpp.FullScreen_PresentationInterval = D3DPRESENT_INTERVAL_DEFAULT;
	//m_d3dpp.FullScreen_PresentationInterval = D3DPRESENT_INTERVAL_IMMEDIATE;
}


//-----------------------------------------------------------------------------
// Name: main()
// Desc: Entry point to the program.
//-----------------------------------------------------------------------------
VOID __cdecl main()
{

	g_debugClient = NULL ;

	CXBoxSample xbApp;

	g_app = &xbApp ;



	xbApp.fillPresentationParams() ;


	memcpy( &xbApp.m_origPP, &xbApp.m_d3dpp, sizeof(xbApp.m_origPP) ) ;


    if( FAILED( xbApp.Create() ) )
	{
        return;
	}


	writexbox("finished create\r\n") ;

/*
	//check for pal60 mode
	if(XGetVideoStandard() == XC_VIDEO_STANDARD_PAL_I)
	{
		//get supported video flags
		DWORD videoFlags = XGetVideoFlags();
		
		//set pal60 if available.
		if(videoFlags && XC_VIDEO_FLAGS_PAL_60Hz)
			xbApp.SetRefreshRate(60) ;
		else
			xbApp.SetRefreshRate(50) ;
	}
	else
		xbApp.SetRefreshRate(60) ;
*/

			//xbApp.SetRefreshRate(60) ;

/*	//check for pal60 mode
	if(XGetVideoStandard() == XC_VIDEO_STANDARD_PAL_I)
	{
		//get supported video flags
		DWORD videoFlags = XGetVideoFlags();
		
		//set pal60 if available.
		if(videoFlags && XC_VIDEO_FLAGS_PAL_60Hz)
			xbApp.m_d3dpp.FullScreen_RefreshRateInHz = 60 ;
		else
			xbApp.m_d3dpp.FullScreen_RefreshRateInHz = 50 ;
	}
	else
		xbApp.m_d3dpp.FullScreen_RefreshRateInHz = 60 ;
*/

    xbApp.Run();
}




BOOL CXBoxSample::SetRefreshRate(INT iRefreshRate)
{
	char xmsg[100] ;

	/*
	CHAR szDebug[64];
	wsprintf(szDebug,"SetRefreshRate: %d\n",iRefreshRate);
	OutputDebugString(szDebug);

	BOOL bIsUsingWidescreenSignal	= m_d3dpp.Flags & D3DPRESENTFLAG_WIDESCREEN;
	BOOL bIsUsingPAL							= XGetVideoStandard() & XC_VIDEO_STANDARD_PAL_I;
	BOOL bSupports60Hz						= ( (XGetVideoFlags() & XC_VIDEO_FLAGS_PAL_60Hz) || (!bIsUsingPAL) );

	
	if ( (!bIsUsingPAL) && (iRefreshRate==50) )
	{
		OutputDebugString("User display does not support 50hz\n");
		return FALSE;
	}

	if ( (!bSupports60Hz) && (iRefreshRate==60) )
	{
		OutputDebugString("User display does not support 60hz\n");
		return FALSE;
	}

	/* resolutions which support pal 60:
	/* 640x480, 720x480 
	/* 640x240, 720x240 

	bool bResolutionOK=false;
	if (m_d3dpp.BackBufferWidth ==640 && m_d3dpp.BackBufferHeight==480) bResolutionOK=true;
	if (m_d3dpp.BackBufferWidth ==720 && m_d3dpp.BackBufferHeight==480) bResolutionOK=true;
	if (m_d3dpp.BackBufferWidth ==640 && m_d3dpp.BackBufferHeight==240) bResolutionOK=true;
	if (m_d3dpp.BackBufferWidth ==720 && m_d3dpp.BackBufferHeight==240) bResolutionOK=true;
	if ( !bResolutionOK && bIsUsingPAL && (iRefreshRate==60) )
	{
		wsprintf(szDebug,	"Unable to use PAL60 at %dx%d resolution.\n",
							m_d3dpp.BackBufferWidth,
							m_d3dpp.BackBufferHeight);
		OutputDebugString(szDebug);
		return FALSE;
	}

	if ( (bIsUsingPAL && bIsUsingWidescreenSignal) && (iRefreshRate==60) )
	{
		OutputDebugString("Xbox hardware does not support PAL60 and widescreen signal.\n");
		OutputDebugString("Widescreen signal has been disabled.\n");
		m_d3dpp.Flags ^= D3DPRESENTFLAG_WIDESCREEN;
	}
	*/

	//if (m_d3dpp.FullScreen_RefreshRateInHz != iRefreshRate)
	//{
		m_d3dpp.FullScreen_RefreshRateInHz = iRefreshRate;
	DWORD res = 	m_pd3dDevice->Reset(&m_d3dpp);

	sprintf(xmsg, "res=%u, ok=%u\r\n", res, DS_OK ) ;
	writexbox(xmsg) ;

	//}

	return TRUE;
}


//-----------------------------------------------------------------------------
// Name: CXBoxSample (constructor)
// Desc: Constructor for CXBoxSample class
//-----------------------------------------------------------------------------
CXBoxSample::CXBoxSample() 
            :CXBApplication()
{
    m_bDrawHelp = FALSE;
	m_state = MAIN_MENU ;
	files = NULL ;
	global_error_message[0] = 0 ;
	g_sound = &m_sound ;
	g_mp3player = &m_mp3player ;
	g_apptime = &m_fAppTime ;
	g_numframes = &m_numFrames ;

	m_steps = 0 ;

}




int CXBoxSample::init_white_texture()
{
	// Release any previous texture
	if (WhiteTexture) 
	{ 
		WhiteTexture->Release();
		WhiteTexture = NULL;
	}
	
	// Create the texture
	D3DXCreateTexture(m_pd3dDevice, 16, 16, 0, 0, D3DFMT_A8R8G8B8, D3DPOOL_DEFAULT, &WhiteTexture);
	
	D3DSURFACE_DESC desc;
    WhiteTexture->GetLevelDesc(0, &desc);


	RECT rectSource;
	rectSource.top = 0;
	rectSource.left = 0;
	rectSource.bottom = 15;
	rectSource.right  = 15 ;

	D3DLOCKED_RECT d3dlr;
	WhiteTexture->LockRect(0, &d3dlr, &rectSource, 0);

	memset( d3dlr.pBits, 0xFF, desc.Size ) ;

	// Unlock our texture
	WhiteTexture->UnlockRect(0);

	if ( MenuSprite == NULL )
		D3DXCreateSprite(m_pd3dDevice, &MenuSprite);

	return 0;
}


//-----------------------------------------------------------------------------
// Name: Initialize
// Desc: Peforms initialization
//-----------------------------------------------------------------------------
HRESULT CXBoxSample::Initialize()
{
	//if ( m_debugClient.Init( "192.168.123.77", 7654, 1 ) == 0 )
	//{
		//strcpy( global_error_message, "*debugclientinit" ) ;
		//return 0 ;
	//}

	//m_logfile = fopen( "D:\\err.log", "wb" ) ;


	g_debugClient = &m_debugClient ;

	m_Font.Initialize( m_pd3dDevice ) ;

    // Create DirectSound
    if( FAILED( DirectSoundCreate( NULL, &(m_sound.dsound),  NULL ) ) )
        return E_FAIL;

    // Create DirectSound
    if( FAILED( DirectSoundCreate( NULL, &(m_mp3player.dsound),  NULL ) ) )
        return E_FAIL;

	if ( ( XCreateSaveGame( "U:\\", PLATFORM_SAV, OPEN_ALWAYS, 0, g_savePath, 500 ) ) != ERROR_SUCCESS )
        return E_FAIL;

	m_sound.dsound_init() ;
	m_mp3player.dsound_init() ;

	m_sound.m_fps = m_d3dpp.FullScreen_RefreshRateInHz ;
	m_mp3player.m_fps = m_d3dpp.FullScreen_RefreshRateInHz ;


	m_state = INIT_SYSTEM ;

	return S_OK ;
}


HRESULT CXBoxSample::InitializeWithScreen()
{
	FILE *inifile ;
	char initext[100] ;
	char *fpos, *epos ;
	int numread ;
	char tmpfilename[MAX_PATH] ;

	m_pd3dDevice->Clear( 0L, NULL, D3DCLEAR_ZBUFFER|D3DCLEAR_STENCIL,
						 0x00000000, 1.0f, 0L );
	RenderGradientBackground( 0xFF000000, 0xFF000000 );

	m_nXOffset = 32 ;
	m_Font.SetFontHeight( 24 ) ;

	//m_pnlBackground.Render(0,10,1024,480);
	m_Font.Begin();
	m_Font.DrawText( (float)m_nXOffset + 32, 16*2, 0xffffffff, READING_ROMS_STRING  ) ;
	m_Font.End();
	m_pd3dDevice->Present( NULL, NULL, NULL, NULL );


	strcpy( m_szCurrentDir, DEFAULT_PARENT_DIR ) ;

	fGameSelect = 0.0f;
	iGameSelect = 0;
	fCursorPos = 0.0f;
	iCursorPos = 0;
	fMaxCount = 0.0f;
	curr = 0 ;
	topIdx = 0 ;
	numfiles = 0 ;

	int *iparams[6] ;

	m_nXOffset = 0 ;
	m_nFontHeight = 16 ;
	m_nScreenX = 50 ;
	m_nScreenY = 50 ;
	m_nScreenMaxX = 600 ;
	m_nScreenMaxY = 400 ;

	iparams[0] = &m_nXOffset ;
	iparams[1] = &m_nFontHeight ;
	iparams[2] = &m_nScreenX ;
	iparams[3] = &m_nScreenY ;
	iparams[4] = &m_nScreenMaxX ;
	iparams[5] = &m_nScreenMaxY ;

	int paramnum ;
	paramnum =0 ;

	strcpy( tmpfilename, g_savePath ) ;
	strcat( tmpfilename, PLATFORM_INI ) ;

	inifile = fopen( tmpfilename, "r" ) ;

	if ( inifile != NULL )
	{
		numread = fread( initext, sizeof(char), 100, inifile ) ;
		fclose( inifile ) ;

		fpos = initext ;

		while ( ( paramnum < 6 ) && ( ( epos = strchr( fpos, ' ' ) ) != NULL )  )
		{
			*epos = 0 ;

			*iparams[paramnum] = atoi( fpos ) ;

			fpos = epos + 1 ;

			if ( fpos - initext > 99 )
				break ;
			paramnum++ ;
		}

	}

	if ( m_nFontHeight <= 5 )
		m_nFontHeight = 12 ;

	if ( m_nFontHeight > 50 )
		m_nFontHeight = 16 ;


	m_Font.SetFontHeight( m_nFontHeight ) ;

	m_namesPerPage =  (25*14 ) / ( m_Font.GetFontHeight()-2) ;


	m_msgDelay = 0 ;
	wcscpy( m_strMessage, L" " ) ;
	
	g_pBlitBuff = NULL ;
	g_pAlignBuff = NULL ;
	WhiteTexture = NULL ;
	Texture = NULL ;
	Sprite = NULL ;
	MenuSprite = NULL ;
	m_cheatCodes = NULL ;
	m_numCheats = 0 ;

	init_white_texture();

	g_saveprefix[0] = 0 ;

	FindAvailRoms(PLATFORM_FILE_DIR) ;


	m_memBuf1 = (byte*)malloc( CONSOLE_MEMORY_SIZE ) ;
	m_memBuf2 = (byte*)malloc( CONSOLE_MEMORY_SIZE ) ;
	m_memMatches = (byte*)malloc( CONSOLE_MEMORY_SIZE ) ;
	m_consoleMemory = (byte*)PLATFORM_MEMORY_POINTER ;



	m_state = MAIN_MENU ;

	if ( m_mp3player.loadFile( THEMEMUSIC, 1, 0,9999999 ) )
	{
		//writexbox( "nonomp3\r\n") ;
	}
	else
	{
		//m_mp3player.insertSilence( 22050 ) ;
		m_mp3player.pause( FALSE ) ;
	}

    return S_OK;
}


void CXBoxSample::doSaveConfig()
{
	FILE *inifile ;
	char tmpfilename[MAX_PATH] ;

	strcpy( tmpfilename, g_savePath ) ;
	strcat( tmpfilename, PLATFORM_INI ) ;

	inifile = fopen( tmpfilename, "wb" ) ;

	if ( inifile != NULL )
	{
		fprintf( inifile, "%u %u %u %u %u %u  \r\n", m_nXOffset, m_nFontHeight, m_nScreenX, m_nScreenY, m_nScreenMaxX, m_nScreenMaxY ) ;
		fclose( inifile ) ;
	}

}

void CXBoxSample::doConfiguration()
{

	WCHAR deleteline[200] ;
	int deleted ;

	int menuChoice = 0 ;

	deleted = 0 ;


	while ( 1 )
	{
		m_pd3dDevice->Clear( 0L, NULL, D3DCLEAR_ZBUFFER|D3DCLEAR_STENCIL,
							 0x00000000, 1.0f, 0L );
		RenderGradientBackground( 0xFF000000, 0xFF000000 );
		m_pnlBackground.Render(0,10,1024,480);
		m_mp3player.process() ;

		float fWinX = 32, fWinY = 80;

		MenuBar( m_nXOffset+(int)fWinX, MLINE(menuChoice) + 3, 530, m_nFontHeight+3 ) ;

		swprintf( deleteline, L"Click here to delete save files for %S", files[curr].filename ) ;

		m_Font.Begin();
		m_Font.DrawText( (float)(m_nXOffset+  32), (float)(16*2), 0xffffffff, L"CONFIGURATION" );
		m_Font.DrawText( (float)m_nXOffset+  32, MLINE(0), menuChoice==0 ? 0xff000000 : 0xffffffff, L"Set Game List Font Size" );
		m_Font.DrawText( (float)m_nXOffset+  32, MLINE(1), menuChoice==1 ? 0xff000000 : 0xffffffff, L"Set Text Offset (push menu text to the right)" );
		m_Font.DrawText( (float)m_nXOffset+  32, MLINE(2), menuChoice==2 ? 0xff000000 : 0xffffffff, L"Set Game Screen Size/Position" );
		m_Font.DrawText( (float)m_nXOffset+  32, MLINE(3), menuChoice==3 ? 0xff000000 : 0xffffffff, L"Emulator specific options" );
		m_Font.DrawText( (float)m_nXOffset+  32, MLINE(4), menuChoice==4 ? 0xff000000 : 0xffffffff, deleteline );
		m_Font.DrawText( (float)m_nXOffset+  32, MLINE(5), menuChoice==5 ? 0xff000000 : 0xffffffff, L"Configure Plaything" );
		m_Font.DrawText( (float)m_nXOffset+  32, MLINE(7), 0xffffffff, L"Press B to go back" );

		if ( deleted )
		{
			m_Font.DrawText( (float)m_nXOffset+  32, MLINE(8), 0xffffffff, L"Save files deleted" );
		}

		m_Font.End();

		
		m_pd3dDevice->Present( NULL, NULL, NULL, NULL );

		if ( deleted )
		{
			deleted = 0 ;
			Sleep( 1000 ) ;
			continue ;
		}

        XBInput_GetInput();
		if(g_Gamepads[0].hDevice && g_Gamepads[0].bPressedAnalogButtons[XINPUT_GAMEPAD_B])
		{
	        XBInput_GetInput();
			break ;
		}
		else if ( g_Gamepads[0].hDevice && g_Gamepads[0].wPressedButtons & XINPUT_GAMEPAD_DPAD_DOWN )
		{
			menuChoice = (menuChoice+1)%6 ;
		}
		else if ( g_Gamepads[0].hDevice && g_Gamepads[0].wPressedButtons & XINPUT_GAMEPAD_DPAD_UP )
		{
			if ( menuChoice == 0 )
				menuChoice = 5 ;
			else
				menuChoice = (menuChoice-1)%6 ;
		}
		else if(g_Gamepads[0].hDevice && g_Gamepads[0].bPressedAnalogButtons[XINPUT_GAMEPAD_A])
		{
			switch ( menuChoice )
			{
				case 0 : doFontSize() ; break ;
				case 1 : doTextOffset() ; break ;
				case 2 : doScreenSize() ; break ;
				case 3 : doEmulatorOptions() ; break ;
				case 4 : deleteSaveFiles( curr ) ; deleted = 1 ;break ;
				case 5 : doConfigurePlaything() ; break ;
				default : break ;
			}
		}


	}

}


void CXBoxSample::doFontSize()
{
	WCHAR str[200];
	int value ;

	value = m_Font.GetFontHeight() ;

	while ( 1 )
	{
		m_pd3dDevice->Clear( 0L, NULL, D3DCLEAR_ZBUFFER|D3DCLEAR_STENCIL,
							 0x00000000, 1.0f, 0L );
		RenderGradientBackground( 0xFF000000, 0xFF000000 );
		m_pnlBackground.Render(0,10,1024,480);
		m_mp3player.process() ;

		swprintf( str, L"Use DPAD to adjust current value : %u", value ) ;

		m_Font.Begin();
		m_Font.DrawText( (float)m_nXOffset+  32, 16*2, 0xffffffff, L"Set Game List Font Size" );
		m_Font.DrawText( (float)m_nXOffset+  32, MLINE(0), 0xffffffff, str) ;
		m_Font.DrawText( (float)m_nXOffset+  32, MLINE(2), 0xffffffff, L"Press A to accept" );
		m_Font.DrawText( (float)m_nXOffset+  32, MLINE(3), 0xffffffff, L"Press B to go back" );
		m_Font.End();

		m_pd3dDevice->Present( NULL, NULL, NULL, NULL );

        XBInput_GetInput();
		if(g_Gamepads[0].hDevice && g_Gamepads[0].bPressedAnalogButtons[XINPUT_GAMEPAD_B])
		{
			break ;
		}
		else if ( g_Gamepads[0].hDevice && g_Gamepads[0].wPressedButtons & XINPUT_GAMEPAD_DPAD_DOWN ) 
		{
			if ( value )
				value-- ;

			m_Font.SetFontHeight( value ) ;

		}
		else if ( g_Gamepads[0].hDevice && g_Gamepads[0].wPressedButtons & XINPUT_GAMEPAD_DPAD_UP ) 
		{
			if ( value < 50 )
				value++ ;

			m_Font.SetFontHeight( value ) ;
		}
		else if ( g_Gamepads[0].hDevice && g_Gamepads[0].wPressedButtons & XINPUT_GAMEPAD_DPAD_LEFT ) 
		{
			if ( value )
				value-- ;

			m_Font.SetFontHeight( value ) ;
		}
		else if ( g_Gamepads[0].hDevice && g_Gamepads[0].wPressedButtons & XINPUT_GAMEPAD_DPAD_RIGHT ) 
		{
			if ( value < 50 )
				value++ ;

			m_Font.SetFontHeight( value ) ;
		}
		else if(g_Gamepads[0].hDevice && g_Gamepads[0].bPressedAnalogButtons[XINPUT_GAMEPAD_A])
		{
			
			m_nFontHeight = m_Font.GetFontHeight() ;
			m_namesPerPage =  (25*14 ) / ( m_nFontHeight-2) ;

			doSaveConfig() ;

			break ;
		}


	}

}

void CXBoxSample::doScreenSize()
{
	WCHAR str[200];
	int x, y, maxx, maxy ;
	float fx, fy, fmaxx, fmaxy ;

	x = m_nScreenX ;
	y = m_nScreenY ;
	maxx = m_nScreenMaxX;
	maxy = m_nScreenMaxY ;

	fx = (float)x ;
	fy = (float)y ;
	fmaxx = (float)maxx ;
	fmaxy = (float)maxy ;

	while ( 1 )
	{
		m_pd3dDevice->Clear( 0L, NULL, D3DCLEAR_ZBUFFER|D3DCLEAR_STENCIL,
							 0x00000000, 1.0f, 0L );
		RenderGradientBackground( 0xFF000000, 0xFF000000 );
		//m_pnlBackground.Render(0,10,1024,480);
		m_mp3player.process() ;

		x = (int)fx ;
		y = (int)fy ;
		maxx = (int)fmaxx ;
		maxy = (int)fmaxy ;
		MenuBar( x, y, maxx, maxy ) ;

		m_Font.Begin();
		m_Font.DrawText( (float)m_nXOffset+  132, MLINE(6), 0xff00ff00, L"Set Game Screen Size" );

		m_Font.DrawText( (float)m_nXOffset+  132, MLINE(8), 0xff00ff00, L"Use RThumb and LThumb to adjust screen size/pos" );
		m_Font.DrawText( (float)m_nXOffset+  132, MLINE(9), 0xff00ff00, L"Press A to accept" );
		m_Font.DrawText( (float)m_nXOffset+  132, MLINE(10), 0xff00ff00, L"Press B to go back" );

		swprintf( str, L"X=%u Y=%u MAXX=%u MAXY=%u", x, y, maxx, maxy ) ;
		m_Font.DrawText( (float)m_nXOffset+  132, MLINE(12), 0xff00ff00, str );

		m_Font.End();

		m_pd3dDevice->Present( NULL, NULL, NULL, NULL );

        XBInput_GetInput();
		if(g_Gamepads[0].hDevice && g_Gamepads[0].bPressedAnalogButtons[XINPUT_GAMEPAD_B])
		{
			break ;
		}
		else if(g_Gamepads[0].hDevice && g_Gamepads[0].bPressedAnalogButtons[XINPUT_GAMEPAD_A])
		{
			m_nScreenX = x ;
			m_nScreenY = y ;
			m_nScreenMaxX = maxx ;
			m_nScreenMaxY = maxy ;
			doSaveConfig() ;
			break ;
		}
		else
		{
			if ( g_Gamepads[0].hDevice )
			{
				fx += g_Gamepads[0].fX1 ;
				fy -= g_Gamepads[0].fY1 ;
				fmaxx += g_Gamepads[0].fX2 ;
				fmaxy -= g_Gamepads[0].fY2 ;
			}
		}
	}

}

void CXBoxSample::doTextOffset()
{
	WCHAR str[200];
	int value ;

	value = m_nXOffset ;

	while ( 1 )
	{
		m_pd3dDevice->Clear( 0L, NULL, D3DCLEAR_ZBUFFER|D3DCLEAR_STENCIL,
							 0x00000000, 1.0f, 0L );
		RenderGradientBackground( 0xFF000000, 0xFF000000 );
		m_pnlBackground.Render(0,10,1024,480);
		m_mp3player.process() ;

		swprintf( str, L"Use DPAD to adjust current value : %u", value ) ;

		m_Font.Begin();
		m_Font.DrawText( (float)value+  32, 16*2, 0xffffffff, L"Set Menu Text Offset" );
		m_Font.DrawText( (float)value+  32, MLINE(0), 0xffffffff, str) ;
		m_Font.DrawText( (float)value+  32, MLINE(2), 0xffffffff, L"Press A to accept" );
		m_Font.DrawText( (float)value+  32, MLINE(3), 0xffffffff, L"Press B to go back" );
		m_Font.End();

		m_pd3dDevice->Present( NULL, NULL, NULL, NULL );

        XBInput_GetInput();
		if(g_Gamepads[0].hDevice && g_Gamepads[0].bPressedAnalogButtons[XINPUT_GAMEPAD_B])
		{
			break ;
		}
		else if ( g_Gamepads[0].hDevice && g_Gamepads[0].wPressedButtons & XINPUT_GAMEPAD_DPAD_DOWN ) 
		{
			value = ( value - 1 ) & 0xFF ;
		}
		else if ( g_Gamepads[0].hDevice && g_Gamepads[0].wPressedButtons & XINPUT_GAMEPAD_DPAD_UP ) 
		{
			value = ( value + 1 ) & 0xFF ;
		}
		else if ( g_Gamepads[0].hDevice && g_Gamepads[0].wPressedButtons & XINPUT_GAMEPAD_DPAD_LEFT ) 
		{
			value = ( value - 10 ) & 0xFF ;
		}
		else if ( g_Gamepads[0].hDevice && g_Gamepads[0].wPressedButtons & XINPUT_GAMEPAD_DPAD_RIGHT ) 
		{
			value = ( value + 10  ) & 0xFF ;
		}
		else if(g_Gamepads[0].hDevice && g_Gamepads[0].bPressedAnalogButtons[XINPUT_GAMEPAD_A])
		{
			m_nXOffset = value ;
			doSaveConfig() ;
			break ;
		}


	}

}



void CXBoxSample::doStartSearchMenu()
{

	memcpy( m_memBuf1, m_consoleMemory, CONSOLE_MEMORY_SIZE ) ;
	memset( m_memMatches, 1, CONSOLE_MEMORY_SIZE ) ;
	m_currentMemMatches = CONSOLE_MEMORY_SIZE ;

	while ( 1 )
	{
		m_pd3dDevice->Clear( 0L, NULL, D3DCLEAR_ZBUFFER|D3DCLEAR_STENCIL,
							 0x00000000, 1.0f, 0L );
		RenderGradientBackground( 0xFF000000, 0xFF000000 );
		m_pnlBackground.Render(0,10,1024,480);

		m_Font.Begin();
		m_Font.DrawText( (float)m_nXOffset+ 32, 16*2, 0xffffffff, L"The search has begun.  " );
		m_Font.DrawText(  (float)m_nXOffset+32, MLINE(0), 0xffffffff, L"Press B to go back to the Options menu." );
		m_Font.End();

		m_pd3dDevice->Present( NULL, NULL, NULL, NULL );

        XBInput_GetInput();
		if ( g_Gamepads[0].hDevice && g_Gamepads[0].bPressedAnalogButtons[ XINPUT_GAMEPAD_B ] ) 
		{
			break ;
		}
	}
}

void CXBoxSample::doEditCode( int which )
{
	CHEAT_CODE code ;
	int curr_pos ;

	if ( which < 0 )
	{
		strcpy( code.code, "01000000" ) ;
		code.enabled = 1 ;
		code.adr = 0x0000 ;
		code.val = 0 ;
	}
	else
	{
		memcpy( &code, &(m_cheatCodes[which]), sizeof(CHEAT_CODE) ) ;
	}


	curr_pos = 0 ;

	while ( 1 )
	{
		m_pd3dDevice->Clear( 0L, NULL, D3DCLEAR_ZBUFFER|D3DCLEAR_STENCIL,
							 0x00000000, 1.0f, 0L );
		RenderGradientBackground( 0xFF000000, 0xFF000000 );
		m_pnlBackground.Render(0,10,1024,480);

		m_Font.Begin();

		if ( which < 0 )
			m_Font.DrawText((float)m_nXOffset+  32, 16*2, 0xffffffff, L"Add New Cheat Code" );
		else
			m_Font.DrawText( (float)m_nXOffset+ 32, 16*2, 0xffffffff, L"Edit Cheat Code" );

		m_Font.DrawText( (float)m_nXOffset+ 32, MLINE(0), 0xffffffff, L"Press B to cancel." );
		m_Font.DrawText( (float)m_nXOffset+ 32, MLINE(1), 0xffffffff, L"Press A to save." );
		m_Font.DrawText( (float)m_nXOffset+ 32, MLINE(2), 0xffffffff, L"Use DPAD to select/change values." );

		WCHAR str[200];

		for ( int i = 0 ; i < 8 ; i++ )
		{
			swprintf( str, L"%c", (code.code)[i] ) ;
			if ( i == curr_pos+2 )
				m_Font.DrawText( (float)m_nXOffset+  50 + ( i * 16 ), MLINE(4), 0xff00ff00, str ) ;
			else
				m_Font.DrawText( (float)m_nXOffset+  50 + ( i * 16 ), MLINE(4), 0xffffffff, str ) ;
		}

		swprintf( str, L"Address : %04.4X", code.adr ) ;
		m_Font.DrawText( (float)m_nXOffset+  50 , MLINE(6), 0xffffffff, str ) ;
		swprintf( str, L"Value : %u", code.val ) ;
		m_Font.DrawText( (float)m_nXOffset+  50 , MLINE(7), 0xffffffff, str ) ;
		
		m_Font.End();

		m_pd3dDevice->Present( NULL, NULL, NULL, NULL );

        XBInput_GetInput();
		if ( g_Gamepads[0].hDevice && g_Gamepads[0].bPressedAnalogButtons[ XINPUT_GAMEPAD_B ] ) 
		{
			break ;
		}
		else if ( g_Gamepads[0].hDevice && g_Gamepads[0].bPressedAnalogButtons[ XINPUT_GAMEPAD_A ] ) 
		{
			if ( ( code.adr >= CONSOLE_MEMORY_SIZE ) )
			{
				while ( 1 )
				{
					m_pd3dDevice->Clear( 0L, NULL, D3DCLEAR_ZBUFFER|D3DCLEAR_STENCIL,
										 0x00000000, 1.0f, 0L );
					RenderGradientBackground( 0xFF000000, 0xFF000000 );
					m_pnlBackground.Render(0,10,1024,480);

					m_Font.Begin();
					m_Font.DrawText( (float)m_nXOffset+  32, MLINE(0), 0xffffffff, L"The Address must be between 0x0000 and 0x7FFF" );
					m_Font.DrawText( (float)m_nXOffset+  32, MLINE(2), 0xffffffff, L"Press B to try again." );
					m_Font.End();

					m_pd3dDevice->Present( NULL, NULL, NULL, NULL );

					XBInput_GetInput();
					if ( g_Gamepads[0].hDevice && g_Gamepads[0].bPressedAnalogButtons[ XINPUT_GAMEPAD_B ] ) 
					{
						break ;
					}
				}
			}
			else
			{
				if ( which < 0 )
				{
					m_cheatCodes = (CHEAT_CODE*)realloc( m_cheatCodes, sizeof(CHEAT_CODE) * ( m_numCheats  + 1 ) ) ;
					memcpy( &(m_cheatCodes[m_numCheats]),&code, sizeof(CHEAT_CODE) ) ;
					m_numCheats++ ;
				}
				else
				{
					memcpy( &(m_cheatCodes[which]), &code, sizeof(CHEAT_CODE) ) ;
				}
				break ;
			}
		}
		else if ( g_Gamepads[0].hDevice && g_Gamepads[0].wPressedButtons & XINPUT_GAMEPAD_DPAD_DOWN ) 
		{
			switch ( curr_pos )
			{
				case 0 :
				{
					if ( ( ( code.val >> 4 ) &  0x0F ) == 0 )
						code.val = 0xF0 + ( code.val & 0x0F ) ;
					else
						code.val = ( code.val - 0x10 ) & 0xFF ;
					break ;
				}
				case 1 :
				{
					if ( ( code.val & 0x0F ) == 0x00 )
						code.val = 0x0F + ( code.val & 0xF0 ) ;
					else
						code.val = ( code.val - 0x01 ) & 0xFF ;
					break ;
				}
				case 2 :
				{
					if ( ( ( code.adr >> 4 ) &  0x0F ) == 0 )
						code.adr = 0xF0 + ( code.adr & 0xFF0F ) ;
					else
						code.adr = ( code.adr - 0x10 ) & 0xFFFF ;
					break ;
				}
				case 3 :
				{
					if ( ( ( code.adr ) &  0x0F ) == 0 )
						code.adr = 0x0F + ( code.adr & 0xFFF0 ) ;
					else
						code.adr = ( code.adr - 0x01 ) & 0xFFFF ;
					break ;
				}
				case 4 :
				{
					if ( ( ( code.adr >> 12 ) &  0x0F ) == 0 )
						code.adr = 0xF000 + ( code.adr & 0x0FFF ) ;
					else
						code.adr = ( code.adr - 0x1000 ) & 0xFFFF ;
					break ;
				}
				case 5 :
				{
					if ( ( ( code.adr >> 8 ) &  0x0F ) == 0 )
						code.adr = 0x0F00 + ( code.adr & 0xF0FF ) ;
					else
						code.adr = ( code.adr - 0x100 ) & 0xFFFF ;
					break ;
				}
				default : break ;
			}
			sprintf( code.code, "01%02.2X%02.2X%02.2X", code.val, code.adr & 0xFF, (code.adr >> 8 ) & 0xFF ) ;
		}
		else if ( g_Gamepads[0].hDevice && g_Gamepads[0].wPressedButtons & XINPUT_GAMEPAD_DPAD_UP ) 
		{
			switch ( curr_pos )
			{
				case 0 :
				{
					if ( ( ( code.val >> 4 ) &  0x0F ) == 0x0F )
						code.val = 0x00 + ( code.val & 0x0F ) ;
					else
						code.val = ( code.val + 0x10 ) & 0xFF ;
					break ;
				}
				case 1 :
				{
					if ( ( code.val & 0x0F ) == 0x0F )
						code.val = 0x00 + ( code.val & 0xF0 ) ;
					else
						code.val = ( code.val + 0x01 ) & 0xFF ;
					break ;
				}
				case 2 :
				{
					if ( ( ( code.adr >> 4 ) &  0x0F ) == 0x0F )
						code.adr = 0x00 + ( code.adr & 0xFF0F ) ;
					else
						code.adr = ( code.adr + 0x10 ) & 0xFFFF ;
					break ;
				}
				case 3 :
				{
					if ( ( ( code.adr ) &  0x0F ) == 0x0F )
						code.adr = 0x00 + ( code.adr & 0xFFF0 ) ;
					else
						code.adr = ( code.adr + 0x01 ) & 0xFFFF ;
					break ;
				}
				case 4 :
				{
					if ( ( ( code.adr >> 12 ) &  0x0F ) == 0x0F )
						code.adr = 0x0000 + ( code.adr & 0x0FFF ) ;
					else
						code.adr = ( code.adr + 0x1000 ) & 0xFFFF ;
					break ;
				}
				case 5 :
				{
					if ( ( ( code.adr >> 8 ) &  0x0F ) == 0x0F )
						code.adr = 0x0000 + ( code.adr & 0xF0FF ) ;
					else
						code.adr = ( code.adr + 0x100 ) & 0xFFFF ;
					break ;
				}
				default : break ;
			}
			sprintf( code.code, "01%02.2X%02.2X%02.2X", code.val, code.adr & 0xFF, (code.adr >> 8 ) & 0xFF ) ;

		}
		else if ( g_Gamepads[0].hDevice && g_Gamepads[0].wPressedButtons & XINPUT_GAMEPAD_DPAD_LEFT ) 
		{
			if ( curr_pos == 0 )
				curr_pos = 5 ;
			else
				curr_pos-- ;
		}
		else if ( g_Gamepads[0].hDevice && g_Gamepads[0].wPressedButtons & XINPUT_GAMEPAD_DPAD_RIGHT ) 
		{
			if ( curr_pos == 5 )
				curr_pos = 0 ;
			else
				curr_pos++ ;
		}
	}


}

void CXBoxSample::doCodeListMenu()
{

	unsigned int selected  ;
	unsigned int cheatTopIdx ;
	WCHAR str[400];
	CHEAT_CODE *tempbuf ;

	selected = cheatTopIdx = 0 ;

	if ( m_numCheats == 0 )
	{
		while ( 1 )
		{
			m_pd3dDevice->Clear( 0L, NULL, D3DCLEAR_ZBUFFER|D3DCLEAR_STENCIL,
								 0x00000000, 1.0f, 0L );
			RenderGradientBackground( 0xFF000000, 0xFF000000 );
			m_pnlBackground.Render(0,10,1024,480);

			m_Font.Begin();
			m_Font.DrawText( (float)m_nXOffset+  32, 16*2, 0xffffffff, L"Search Code List" );
			m_Font.DrawText( (float)m_nXOffset+  32, MLINE(0), 0xffffffff, L"Press B to go back to the Options menu." );
			m_Font.DrawText( (float)m_nXOffset+  32, MLINE(2), 0xffffffff, L"There are no cheat codes in the list." ) ;

			m_Font.End();

			m_pd3dDevice->Present( NULL, NULL, NULL, NULL );

			XBInput_GetInput();
			if(g_Gamepads[0].hDevice && g_Gamepads[0].bPressedAnalogButtons[XINPUT_GAMEPAD_B])
			{
				return ;
			}
		}
	}
	while ( 1 )
	{
		m_pd3dDevice->Clear( 0L, NULL, D3DCLEAR_ZBUFFER|D3DCLEAR_STENCIL,
							 0x00000000, 1.0f, 0L );
		RenderGradientBackground( 0xFF000000, 0xFF000000 );
		m_pnlBackground.Render(0,10,1024,480);

		m_Font.Begin();
		m_Font.DrawText( (float)m_nXOffset+  32, 16*2, 0xffffffff, L"Search Code List" );
		m_Font.DrawText( (float)m_nXOffset+  32, MLINE(0), 0xffffffff, L"Press B to go back to the Options menu." );
		m_Font.DrawText( (float)m_nXOffset+  32, MLINE(1), 0xffffffff, L"Press A to add a new code." );
		m_Font.DrawText( (float)m_nXOffset+  32, MLINE(2), 0xffffffff, L"Press X to edit the selected code." );
		m_Font.DrawText( (float)m_nXOffset+  32, MLINE(3), 0xffffffff, L"Press Y to enable/disable the selected code." );
		m_Font.DrawText( (float)m_nXOffset+  32, MLINE(4), 0xffffffff, L"Press BLACK to delete the selected code." );
		m_Font.DrawText( (float)m_nXOffset+  32, MLINE(5), 0xffffffff, L"Press UP/DOWN/LS/RS to select code." );

		float fWinX = 32, fWinY = 80;

		MenuBar( m_nXOffset+(int)fWinX, MLINE(7+(selected-cheatTopIdx)) + 3, 530, m_nFontHeight+3 ) ;

		//MenuBar( m_nXOffset+32, 16*(11+(selected-cheatTopIdx)) + 3, 530, 19 ) ;

		for ( unsigned int idx = cheatTopIdx ; ( idx < m_numCheats ) && ( idx < cheatTopIdx+10) ; idx++ )
		{
			CHEAT_CODE *code = &(m_cheatCodes[idx]) ;

			swprintf( str, L"%S Adr:0x%04.4X val:%u %S", code->code, code->adr, code->val, code->enabled ? "ON" : "OFF" ) ;
			
			if ( selected == idx )
				m_Font.DrawText( (float)m_nXOffset+32, (float)( MLINE( 7+(idx-cheatTopIdx))), 0xff000000, str );
			else
				m_Font.DrawText( (float)m_nXOffset+32, (float)( MLINE( 7+(idx-cheatTopIdx))), 0xffffffff, str );
		}
		
		m_Font.End();

		m_pd3dDevice->Present( NULL, NULL, NULL, NULL );

        XBInput_GetInput();
		if(g_Gamepads[0].hDevice && g_Gamepads[0].bPressedAnalogButtons[XINPUT_GAMEPAD_B])
		{
			break ;
		}
		else if(g_Gamepads[0].hDevice && g_Gamepads[0].bPressedAnalogButtons[XINPUT_GAMEPAD_A])
		{
			doEditCode( -1 ) ;
		}
		else if(g_Gamepads[0].hDevice && g_Gamepads[0].bPressedAnalogButtons[XINPUT_GAMEPAD_X])
		{
			doEditCode( selected ) ;
		}
		else if(g_Gamepads[0].hDevice && g_Gamepads[0].bPressedAnalogButtons[XINPUT_GAMEPAD_Y])
		{
			if ( m_cheatCodes[selected].enabled )
				m_cheatCodes[selected].enabled = 0 ;
			else
				m_cheatCodes[selected].enabled = 1 ;
		}
		else if (g_Gamepads[0].hDevice && g_Gamepads[0].bPressedAnalogButtons[XINPUT_GAMEPAD_BLACK]) 
		{
			tempbuf = (CHEAT_CODE*)malloc( sizeof(CHEAT_CODE) * ( m_numCheats - 1 ) ) ;

			memcpy( tempbuf, m_cheatCodes, sizeof(CHEAT_CODE) * selected ) ;

			if ( selected < m_numCheats-1 )
			{
				memcpy( &(tempbuf[selected]), &(m_cheatCodes[selected+1]), sizeof(CHEAT_CODE) * ( (m_numCheats - selected ) - 1) ) ;
			}

			free( m_cheatCodes ) ;

			m_cheatCodes = tempbuf ;
			m_numCheats-- ;
			if ( m_numCheats == 0 )
				break ;

			if ( selected >= (m_numCheats) )
				selected = m_numCheats - 1 ;

		}
		if (g_Gamepads[0].hDevice && g_Gamepads[0].wPressedButtons & XINPUT_GAMEPAD_DPAD_RIGHT )
		{
			if ( cheatTopIdx + 10 < m_numCheats )
			{
				cheatTopIdx += 10 ;
				selected = cheatTopIdx ;
			}
		}
		else if (g_Gamepads[0].hDevice && g_Gamepads[0].wPressedButtons & XINPUT_GAMEPAD_DPAD_LEFT)
		{
			if ( cheatTopIdx >= 10 )
			{
				cheatTopIdx -= 10 ;
				selected = cheatTopIdx ;
			}
		}
		else if ( g_Gamepads[0].hDevice && g_Gamepads[0].wPressedButtons & XINPUT_GAMEPAD_DPAD_DOWN ) 
		{
			if ( selected == cheatTopIdx + (10-1) )
			{
				if ( selected < m_numCheats - 1 )
				{
					cheatTopIdx++ ;
					selected++ ;
				}
			}
			else
			{
				if ( selected < m_numCheats-1 )
					selected++ ;
			}
		}
		else if ( g_Gamepads[0].hDevice && g_Gamepads[0].wPressedButtons & XINPUT_GAMEPAD_DPAD_UP ) 
		{
			if ( selected == cheatTopIdx )
			{
				if ( selected > 0 )
				{
					cheatTopIdx-- ;
					selected-- ;
				}
			}
			else
			{
				if ( selected > 0 )
					selected-- ;
			}
		}

		
		
		
		
	}
}

void CXBoxSample::doAddFoundCodes()
{
	CHEAT_CODE code ;

	for ( int i = 0 ; i < CONSOLE_MEMORY_SIZE ; i++ )
	{
		if ( m_memMatches[i] )
		{
			code.adr = i ;
			code.val = m_memBuf1[i] ;
			code.enabled = 0 ;
			sprintf( code.code, "01%02.2X%02.2X%02.2X", code.val, code.adr & 0xFF, (code.adr >> 8 ) & 0xFF ) ;

			m_cheatCodes = (CHEAT_CODE*)realloc( m_cheatCodes, sizeof(CHEAT_CODE) * ( m_numCheats  + 1 ) ) ;

			memcpy( &(m_cheatCodes[m_numCheats]),&code, sizeof(CHEAT_CODE) ) ;
			m_numCheats++ ;

		}
	}

	memset( m_memMatches, 0, CONSOLE_MEMORY_SIZE ) ;
	m_currentMemMatches = 0 ;

	while ( 1 )
	{
		m_pd3dDevice->Clear( 0L, NULL, D3DCLEAR_ZBUFFER|D3DCLEAR_STENCIL,
							 0x00000000, 1.0f, 0L );
		RenderGradientBackground( 0xFF000000, 0xFF000000 );
		m_pnlBackground.Render(0,10,1024,480);

		m_Font.Begin();
		m_Font.DrawText( (float)m_nXOffset+  32, MLINE(0), 0xffffffff, L"The search found 1 to 4 possible matches for your search." );
		m_Font.DrawText( (float)m_nXOffset+  32, MLINE(1), 0xffffffff, L"They have been added to your list." );
		m_Font.DrawText( (float)m_nXOffset+  32, MLINE(3), 0xffffffff, L"Press B to go back to the Options menu." );
		m_Font.End();

		m_pd3dDevice->Present( NULL, NULL, NULL, NULL );

        XBInput_GetInput();
		if(g_Gamepads[0].hDevice && g_Gamepads[0].bPressedAnalogButtons[XINPUT_GAMEPAD_B])
		{
			break ;
		}
	}
}

void CXBoxSample::doContinueSearchMenu()
{

	WCHAR str[200];
	int value ;

	memcpy( m_memBuf2, m_consoleMemory, CONSOLE_MEMORY_SIZE ) ;
	value = 0 ;

	while ( 1 )
	{
		m_pd3dDevice->Clear( 0L, NULL, D3DCLEAR_ZBUFFER|D3DCLEAR_STENCIL,
							 0x00000000, 1.0f, 0L );
		RenderGradientBackground( 0xFF000000, 0xFF000000 );
		m_pnlBackground.Render(0,10,1024,480);

		m_Font.Begin();
		m_Font.DrawText( (float)m_nXOffset+  32, 16*2, 0xffffffff, L"Search Options" );
		m_Font.DrawText( (float)m_nXOffset+  32, MLINE(0), 0xffffffff, L"Press B to go back to the Options menu." );

		swprintf( str, L"Press X to search for this value : %u", value );
		m_Font.DrawText( (float)m_nXOffset+  32, MLINE(1), 0xffffffff, str );

		m_Font.DrawText( (float)m_nXOffset+  32, MLINE(2), 0xffffffff, L"Press Y to search for values less than before." );
		m_Font.DrawText( (float)m_nXOffset+  32, MLINE(3), 0xffffffff, L"Press A to search for values greater than before." );
		m_Font.DrawText( (float)m_nXOffset+  32, MLINE(4), 0xffffffff, L"Press BLACK to search for values equal to before." );
		m_Font.DrawText( (float)m_nXOffset+  32, MLINE(5), 0xffffffff, L"Press WHITE to search for values not equal to before." );
		m_Font.DrawText( (float)m_nXOffset+  32, MLINE(6), 0xffffffff, L"Press DPAD-UP to add 1 to the value" ) ;
		m_Font.DrawText( (float)m_nXOffset+  32, MLINE(7), 0xffffffff, L"Press DPAD-DOWN to subtract 1 from the value" ) ;
		m_Font.DrawText( (float)m_nXOffset+  32, MLINE(8), 0xffffffff, L"Press DPAD-RIGHT to add 10 to the value" ) ;
		m_Font.DrawText( (float)m_nXOffset+  32, MLINE(9), 0xffffffff, L"Press DPAD-LEFT to subtract 10 from the value" ) ;
		m_Font.DrawText( (float)m_nXOffset+  32, MLINE(10), 0xffffffff, L"Press LS+RS to add the found codes to your list" ) ;

		swprintf( str, L"Number of hits from last search : %u", m_currentMemMatches );
		m_Font.DrawText( (float)m_nXOffset+  32, MLINE(12), 0xffffffff, str );

		m_Font.End();

		m_pd3dDevice->Present( NULL, NULL, NULL, NULL );

        XBInput_GetInput();
		if(g_Gamepads[0].hDevice && g_Gamepads[0].bPressedAnalogButtons[XINPUT_GAMEPAD_B])
		{
			break ;
		}
		else if(g_Gamepads[0].hDevice && g_Gamepads[0].bPressedAnalogButtons[XINPUT_GAMEPAD_A])
		{
			m_currentMemMatches = 0 ;
			for ( int i = 0 ; i < CONSOLE_MEMORY_SIZE ; i++ )
			{
				if ( m_memMatches[i] )
					if ( m_memBuf1[i] < m_memBuf2[i] )
					{
						m_memMatches[i] = 1 ;
						m_currentMemMatches++ ;
					}
					else
						m_memMatches[i] = 0 ;
			}

			if ( m_currentMemMatches == 1 )
			{
				doAddFoundCodes() ;
				break ;
			}
		}
		else if(g_Gamepads[0].hDevice && g_Gamepads[0].bPressedAnalogButtons[XINPUT_GAMEPAD_X])
		{
			m_currentMemMatches = 0 ;
			for ( int i = 0 ; i < CONSOLE_MEMORY_SIZE ; i++ )
			{
				if ( m_memMatches[i] )
					if ( m_memBuf2[i] == value )
					{
						m_memMatches[i] = 1 ;
						m_currentMemMatches++ ;
					}
					else
						m_memMatches[i] = 0 ;
			}
			if ( m_currentMemMatches == 1 )
			{
				doAddFoundCodes() ;
				break ;
			}
		}
		else if(g_Gamepads[0].hDevice && g_Gamepads[0].bPressedAnalogButtons[XINPUT_GAMEPAD_Y])
		{
			m_currentMemMatches = 0 ;
			for ( int i = 0 ; i < CONSOLE_MEMORY_SIZE ; i++ )
			{
				if ( m_memMatches[i] )
					if ( m_memBuf1[i] > m_memBuf2[i] )
					{
						m_memMatches[i] = 1 ;
						m_currentMemMatches++ ;
					}
					else
						m_memMatches[i] = 0 ;
			}
			if ( m_currentMemMatches == 1 )
			{
				doAddFoundCodes() ;
				break ;
			}
		}
		else if(g_Gamepads[0].hDevice && g_Gamepads[0].bPressedAnalogButtons[XINPUT_GAMEPAD_BLACK])
		{
			m_currentMemMatches = 0 ;
			for ( int i = 0 ; i < CONSOLE_MEMORY_SIZE ; i++ )
			{
				if ( m_memMatches[i] )
					if ( m_memBuf1[i] == m_memBuf2[i] )
					{
						m_memMatches[i] = 1 ;
						m_currentMemMatches++ ;
					}
					else
						m_memMatches[i] = 0 ;
			}
			if ( m_currentMemMatches == 1 )
			{
				doAddFoundCodes() ;
				break ;
			}
		}
		else if(g_Gamepads[0].hDevice && g_Gamepads[0].bPressedAnalogButtons[XINPUT_GAMEPAD_WHITE])
		{
			m_currentMemMatches = 0 ;
			for ( int i = 0 ; i < CONSOLE_MEMORY_SIZE ; i++ )
			{
				if ( m_memMatches[i] )
					if ( m_memBuf1[i] != m_memBuf2[i] )
					{
						m_memMatches[i] = 1 ;
						m_currentMemMatches++ ;
					}
					else
						m_memMatches[i] = 0 ;
			}
			if ( m_currentMemMatches == 1 )
			{
				doAddFoundCodes() ;
				break ;
			}
		}
		else if ( g_Gamepads[0].hDevice && g_Gamepads[0].wPressedButtons & XINPUT_GAMEPAD_DPAD_DOWN ) 
		{
			value = ( value - 1 ) & 0xFF ;
		}
		else if ( g_Gamepads[0].hDevice && g_Gamepads[0].wPressedButtons & XINPUT_GAMEPAD_DPAD_UP ) 
		{
			value = ( value + 1 ) & 0xFF ;
		}
		else if ( g_Gamepads[0].hDevice && g_Gamepads[0].wPressedButtons & XINPUT_GAMEPAD_DPAD_LEFT ) 
		{
			value = ( value - 10 ) & 0xFF ;
		}
		else if ( g_Gamepads[0].hDevice && g_Gamepads[0].wPressedButtons & XINPUT_GAMEPAD_DPAD_RIGHT ) 
		{
			value = ( value + 10  ) & 0xFF ;
		}
		else if ( (g_Gamepads[0].hDevice && g_Gamepads[0].bAnalogButtons[XINPUT_GAMEPAD_LEFT_TRIGGER]) && (g_Gamepads[0].hDevice && g_Gamepads[0].bAnalogButtons[XINPUT_GAMEPAD_RIGHT_TRIGGER]) )
		{
			if ( ( m_currentMemMatches > 0 ) && ( m_currentMemMatches < 5 ) )
			{
				doAddFoundCodes() ;
				break ;
			}
			else
			{
				while ( 1 )
				{
					m_pd3dDevice->Clear( 0L, NULL, D3DCLEAR_ZBUFFER|D3DCLEAR_STENCIL,
										 0x00000000, 1.0f, 0L );
					RenderGradientBackground( 0xFF000000, 0xFF000000 );
					m_pnlBackground.Render(0,10,1024,480);

					m_Font.Begin();
					m_Font.DrawText( (float)m_nXOffset+  32, MLINE(0), 0xffffffff, L"You can only add when you have narrowed " ) ;
					m_Font.DrawText( (float)m_nXOffset+  32, MLINE(1), 0xffffffff, L"it down to less than 5 matches." );
					m_Font.DrawText( (float)m_nXOffset+  32, MLINE(3), 0xffffffff, L"Press B to go back." );
					m_Font.End();

					m_pd3dDevice->Present( NULL, NULL, NULL, NULL );

					XBInput_GetInput();
					if ( g_Gamepads[0].hDevice && g_Gamepads[0].bPressedAnalogButtons[ XINPUT_GAMEPAD_B ] ) 
					{
						break ;
					}
				}
			}
		}
	}
	memcpy( m_memBuf1, m_memBuf2, CONSOLE_MEMORY_SIZE ) ;
}






void CXBoxSample::MenuBar( int xpos, int ypos, int xlen, int ylen )
{
	D3DXVECTOR2 vecScale( 1, 1 ) ;
	D3DXVECTOR2 vecTranslate( (float)xpos, (float)ypos ) ;
	D3DXCOLOR d3color(1.0, 1.0, 1.0, 1.0);
	RECT rectSource;

	rectSource.top = 0;
	rectSource.left = 0;
	rectSource.bottom = ylen - 1 ;
	rectSource.right  = xlen - 1;
	
	MenuSprite->Draw(WhiteTexture, &rectSource, &vecScale, NULL, 0, &vecTranslate, d3color);
}





void CXBoxSample::QuickSort( int lo, int hi )
{
	int i = lo;
	int j = hi;
	char partitionStr[200];
	FILENAME tmpf;

	strcpy( partitionStr, (const char*)files[(i+j)/2].filename ) ;
	do
	{
		while ( strcmp( (const char*)files[i].filename, partitionStr ) < 0 ) i++ ;
		while ( strcmp( partitionStr, (const char*)files[j].filename ) < 0 ) j-- ;

		if (i <= j)
		{
			memcpy( &tmpf, &(files[i]), sizeof(tmpf) ) ;
			memcpy( &(files[i]), &(files[j]), sizeof(tmpf) ) ;
			memcpy( &(files[j]), &tmpf, sizeof(tmpf) ) ;
			i++;
			j--;
		}
	} while (i <= j);

	if (lo < j) QuickSort(lo, j);
	if (i < hi) QuickSort(i, hi);

	
}


void CXBoxSample::FindAvailRoms( char *dir)
{
	// Search for all files in our rom directory
	HANDLE hFind;	
	WIN32_FIND_DATAA oFindData;
	hFind = FindFirstFile( dir, &oFindData);
	int  numfound ;
	char parentDir[MAX_PATH] ;
	char *p ;
	
	//writexbox( dir ) ;

	if (files != NULL)
	{
		delete [] files;
		files = NULL;
	}

	// Allocate a buffer to blit our frames to
	files = new FILENAME[4096];

	numfiles = 0 ;

	strcpy( parentDir, dir ) ;

	//writexbox( "find1\r\n" ) ;

	p = strrchr( parentDir, '*' ) ;

	if ( p )
		*p = 0 ;

	strcpy( m_szCurrentDir, parentDir ) ;

	p = strrchr( parentDir, '\\' ) ;

	if ( p )
		*p = 0 ;


	p = strrchr( parentDir, '\\' ) ;

	if ( p )
		*p = 0 ;


	strcat( parentDir, "\\" ) ;


	//writexbox( "find1\r\n" ) ;

	//writexbox( m_szCurrentDir ) ;

	strcpy ( (char*)files[numfiles].filename, ".." ) ;
	files[numfiles].name[0] = 0 ;
	//strcpy( (char*)(files[numfiles].filename), parentDir ) ;
	//strcat( (char*)files[numfiles].filename, "*" ) ;
	//strlwr( (char*)( files[numfiles].filename )) ;
    swprintf( files[numfiles].name, L"<%S>", parentDir );
	files[numfiles].isDir = 1 ;

	numfiles++ ;



	// If we didn't find any just return
	if (hFind == INVALID_HANDLE_VALUE)
	{
		return;
	}
	
	do 
	{

		files[numfiles].name[0] = 0 ;
		strcpy( (char*)(files[numfiles].filename), oFindData.cFileName ) ;
		strlwr( (char*)( files[numfiles].filename )) ;
		files[numfiles].isDir = ( oFindData.dwFileAttributes  & FILE_ATTRIBUTE_DIRECTORY ) ;
		if ( files[numfiles].isDir )
		{
			swprintf( files[numfiles].name, L"<%S>", files[numfiles].filename );
		}
		else
			swprintf( files[numfiles].name, L"%S", files[numfiles].filename );

		numfiles++ ;

		if ( numfiles > 4096 )
		{
			numfiles-- ;
			break ;
		}

	} while (FindNextFile(hFind, &oFindData));

	FindClose( hFind );

	numfound = numfiles ;

	QuickSort( 0, numfiles-1 ) ;
}

// check for move cursor and move accordingly (with clamp etc)
void CXBoxSample::MoveCursor()
{
	char c ;
	int  lcv ;

		if (g_Gamepads[0].hDevice && g_Gamepads[0].bPressedAnalogButtons[XINPUT_GAMEPAD_RIGHT_TRIGGER])
		{
			c = tolower(files[curr].filename[0]) ;

			lcv = curr ;

			while ( ( lcv < (int)numfiles ) && ( tolower(files[lcv].filename[0]) <= c ) )
				lcv++ ;

			if ( lcv < (int)numfiles )
			{
				topIdx = lcv ;
				curr = lcv ;
			}
			else
			{
				topIdx = numfiles - 1 ;
				curr = numfiles - 1 ;
			}
		}
		else if (g_Gamepads[0].hDevice && g_Gamepads[0].bPressedAnalogButtons[XINPUT_GAMEPAD_LEFT_TRIGGER])
		{
			c = tolower(files[curr].filename[0]) ;

			lcv = curr ;

			while ( ( lcv >= 0 ) && ( tolower(files[lcv].filename[0]) >= c ) )
				lcv-- ;

			if ( lcv >= 0 )
			{
				topIdx = lcv ;
				curr = lcv ;
			}
			else
			{
				topIdx = 0 ;
				curr = 0 ;
			}
		}
		else if ( g_Gamepads[0].hDevice && g_Gamepads[0].wPressedButtons & XINPUT_GAMEPAD_DPAD_LEFT ) 
		{
			if ( topIdx >= (unsigned int)m_namesPerPage )
			{
				topIdx -= m_namesPerPage ;
				curr = topIdx ;
			}
			else
			{
				topIdx = 0 ;
				curr = 0 ;
			}
		}
		else if ( g_Gamepads[0].hDevice && g_Gamepads[0].wPressedButtons & XINPUT_GAMEPAD_DPAD_RIGHT ) 
		{
			if ( topIdx + m_namesPerPage < numfiles )
			{
				topIdx += m_namesPerPage ;
				curr = topIdx ;
			}
			else
			{
				topIdx = numfiles - 1 ;
				curr = numfiles - 1 ;
			}
		}
		else if ( g_Gamepads[0].hDevice && g_Gamepads[0].wPressedButtons & XINPUT_GAMEPAD_DPAD_DOWN ) 
		{
			if ( curr == topIdx + (m_namesPerPage-1) )
			{
				if ( curr < numfiles - 1 )
				{
					topIdx++ ;
					curr++ ;
				}
			}
			else
			{
				if ( curr < numfiles-1 )
					curr++ ;
			}
		}
		else if ( g_Gamepads[0].hDevice && g_Gamepads[0].wPressedButtons & XINPUT_GAMEPAD_DPAD_UP ) 
		{
			if ( curr == topIdx )
			{
				if ( curr > 0 )
				{
					topIdx-- ;
					curr-- ;
				}
			}
			else
			{
				if ( curr > 0 )
					curr-- ;
			}
		}

		if ( ( g_Gamepads[0].hDevice && g_Gamepads[0].wButtons & XINPUT_GAMEPAD_DPAD_UP ) || ( m_DefaultGamepad.wButtons & XINPUT_GAMEPAD_DPAD_DOWN ) )
		{
			keyTime++ ;
		}
		else
		{
			keyTime = 0 ;
		}

		if ( keyTime > 20 )
		{
			if ( g_Gamepads[0].hDevice && g_Gamepads[0].wButtons & XINPUT_GAMEPAD_DPAD_UP ) 
			{
				if ( curr == topIdx )
				{
					if ( curr > 0 )
					{
						topIdx-- ;
						curr-- ;
					}
				}
				else
				{
					if ( curr > 0 )
						curr-- ;
				}
			}
			else
			{
				if ( curr == topIdx + (m_namesPerPage-1) )
				{
					if ( curr < numfiles - 1 )
					{
						topIdx++ ;
						curr++ ;
					}
				}
				else
				{
					if ( curr < numfiles-1 )
						curr++ ;
				}
			}
		}
}




void CXBoxSample::cht_load()
{
	FILE *f;
	int fsize ;
	int numread ;

	if (m_cheatCodes != NULL)
	{
		free(m_cheatCodes);
		m_cheatCodes = NULL;
	}
	

	f = fopen(g_chtfile, "rb");
	if (!f) return ;

	fseek( f, 0, SEEK_END ) ;
	fsize = ftell( f ) ;
	fseek( f, 0, SEEK_SET ) ;

	m_numCheats = fsize / sizeof(CHEAT_CODE) ;

	m_cheatCodes = (CHEAT_CODE*)malloc( sizeof(CHEAT_CODE) *  m_numCheats );


	numread = 0 ;
	fread(m_cheatCodes, sizeof(CHEAT_CODE), m_numCheats, f);

	fclose(f);
}

void CXBoxSample::cht_save()
{
	FILE *f;

	if ( m_numCheats == 0 )
	{
		DeleteFile( g_chtfile ) ;
		return ;
	}

	f = fopen(g_chtfile, "wb");
	if (!f) return ;

	fwrite(m_cheatCodes, sizeof(CHEAT_CODE), m_numCheats, f);

	fclose(f);
	
}

BOOL CXBoxSample::hasFiles( int idx )
{
	FILE				*infile ;
	char *p;


	strcpy( g_saveprefix, g_savePath ) ;
	strcat( g_saveprefix, "\\" ) ;
	strcat( g_saveprefix, (const char*)(files[idx].filename) ) ;
	//sprintf(saveprefix, "%s\\%s", savedir, (const char*)files[idx].filename);
	p = strchr(g_saveprefix, '.');
	if (p) *p = 0;

	strcpy(g_sramfile, g_saveprefix);
	strcat(g_sramfile, ".srm");

	strcpy(g_bramfile, g_saveprefix);
	strcat(g_bramfile, ".brm");

	strcpy(g_chtfile, g_saveprefix);
	strcat(g_chtfile, ".cht");

	sprintf( g_statefile, "%s.sta", g_saveprefix ) ;

	infile = fopen( g_sramfile, "rb" ) ;

	if ( infile )
	{
		fclose(infile) ;
		return TRUE ;
	}

	infile = fopen( g_bramfile, "rb" ) ;

	if ( infile )
	{
		fclose(infile) ;
		return TRUE ;
	}

	infile = fopen( g_chtfile, "rb" ) ;

	if ( infile )
	{
		fclose(infile) ;
		return TRUE ;
	}

	infile = fopen( g_statefile, "rb" ) ;

	if ( infile )
	{
		fclose(infile) ;
		return TRUE ;
	}

	return FALSE ;

}
void CXBoxSample::updateCheats( )
{
	for ( unsigned int i = 0 ; i < m_numCheats ; i++ )
	{
		if ( m_cheatCodes[i].enabled )
			m_consoleMemory[ m_cheatCodes[i].adr ] = ( m_cheatCodes[i].val & 0xFF ) ;
	}
}

void CXBoxSample::deleteSaveFiles( int idx )
{
	char *p;


	strcpy( g_saveprefix, g_savePath ) ;
	strcat( g_saveprefix, "\\" ) ;
	strcat( g_saveprefix, (const char*)(files[idx].filename) ) ;
	//sprintf(saveprefix, "%s\\%s", savedir, (const char*)files[idx].filename);
	p = strchr(g_saveprefix, '.');
	if (p) *p = 0;

	strcpy(g_sramfile, g_saveprefix);
	strcat(g_sramfile, ".srm");

	strcpy(g_bramfile, g_saveprefix);
	strcat(g_bramfile, ".brm");

	strcpy(g_keysfile, g_saveprefix);
	strcat(g_keysfile, ".key");

	strcpy(g_chtfile, g_saveprefix);
	strcat(g_chtfile, ".cht");

	sprintf( g_statefile, "%s.sta", g_saveprefix ) ;

	DeleteFile( g_sramfile ) ;
	DeleteFile( g_keysfile ) ;
	DeleteFile( g_bramfile ) ;
	DeleteFile( g_chtfile ) ;
	DeleteFile( g_statefile ) ;

}
#ifdef __cplusplus
extern "C" {
#endif


void audio_callback()
{
	//g_sound->process( *g_apptime, *g_numframes ) ;

}

void xbox_pause_audio( int state ) 
{
	//g_mp3player->pause( state ) ;
	g_sound->pause( state ) ;
}


void xbox_play_mp3( char *mp3filename, int repeat ) 
{
	if ( ! g_mp3player->loadFile( mp3filename, repeat, 0, 75*60*70 ) )
	{
		g_mp3player->insertSilence( 22050 ) ;
		g_mp3player->pause( 0 ) ;
	}

}


DWORD cpp_GetTickCount()
{
//	writexbox( "before tick") ;
	return GetTickCount() ;
//	writexbox( "after tick") ;
}

void cpp_Sleep( DWORD amt )
{

	Sleep(amt) ;
}

void xbox_set_RAM_location() 
{
	g_app->m_consoleMemory = (byte*)PLATFORM_MEMORY_POINTER ;

}

void writexbox( char *msg )
{
	//MEMORYSTATUS stat;

	//fwrite( msg, sizeof(char), strlen(msg), g_app->m_logfile ) ;
	//fflush( g_app->m_logfile ) ;
	//GlobalMemoryStatus( &stat );

	//if ( g_debugClient )
		//g_debugClient->Send( msg, strlen(msg) ) ;

	//if ( stat.dwAvailPhys < 5000000 )
		//g_debugClient->WaitKey() ;
}

void writexboxwait( char *msg )
{

	//fwrite( msg, sizeof(char), strlen(msg), g_app->m_logfile ) ;
	//fflush( g_app->m_logfile ) ;

	//g_debugClient->Send( msg, strlen(msg) ) ;
	//g_debugClient->WaitKey() ;
}


#ifdef __cplusplus
}
#endif



