//-----------------------------------------------------------------------------
// File: WMVCutScene.cpp
//
// Desc: This sample demonstrates how to play back WMV cut scenes using the
//       Direct3D overlay surface
//
// Hist: 10.10.01 - New for Novermber XDK
//
// Copyright (c) Microsoft Corporation. All rights reserved.
//-----------------------------------------------------------------------------

#include <XBApp.h>
#include <XBFont.h>
#include <XBHelp.h>
#include <xgraphics.h>
#include <assert.h>
#include <d3d8perf.h>
#include "SndXBOX.hxx"
#include <stdio.h>

#ifdef __cplusplus
extern "C" {
#endif

#include "fb.h"
#include "exports.h"
#include "rc.h"
#include "loader.h"
#include "cpu.h"
#include "regs.h"
#include "sound.h"
#include "rtc.h"
#include "hw.h" 
#include "lcd.h"
#include "pcm.h"

extern char *savedir;

char global_error_message[1024] ;

#ifdef __cplusplus
}
#endif

//WCHAR g_buf[1024];
// constants for controller dead zone / speed up banding etc.
const float GAMESEL_cfDeadZone = 0.3f;
const float GAMESEL_cfMaxThresh = 0.93f;
const float GAMESEL_cfMaxPossible = 1.0f;
const float GAMESEL_cfRectifyScale = GAMESEL_cfMaxPossible/(GAMESEL_cfMaxPossible-GAMESEL_cfDeadZone);
const float GAMESEL_cfSpeedBandFastest = 3.0f;	// seconds (don`t worry for PAL NTSC dif xbapp handles that)
const float GAMESEL_cfFastestScrollMult = 10.0f;
const float GAMESEL_cfSpeedBandMedium = 2.0f;	// if the pad is held at max for given seconds list will move faster
const float GAMESEL_cfMediumScrollMult = 5.0f;
const float GAMESEL_cfSpeedBandLowest = 1.0f;
const float GAMESEL_cfLowestScrollMult = 2.0f;


#define IN_GAME						0
#define IN_GAME_PAUSED				1
#define MAIN_MENU					2
#define INIT_SYSTEM					3
#define INIT_SYSTEM_SHOW_SCREEN     4

#define NAMES_PER_PAGE 19 
#define MAX_RESIST 1000000.0

//-----------------------------------------------------------------------------
// Callouts for labelling the gamepad on the help screen
//-----------------------------------------------------------------------------
XBHELP_CALLOUT g_HelpCallouts[] = 
{
    { XBHELP_BACK_BUTTON,  XBHELP_PLACEMENT_2, L"Display help" },
    { XBHELP_A_BUTTON,     XBHELP_PLACEMENT_1, L"Play video" },
    { XBHELP_B_BUTTON,     XBHELP_PLACEMENT_1, L"Stop playback" },
};

#define NUM_HELP_CALLOUTS ( sizeof( g_HelpCallouts ) / sizeof( g_HelpCallouts[0] ) )


//-----------------------------------------------------------------------------
// Name: class CXBoxSample
// Desc: Main class to run this application. Most functionality is inherited
//       from the CXBApplication base class.
//-----------------------------------------------------------------------------
class CXBoxSample : public CXBApplication
{
public:
    CXBoxSample();

    virtual HRESULT Initialize();
    virtual HRESULT Render();
    virtual HRESULT FrameMove();
	virtual void MoveCursor() ;
	virtual void    initConsole( UINT32 idx) ;
	virtual void    cleanupConsole( ) ;
	virtual void    handleEvents() ;
	virtual int     init_texture() ;
	virtual int		render_to_texture() ;
	virtual void	FindAvailRoms() ;


	float fGameSelect;
	float fCursorPos;
	float m_fFrameTime ;
	float fMaxCount;
	int   iGameSelect;
	int   iCursorPos;

	UINT32 topIdx  ;
	UINT32 curr  ;

    CXBFont     m_Font;             // Font object
    CXBHelp     m_Help;             // Help object
    BOOL        m_bDrawHelp;        // TRUE to draw help screen

    LPDIRECTSOUND8      m_pDSound;      // DirectSound object
    DWORD               m_dwCurrent;    // Current surface


	typedef struct _filenamestruct {
		WCHAR name[200] ;
		unsigned char filename[200] ;
	} FILENAME ;

	FILENAME *files ;
	unsigned long numfiles ;
	UINT32   m_iMaxWindowList;
	UINT32   m_iWindowMiddle ;
	UINT32   m_steps ;

	LPDIRECT3DTEXTURE8	Texture;
	LPD3DXSPRITE			Sprite;
	byte*				g_pBlitBuff ;
	byte*				g_pAlignBuff ;
	
	
	UINT32				m_state ;
    WCHAR      m_strMessage[80];
	UINT32              m_msgDelay ;


	SoundXBOX			m_sound;
	char				g_savePath[500] ;
	char				g_saveprefix[500] ;
	char				g_sramfile[500] ;
	char				g_rtcfile[500] ;

// Indicates the width and height of the screen
	UINT32 theWidth;
	UINT32 theHeight;
    RECT SrcRect;
    RECT DestRect;


	BYTE m_bDiffLeft, m_bDiffRight, m_bColor ;
};



//-----------------------------------------------------------------------------
// Name: main()
// Desc: Entry point to the program.
//-----------------------------------------------------------------------------
VOID __cdecl main()
{
    CXBoxSample xbApp;
    if( FAILED( xbApp.Create() ) )
        return;
    xbApp.Run();
}



//-----------------------------------------------------------------------------
// Name: CXBoxSample (constructor)
// Desc: Constructor for CXBoxSample class
//-----------------------------------------------------------------------------
CXBoxSample::CXBoxSample() 
            :CXBApplication()
{
    m_bDrawHelp = FALSE;
	m_state = MAIN_MENU ;
	files = NULL ;
	global_error_message[0] = 0 ;
}



int CXBoxSample::init_texture()
{
	// Release any previous texture
	if (Texture) 
	{ 
		Texture->Release();
		Texture = NULL;
	}
	
	// Create the texture
	D3DXCreateTexture(m_pd3dDevice, theWidth, theHeight, 0, 0, D3DFMT_X8R8G8B8, D3DPOOL_DEFAULT, &Texture);
//	D3DXCreateTexture(m_pd3dDevice, theWidth, theHeight, 0, 0, D3DFMT_LIN_A8R8G8B8, D3DPOOL_DEFAULT, &Texture);
	
	D3DSURFACE_DESC desc;
    Texture->GetLevelDesc(0, &desc);

	if (g_pBlitBuff != NULL)
	{
		delete [] g_pBlitBuff;
		g_pBlitBuff = NULL;
	}
	
	// Allocate a buffer to blit our frames to
	g_pBlitBuff = new byte[desc.Size];


	if (g_pAlignBuff != NULL)
	{
		delete [] g_pAlignBuff;
		g_pAlignBuff = NULL;
	}
	
	// Allocate a buffer to blit our frames to
	g_pAlignBuff = new byte[desc.Size];
	

	return 0;
}


//-----------------------------------------------------------------------------
// Name: Initialize
// Desc: Peforms initialization
//-----------------------------------------------------------------------------
HRESULT CXBoxSample::Initialize()
{
    // Create a font
    if( FAILED( m_Font.Create( m_pd3dDevice, "Font.xpr" ) ) )
        return XBAPPERR_MEDIANOTFOUND;

    // Create DirectSound
    if( FAILED( DirectSoundCreate( NULL, &(m_sound.dsound),  NULL ) ) )
        return E_FAIL;

	if ( ( XCreateSaveGame( "U:\\", L"GBSAV", OPEN_ALWAYS, 0, g_savePath, 500 ) ) != ERROR_SUCCESS )
        return E_FAIL;

	fGameSelect = 0.0f;
	iGameSelect = 0;
	fCursorPos = 0.0f;
	iCursorPos = 0;
	fMaxCount = 0.0f;
	curr = 0 ;
	topIdx = 0 ;
	numfiles = 0 ;

	m_msgDelay = 0 ;
	wcscpy( m_strMessage, L" " ) ;
	
	g_pBlitBuff = NULL ;
	g_pAlignBuff = NULL ;
	Texture = NULL ;
	Sprite = NULL ;


	FindAvailRoms() ;


	
//BEGIN ONE TIME

	init_exports();
	//this calls 	rcvars = realloc(rcvars, sizeof (rcvar_t) * (nvars+1));
	//so free it in cleanup

	char *forcebuf ;

	forcebuf = ".";
	rc_setvar("rcpath", 1, &forcebuf);
	forcebuf = "U:\\GBSAV\\";
	rc_setvar("savedir", 1, &forcebuf);

	savedir = g_savePath ;

	fb.w = 160;
	fb.h = 144;
	fb.pitch = 160*4;
	fb.ptr = g_pBlitBuff ;
	fb.pelsize = 4 ;
	fb.indexed = 0 ;
	fb.cc[0].r = 0 ;
	fb.cc[1].r = 0 ;
	fb.cc[2].r = 0 ;
	fb.cc[0].l = 16;
	fb.cc[1].l = 8;
	fb.cc[2].l = 0;
	fb.enabled = 1;
	fb.dirty = 0;
	fb.yuv = 0 ;


	pcm.hz = 44100 ;
	pcm.len = 2048 ;
	//pcm.len = 44100 / 60;;
	pcm.stereo = 1 ;
	pcm.buf = (byte *) malloc(pcm.len);
	memset(pcm.buf, 0, pcm.len);
	pcm.pos = 0;



//END ONE TIME	
	
	
	m_state = MAIN_MENU ;

    return S_OK;
}







//-----------------------------------------------------------------------------
// Name: FrameMove
// Desc: Performs per-frame updates
//-----------------------------------------------------------------------------
HRESULT CXBoxSample::FrameMove()
{
	if ( m_state == IN_GAME )
	{
		if ( ( g_Gamepads[0].hDevice && g_Gamepads[0].wButtons & XINPUT_GAMEPAD_START )  &&
			 ( g_Gamepads[0].hDevice && g_Gamepads[0].wButtons & XINPUT_GAMEPAD_BACK )  )
		{
			m_sound.cleanup() ;
			cleanupConsole() ;
			m_state = MAIN_MENU ;
			return S_OK ;
		}
		if(m_DefaultGamepad.bAnalogButtons[XINPUT_GAMEPAD_Y])
		{
			m_state = IN_GAME_PAUSED ;
			return S_OK ;
		}
	}
	else if ( m_state == MAIN_MENU )
	{
		if(m_DefaultGamepad.bAnalogButtons[XINPUT_GAMEPAD_Y])
		{
		}
		else
		{
			// check for cursor select movement and move
			MoveCursor();

			// check for selection of game and do something (anything!)
			if(m_DefaultGamepad.bAnalogButtons[XINPUT_GAMEPAD_A])
			{
				initConsole(curr) ;
				m_state = IN_GAME ;
				return S_OK ;
			}
		}
	}
	else if ( m_state == IN_GAME_PAUSED )
	{
		if(m_DefaultGamepad.bAnalogButtons[XINPUT_GAMEPAD_Y])
		{
			m_state = IN_GAME ;
			return S_OK ;
		}
	}
	else
	{
	}

    return S_OK;
}


int CXBoxSample::render_to_texture()
{
	RECT src, dst;
	byte *curr1, *curr2 ;
	
	// Get a description of our level 0 texture so we can figure
	// out the pitch of the texture
	D3DSURFACE_DESC desc;
    Texture->GetLevelDesc(0, &desc);
	
	
	// Allocate a buffer to blit our frames to

	// Figure out how big of a rect to lock in our texture
	RECT rectSource;
	rectSource.top = 0;
	rectSource.left = 0;
	rectSource.bottom = theHeight ;
	rectSource.right  = theWidth ;

	// Lock the rect in our texture
	D3DLOCKED_RECT d3dlr;
	Texture->LockRect(0, &d3dlr, &rectSource, 0);

	
	curr1 = g_pAlignBuff ;
	curr2 = g_pBlitBuff ;

	for ( int y = 0 ; y < theHeight ; y++ )
	{
		curr1 = ((byte*)g_pAlignBuff) + ( y*d3dlr.Pitch ) ;
		curr2 = ((byte*)g_pBlitBuff) + ( y*fb.pitch ) ;
		memcpy( curr1, curr2, fb.pitch ) ;
//		curr1 += desc.Size / theHeight ;
		//curr2 += fb.pitch ;
	}
	
	// Swizzle the blittled surface back to the texture
	XGSwizzleRect(g_pAlignBuff, 0, NULL, d3dlr.pBits, desc.Width, desc.Height, NULL, 4);



	// Unlock our texture
	Texture->UnlockRect(0);

	//delete [] g_pBlitBuff;
	//g_pBlitBuff = NULL;


	src.left   = 0;
	src.top    = 0;
	src.right  = theWidth  + 1;
	src.bottom = theHeight + 2;

	UINT iWidth  = theWidth;
	UINT iHeight = theHeight;
	
	// win_start_maximized the rect, constraining to the aspect ratio
	dst.left   = dst.top = 0;
	dst.right  = iWidth;
	dst.bottom = iHeight;
	
	// center
	//dst.left   += ((iWidth - (dst.right - dst.left)) / 2)  + ((640-iWidth)/2);
	//dst.top    += ((iHeight - (dst.bottom - dst.top)) / 2) + ((480-iHeight)/2);
	//dst.right  += dst.left;
	//dst.bottom += dst.top;
	
    // Clear the viewport
//	if ( ( m_DefaultGamepad.bAnalogButtons[ XINPUT_GAMEPAD_A ] ) || ( m_DefaultGamepad.bAnalogButtons[ XINPUT_GAMEPAD_X ] ) )  
	    g_pd3dDevice->Clear(0L, NULL, D3DCLEAR_TARGET, D3DCOLOR_XRGB(0,0,0), 1.0f, 0L);
	
	// Begin the Scene
	g_pd3dDevice->BeginScene();

	// Compute the source and dest image sizes
	const float dw = dst.right-dst.left;
	const float dh = dst.bottom-dst.top;
	const float sw = src.right-src.left;
	const float sh = src.bottom-src.top;

	// Compute the scale and transform vectors
	//D3DXVECTOR2 vecScale(dw/sw, dh/sh);
	D3DXVECTOR2 vecScale(2, 2);
	D3DXVECTOR2 vecTranslate(160, 240-144 );
	//D3DXVECTOR2 vecTranslate(dst.left, dst.top);
	
	D3DXCOLOR d3color(1.0, 1.0, 1.0, 1.0);
	
	// Draw the sprite
	//if ( ( m_DefaultGamepad.bAnalogButtons[ XINPUT_GAMEPAD_A ] ) || ( m_DefaultGamepad.bAnalogButtons[ XINPUT_GAMEPAD_Y ] ) )  
		Sprite->Draw(Texture, &rectSource, &vecScale, NULL, 0, &vecTranslate, d3color);
	
	// End the scene.
	g_pd3dDevice->EndScene();
	
	// Present the scene
	//if ( ( m_DefaultGamepad.bAnalogButtons[ XINPUT_GAMEPAD_A ] ) || ( m_DefaultGamepad.bAnalogButtons[ XINPUT_GAMEPAD_BLACK ] ) )  
		//g_pd3dDevice->Present(NULL, NULL, NULL, NULL);

	return 1;
}

//-----------------------------------------------------------------------------
// Name: Render
// Desc: Renders the scene
//-----------------------------------------------------------------------------
HRESULT CXBoxSample::Render()
{
	if ( m_state == IN_GAME )
	{
		// Clear the zbuffer
		m_pd3dDevice->Clear( 0L, NULL, D3DCLEAR_ZBUFFER|D3DCLEAR_STENCIL,
							 0x00000000, 1.0f, 0L );

		// Draw a gradient filled background
		RenderGradientBackground( 0xff404040, 0xff404080 );

		//wcscpy( g_buf, L" 1" ) ;

		if ( global_error_message[0] != 0 )
		{
			WCHAR str[5000];

			m_Font.Begin();
			//swprintf( str, L"%S", global_error_message );
			//m_Font.DrawText( 32, 48, 0x40ffffff, str );
			m_Font.DrawText( 32, 48, 0x40ffffff, L"ERROR" );
			m_Font.End();
		}
		else
		{
			//cpu_emulate(2);
			m_steps++ ;
			cpu_emulate(2280);
			
			while (R_LY > 0 && R_LY < 144)
				emu_step();
			
			render_to_texture();

			rtc_tick();
			//sound_mix();
			m_sound.process() ;
			handleEvents();
 			
			if (!(R_LCDC & 0x80))
				cpu_emulate(32832);
			
			while (R_LY > 0) // wait for next frame 
				emu_step();

			if ( m_msgDelay > 0 )
			{
				m_msgDelay-- ;
				m_Font.Begin();
				m_Font.DrawText(  32, 32, 0xffffff00, m_strMessage );
				m_Font.End();
			}
			else
			{
				m_Font.Begin();
				WCHAR str[2000];
				swprintf( str, L"%u", m_steps);
				m_Font.DrawText( 20, 250, 0x40ffffff, str );
				m_Font.End();
			}
		}
		
		// Present the scene
		m_pd3dDevice->Present( NULL, NULL, NULL, NULL );
	}
	else if ( m_state == IN_GAME_PAUSED )
	{
		// Clear the zbuffer
		m_pd3dDevice->Clear( 0L, NULL, D3DCLEAR_ZBUFFER|D3DCLEAR_STENCIL,
							 0x00000000, 1.0f, 0L );

		// Draw a gradient filled background
		RenderGradientBackground( 0xff404040, 0xff404080 );

		//wcscpy( g_buf, L" 1" ) ;

		//theConsole->mediaSource().update();
		render_to_texture();
		//handleEvents();
		//m_sound.process() ;


		m_Font.Begin();
		m_Font.DrawText(  32, 32, 0xffffff00, L"PAUSED" );
		m_Font.End();

		
		// Present the scene
		m_pd3dDevice->Present( NULL, NULL, NULL, NULL );
	}
	else if ( m_state == MAIN_MENU )
	{
		// Clear the zbuffer
		m_pd3dDevice->Clear( 0L, NULL, D3DCLEAR_ZBUFFER|D3DCLEAR_STENCIL,
							 0x00000000, 1.0f, 0L );
		RenderGradientBackground( 0xff404040, 0xff404080 );

		if(m_DefaultGamepad.bAnalogButtons[XINPUT_GAMEPAD_Y])
		{
			m_Font.Begin(); 
			m_Font.DrawText(32, 16*3,  0x40ffffff, L"Stella for XBOX");
			m_Font.DrawText(32, 16*5,  0x40ffffff, L"Main Menu Controls");
			m_Font.DrawText(32, 16*6,  0x40ffffff, L"A - Play Selected Game");
			m_Font.DrawText(32, 16*7,  0x40ffffff, L"B - Lookup Game Name");
			m_Font.DrawText(32, 16*8,  0x40ffffff, L"Y - Show This Help Screen");
			m_Font.DrawText(32, 16*9,  0x40ffffff, L"DPAD/LS/RS - Select Game");
			m_Font.DrawText(32, 16*11, 0x40ffffff, L"In-Game Controls");
			m_Font.DrawText(32, 16*12, 0x40ffffff, L"A - Joystick/Paddle Fire Button");
			m_Font.DrawText(32, 16*13, 0x40ffffff, L"X - BoosterGrip Fire Button");
			m_Font.DrawText(32, 16*14, 0x40ffffff, L"DPAD - Joystick Movement");
			m_Font.DrawText(32, 16*15, 0x40ffffff, L"Left Analog Stick - Paddle Movement");
			m_Font.DrawText(32, 16*16, 0x40ffffff, L"START - Reset");
			m_Font.DrawText(32, 16*17, 0x40ffffff, L"BACK - Select");
			m_Font.DrawText(32, 16*18, 0x40ffffff, L"LS - Left Difficulty Toggle");
			m_Font.DrawText(32, 16*19, 0x40ffffff, L"RS - Right Difficulty Toggle");
			m_Font.DrawText(32, 16*20, 0x40ffffff, L"BLACK - Color Toggle");
			m_Font.DrawText(32, 16*21, 0x40ffffff, L"START+BACK - Return to Main Menu");
			m_Font.End();
		}
		else if ( ( m_DefaultGamepad.bAnalogButtons[ XINPUT_GAMEPAD_BLACK ] ) &&
				  ( m_DefaultGamepad.bAnalogButtons[ XINPUT_GAMEPAD_WHITE ] ) &&
				  ( m_DefaultGamepad.wButtons & XINPUT_GAMEPAD_LEFT_THUMB ) &&
				  ( m_DefaultGamepad.wButtons & XINPUT_GAMEPAD_RIGHT_THUMB ) )
		{
			m_Font.Begin(); 
			m_Font.DrawText(48, 32, 0x40ffffff, L"Stella for XBOX - made by me");
			m_Font.End();
		}
		else
		{
			m_Font.Begin(); 
			m_Font.DrawText(48, 32, 0x40ffffff, L"Stella for XBOX  Y-Help Screen");
			//m_Font.DrawText(48, 48, 0x40ffffff, L"In game : START+BACK to return here");

			WCHAR str[2000];
			swprintf( str, L"%S", g_saveprefix);
			 m_Font.DrawText( 20, 250, 0x40ffffff, str );

			
			
			float fWinX = 80, fWinY = 64;


			for ( unsigned int idx = topIdx ; ( idx < numfiles ) && ( idx < topIdx+NAMES_PER_PAGE) ; idx++ )
			{
				if ( curr == idx )
					m_Font.DrawText(fWinX - 16, fWinY, 0xffffffff, files[idx].name );
				else
					m_Font.DrawText(fWinX, fWinY, 0x50ffffff, files[idx].name );
				fWinY += 20;
			}
			

			// end font drawing
			m_Font.End();


		}

		m_pd3dDevice->Present( NULL, NULL, NULL, NULL );
	}
	else if ( m_state == INIT_SYSTEM )
	{
	}
	else if ( m_state == INIT_SYSTEM_SHOW_SCREEN )
	{
	}
	else
	{
	}



    return S_OK;
}

/**
  This routine should be called regularly to handle events
*/

void CXBoxSample::handleEvents()
{

    INT32 resistance ;
	float newRes ;
  
	if ( g_Gamepads[0].hDevice && g_Gamepads[0].bAnalogButtons[ XINPUT_GAMEPAD_A ] ) 
		pad_press( PAD_A ) ;
	else
		pad_release( PAD_A ) ;

	if ( g_Gamepads[0].hDevice && g_Gamepads[0].bAnalogButtons[ XINPUT_GAMEPAD_X ] ) 
		pad_press( PAD_B ) ;
	else
		pad_release( PAD_B ) ;

	if ( g_Gamepads[0].hDevice && g_Gamepads[0].wButtons & XINPUT_GAMEPAD_DPAD_LEFT ) 
		pad_press( PAD_LEFT ) ;
	else
		pad_release( PAD_LEFT ) ;

	if ( g_Gamepads[0].hDevice && g_Gamepads[0].wButtons & XINPUT_GAMEPAD_DPAD_RIGHT ) 
		pad_press( PAD_RIGHT ) ;
	else
		pad_release( PAD_RIGHT ) ;


	if ( g_Gamepads[0].hDevice && g_Gamepads[0].wButtons & XINPUT_GAMEPAD_DPAD_UP ) 
		pad_press( PAD_UP ) ;
	else
		pad_release( PAD_UP ) ;
	
	if ( g_Gamepads[0].hDevice && g_Gamepads[0].wButtons & XINPUT_GAMEPAD_DPAD_DOWN ) 
		pad_press( PAD_DOWN ) ;
	else
		pad_release( PAD_DOWN ) ;
	
	
	
	if ( g_Gamepads[0].hDevice && g_Gamepads[0].wButtons & XINPUT_GAMEPAD_START )  
		pad_press( PAD_START ) ;
	else
		pad_release( PAD_START ) ;

	if ( g_Gamepads[0].hDevice && g_Gamepads[0].wButtons & XINPUT_GAMEPAD_BACK )  
		pad_press( PAD_SELECT ) ;
	else
		pad_release( PAD_SELECT ) ;



}


void CXBoxSample::FindAvailRoms()
{
	// Search for all files in our rom directory
	HANDLE hFind;	
	WIN32_FIND_DATAA oFindData;
	hFind = FindFirstFile( "D:\\gbroms\\*", &oFindData);
	
	// If we didn't find any just return
	if (hFind == INVALID_HANDLE_VALUE)
	{
		return;
	}
	
	do 
	{
		numfiles++ ;
	} while (FindNextFile(hFind, &oFindData));

	FindClose( hFind );

	if (files != NULL)
	{
		delete [] files;
		files = NULL;
	}
	
	// Allocate a buffer to blit our frames to
	files = new FILENAME[numfiles];

	numfiles = 0 ;

	hFind = FindFirstFile( "D:\\gbroms\\*", &oFindData);
	
	// If we didn't find any just return
	if (hFind == INVALID_HANDLE_VALUE)
	{
		return;
	}
	
	do 
	{
		// Mame's games are in 8-bit ansi convert them to unicode for display
		//WCHAR wcName[200];
		//mbsrtowcs(wcName, &pName, 200, NULL);

		files[numfiles].name[0] = 0 ;
        swprintf( files[numfiles].name, L"%S", oFindData.cFileName );
		strcpy( (char*)(files[numfiles].filename), oFindData.cFileName ) ;
//		mbsrtowcs(files[numfiles].name, (const char**)( &(oFindData.cFileName) ), 30, NULL);
		numfiles++ ;
	} while (FindNextFile(hFind, &oFindData));

	FindClose( hFind );
}

// check for move cursor and move accordingly (with clamp etc)
void CXBoxSample::MoveCursor()
{

		if (m_DefaultGamepad.bPressedAnalogButtons[XINPUT_GAMEPAD_RIGHT_TRIGGER])
		{
			if ( topIdx + NAMES_PER_PAGE < numfiles )
			{
				topIdx += NAMES_PER_PAGE ;
				curr = topIdx ;
			}
		}
		else if (m_DefaultGamepad.bPressedAnalogButtons[XINPUT_GAMEPAD_LEFT_TRIGGER])
		{
			if ( topIdx >= NAMES_PER_PAGE )
			{
				topIdx -= NAMES_PER_PAGE ;
				curr = topIdx ;
			}
		}
		else if ( m_DefaultGamepad.wPressedButtons & XINPUT_GAMEPAD_DPAD_DOWN ) 
		{
			if ( curr == topIdx + (NAMES_PER_PAGE-1) )
			{
				if ( curr < numfiles - 1 )
				{
					topIdx++ ;
					curr++ ;
				}
			}
			else
			{
				if ( curr < numfiles-1 )
					curr++ ;
			}
		}
		else if ( m_DefaultGamepad.wPressedButtons & XINPUT_GAMEPAD_DPAD_UP ) 
		{
			if ( curr == topIdx )
			{
				if ( curr > 0 )
				{
					topIdx-- ;
					curr-- ;
				}
			}
			else
			{
				if ( curr > 0 )
					curr-- ;
			}
		}

}


void CXBoxSample::initConsole( UINT32 idx )
{
	char                filename[500] ;
	unsigned char       *gimage ;
	FILE				*infile ;
	UINT32				fsize ;
	char *forcebuf ;


	
	strcpy((char*)filename, "D:\\gbroms\\" ) ;
	//wcsrtombs( (char*)gfilename, (const wchar_t**)(&(files[idx].name)), 100, NULL ) ;
	strcat( (char*)filename, (const char*)files[idx].filename ) ;

	m_sound.init() ;


	// Get the desired width and height of the display
	theWidth = 160 ;
	theHeight = 144 ;

	// Create our texture
	init_texture();

	fb.ptr = g_pBlitBuff ;

	// Create our sprite driver
	if ( Sprite == NULL )
		D3DXCreateSprite(m_pd3dDevice, &Sprite);
	


	//BEGIN EACH TIME
	char *p;


	memset(&rom, 0, sizeof(rom)) ;
	memset(&mbc, 0, sizeof(mbc)) ;
	memset(&rtc, 0, sizeof(rtc)) ;
	memset(&hw,  0, sizeof(hw)) ;
	memset(&scan,0, sizeof(scan)) ;
	memset(&cpu, 0, sizeof(cpu)) ;

	nobatt = 0 ;
	forcebatt = 0 ;
	forcedmg = 0 ;
	gbamode = 0 ;

	memset(pcm.buf, 0, pcm.len);
	pcm.pos = 0;

	romfile = filename ;
	rom_load();


	saveprefix = g_saveprefix ;
	strcpy( g_saveprefix, savedir ) ;
	strcat( g_saveprefix, "\\" ) ;
	strcat( g_saveprefix, (const char*)(files[idx].filename) ) ;
	//sprintf(saveprefix, "%s\\%s", savedir, (const char*)files[idx].filename);
	p = strchr(g_saveprefix, '.');
	if (p) *p = 0;

	sramfile = g_sramfile ;
	strcpy(sramfile, saveprefix);
	strcat(sramfile, ".sav");

	rtcfile = g_rtcfile ;
	strcpy(rtcfile, saveprefix);
	strcat(rtcfile, ".rtc");
	
	sram_load();
	rtc_load();

	emu_reset();
	lcd_begin();


	m_steps = 0 ;
}

void CXBoxSample::cleanupConsole( )
{
	sram_save();
	rtc_save();
	//pcm_close();

	if ( rom.bank != NULL )
		free( rom.bank ) ;

	if ( ram.sbank != NULL )
		free( ram.sbank ) ;


	//see loader_unload() for other things to free
}
