//-----------------------------------------------------------------------------
// File: WMVCutScene.cpp
//
// Desc: This sample demonstrates how to play back WMV cut scenes using the
//       Direct3D overlay surface
//
// Hist: 10.10.01 - New for Novermber XDK
//
// Copyright (c) Microsoft Corporation. All rights reserved.
//-----------------------------------------------------------------------------

#include <XBApp.h>
#include <XBFont.h>
#include <XBHelp.h>
#include <xgraphics.h>
#include "wmvplayer.h"
#include <assert.h>
#include <d3d8perf.h>
#include "adventure.h"
#include "MediaSrc.hxx"
#include "Console.hxx"
#include "Event.hxx"
#include "src\ui\xbox\SndXBOX.hxx"
#include "PropsSet.hxx"
#include <stdio.h>
#include "MD5.hxx" 
#include "stellapro.h"

//WCHAR g_buf[1024];
// constants for controller dead zone / speed up banding etc.
const float GAMESEL_cfDeadZone = 0.3f;
const float GAMESEL_cfMaxThresh = 0.93f;
const float GAMESEL_cfMaxPossible = 1.0f;
const float GAMESEL_cfRectifyScale = GAMESEL_cfMaxPossible/(GAMESEL_cfMaxPossible-GAMESEL_cfDeadZone);
const float GAMESEL_cfSpeedBandFastest = 3.0f;	// seconds (don`t worry for PAL NTSC dif xbapp handles that)
const float GAMESEL_cfFastestScrollMult = 10.0f;
const float GAMESEL_cfSpeedBandMedium = 2.0f;	// if the pad is held at max for given seconds list will move faster
const float GAMESEL_cfMediumScrollMult = 5.0f;
const float GAMESEL_cfSpeedBandLowest = 1.0f;
const float GAMESEL_cfLowestScrollMult = 2.0f;


#define IN_GAME						0
#define IN_GAME_PAUSED				1
#define MAIN_MENU					2
#define INIT_SYSTEM					3
#define INIT_SYSTEM_SHOW_SCREEN     4

#define NAMES_PER_PAGE 19 
#define MAX_RESIST 1000000.0

//-----------------------------------------------------------------------------
// Callouts for labelling the gamepad on the help screen
//-----------------------------------------------------------------------------
XBHELP_CALLOUT g_HelpCallouts[] = 
{
    { XBHELP_BACK_BUTTON,  XBHELP_PLACEMENT_2, L"Display help" },
    { XBHELP_A_BUTTON,     XBHELP_PLACEMENT_1, L"Play video" },
    { XBHELP_B_BUTTON,     XBHELP_PLACEMENT_1, L"Stop playback" },
};

#define NUM_HELP_CALLOUTS ( sizeof( g_HelpCallouts ) / sizeof( g_HelpCallouts[0] ) )

#define WMV_FILE "d:\\media\\videos\\bike.wmv"

//-----------------------------------------------------------------------------
// Name: class CXBoxSample
// Desc: Main class to run this application. Most functionality is inherited
//       from the CXBApplication base class.
//-----------------------------------------------------------------------------
class CXBoxSample : public CXBApplication
{
public:
    CXBoxSample();

    virtual HRESULT Initialize();
    virtual HRESULT Render();
    virtual HRESULT FrameMove();
	virtual void MoveCursor() ;
	virtual void namegame( uInt32 idx ) ;
	virtual void    initConsole( uInt32 idx) ;
	virtual void    handleEvents() ;
	virtual bool	setupProperties(PropertiesSet& set) ;
	virtual int     init_texture() ;
	virtual int		render_to_texture(MediaSource& mediaSource) ;
	virtual void	FindAvailRoms() ;


	float fGameSelect;
	float fCursorPos;
	float m_fFrameTime ;
	float fMaxCount;
	int   iGameSelect;
	int   iCursorPos;

	uInt32 topIdx  ;
	uInt32 curr  ;

    CXBFont     m_Font;             // Font object
    CXBHelp     m_Help;             // Help object
    BOOL        m_bDrawHelp;        // TRUE to draw help screen

    LPDIRECTSOUND8      m_pDSound;      // DirectSound object
    CWMVPlayer          m_WMVPlayer;    // WMV Player object
    DWORD               m_dwCurrent;    // Current surface


	typedef struct _filenamestruct {
		WCHAR name[100] ;
		WCHAR gamename[200] ;
		unsigned char filename[50] ;
	} FILENAME ;

	FILENAME *files ;
	unsigned long numfiles ;
	uInt32   m_iMaxWindowList;
	uInt32   m_iWindowMiddle ;

	PropertiesSet allProps ;
	LPDIRECT3DTEXTURE8	Texture;
	LPD3DXSPRITE			Sprite;
	byte*				g_pBlitBuff ;
	
	
	uInt32				m_state ;
    WCHAR      m_strMessage[80];
	uInt32              m_msgDelay ;

//	uInt8				m_romImage[512*1024] ;
// Pointer to the console object or the null pointer
	Console* theConsole;

	SoundXBOX			m_sound;

  // Create a properties set for us to use and set it up

  // Event objects to use
	Event theEvent;

// Indicates the width and height of the screen
	uInt32 theWidth;
	uInt32 theHeight;
    RECT SrcRect;
    RECT DestRect;


	BYTE m_bDiffLeft, m_bDiffRight, m_bColor ;
};



//-----------------------------------------------------------------------------
// Name: main()
// Desc: Entry point to the program.
//-----------------------------------------------------------------------------
VOID __cdecl main()
{
    CXBoxSample xbApp;
    if( FAILED( xbApp.Create() ) )
        return;
    xbApp.Run();
}



//-----------------------------------------------------------------------------
// Name: CXBoxSample (constructor)
// Desc: Constructor for CXBoxSample class
//-----------------------------------------------------------------------------
CXBoxSample::CXBoxSample() 
            :CXBApplication()
{
    m_bDrawHelp = FALSE;
	m_state = MAIN_MENU ;
	files = NULL ;
}



int CXBoxSample::init_texture()
{
	// Release any previous texture
	if (Texture) 
	{ 
		Texture->Release();
		Texture = NULL;
	}
	
	// Create the texture
	D3DXCreateTexture(m_pd3dDevice, theWidth, theHeight, 0, 0, D3DFMT_X8R8G8B8, D3DPOOL_DEFAULT, &Texture);
//	D3DXCreateTexture(m_pd3dDevice, theWidth, theHeight, 0, 0, D3DFMT_LIN_A8R8G8B8, D3DPOOL_DEFAULT, &Texture);
	
	D3DSURFACE_DESC desc;
    Texture->GetLevelDesc(0, &desc);

	if (g_pBlitBuff != NULL)
	{
		delete [] g_pBlitBuff;
		g_pBlitBuff = NULL;
	}
	
	// Allocate a buffer to blit our frames to
	g_pBlitBuff = new byte[desc.Size];

	return 0;
}


/**
  Setup the properties set by loading from the file stella.pro

  @param set The properties set to setup
*/

bool CXBoxSample::setupProperties(PropertiesSet& set)
{
  // Try to load the properties file
  string filename = "D:\\stella.pro";

  set.load(filename, &Console::defaultProperties(), false);
  return true;
}

//-----------------------------------------------------------------------------
// Name: Initialize
// Desc: Peforms initialization
//-----------------------------------------------------------------------------
HRESULT CXBoxSample::Initialize()
{
    // Create a font
    if( FAILED( m_Font.Create( m_pd3dDevice, "Font.xpr" ) ) )
        return XBAPPERR_MEDIANOTFOUND;

    // Create help
    if( FAILED( m_Help.Create( m_pd3dDevice, "Gamepad.xpr" ) ) )
        return XBAPPERR_MEDIANOTFOUND;

    // Create DirectSound
    if( FAILED( DirectSoundCreate( NULL, &(m_sound.dsound),  NULL ) ) )
        return E_FAIL;
	
	//m_sound.dsound_init() ;

	fGameSelect = 0.0f;
	iGameSelect = 0;
	fCursorPos = 0.0f;
	iCursorPos = 0;
	fMaxCount = 0.0f;
	curr = 0 ;
	topIdx = 0 ;
	numfiles = 0 ;

	m_msgDelay = 0 ;
	wcscpy( m_strMessage, L" " ) ;
	
	g_pBlitBuff = NULL ;
	Texture = NULL ;
	Sprite = NULL ;


    int cPropSet = sizeof( g_propset ) / sizeof( g_propset[0] );
    int iPropSet;
    for ( iPropSet = 0; iPropSet < cPropSet; ++iPropSet )
    {
        Properties properties( &Console::defaultProperties() );

        PROPSET::PROPS* pProps = g_propset[iPropSet].props;

        while ( pProps->key != NULL )
        {
            properties.set( pProps->key, pProps->value );
            ++pProps;
        }

        allProps.insert( properties );
    }

	FindAvailRoms() ;

	m_state = MAIN_MENU ;

    return S_OK;
}







//-----------------------------------------------------------------------------
// Name: FrameMove
// Desc: Performs per-frame updates
//-----------------------------------------------------------------------------
HRESULT CXBoxSample::FrameMove()
{
	if ( m_state == IN_GAME )
	{
		if ( ( g_Gamepads[0].hDevice && g_Gamepads[0].wButtons & XINPUT_GAMEPAD_START )  &&
			 ( g_Gamepads[0].hDevice && g_Gamepads[0].wButtons & XINPUT_GAMEPAD_BACK )  )
		{
			m_sound.cleanup() ;
			delete theConsole ;
			m_state = MAIN_MENU ;
			return S_OK ;
		}
		if(m_DefaultGamepad.bAnalogButtons[XINPUT_GAMEPAD_Y])
		{
			m_state = IN_GAME_PAUSED ;
			return S_OK ;
		}
	}
	else if ( m_state == MAIN_MENU )
	{
		if(m_DefaultGamepad.bAnalogButtons[XINPUT_GAMEPAD_Y])
		{
		}
		else
		{
			// check for cursor select movement and move
			MoveCursor();

			// check for selection of game and do something (anything!)
			if(m_DefaultGamepad.bAnalogButtons[XINPUT_GAMEPAD_A])
			{
				initConsole(curr) ;
				m_state = IN_GAME ;
				return S_OK ;
			}
			if(m_DefaultGamepad.bAnalogButtons[XINPUT_GAMEPAD_B])
			{
				namegame(curr) ;
			}
		}
	}
	else if ( m_state == IN_GAME_PAUSED )
	{
		if(m_DefaultGamepad.bAnalogButtons[XINPUT_GAMEPAD_Y])
		{
			m_state = IN_GAME ;
			return S_OK ;
		}
	}
	else
	{
	}

    return S_OK;
}


int CXBoxSample::render_to_texture(MediaSource& mediaSource)
{
	RECT src, dst;
	
	// Get a description of our level 0 texture so we can figure
	// out the pitch of the texture
	D3DSURFACE_DESC desc;
    Texture->GetLevelDesc(0, &desc);
	
	// Figure out how big of a rect to lock in our texture
	RECT rectSource;
	rectSource.top = 0;
	rectSource.left = 0;
	rectSource.bottom = theHeight ;
	rectSource.right  = theWidth ;

	// Lock the rect in our texture
	D3DLOCKED_RECT d3dlr;
	Texture->LockRect(0, &d3dlr, &rectSource, 0);

	
	uInt8* current = (uInt8*)mediaSource.currentFrameBuffer();

	const uInt32* palette = theConsole->mediaSource().palette();
	uInt32 color ;
	unsigned char pixel[4] ;
	uInt32 red, green, blue, yellow, uChrom, vChrom ;
	byte *bitptr ;

	bitptr = g_pBlitBuff ;
	//bitptr = (byte*)d3dlr.pBits ;

	for( uInt32 y = 0 ; y < theConsole->mediaSource().height() ; y++ )
	{
		//bitptr = ((byte*)d3dlr.pBits) + ( y*d3dlr.Pitch ) ;
		bitptr = ((byte*)g_pBlitBuff) + ( y*d3dlr.Pitch ) ;

		for( uInt32 x = 0 ; x < theConsole->mediaSource().width() ; x++ )
		{
			color = palette[*current++] ;
			red = ( color & 0x00FF0000 ) >> 16 ;
			green = ( color & 0x0000FF00 ) >> 8 ;
			blue = ( color & 0x000000FF ) ;

			pixel[3] = 0 ;
			pixel[2] = ( red & 0xFF ) ;
			pixel[1] = ( green & 0xFF ) ;
			pixel[0] = ( blue & 0xFF ) ;
			//pixel[1] = 255 ;
			//pixel[2] = 0 ;
			//pixel[3] = 0 ;

			//memcpy( bitptr, (const void*)(&palette[*current++]), 4 ) ;
			memcpy( bitptr, pixel, 4 ) ;
			bitptr += 4 ;
			//memcpy( bitptr, (const void*)(&palette[*current++]), 4 ) ;
			memcpy( bitptr, pixel, 4 ) ;
			bitptr += 4 ;


		}
	}

	//bitptr = (byte*)d3dlr.pBits ;

	//for ( uInt32 xx = 0 ; xx < (theWidth*theHeight*4) / 10240 ; xx++ )
	//{
		//memset(bitptr + (10240*xx),(255/18)*xx,10240) ;
	//}

	//memset(bitptr+10240,255,10240) ;
	//memset(bitptr+20480,128,10240) ;

	// Swizzle the blittled surface back to the texture
	XGSwizzleRect(g_pBlitBuff, 0, NULL, d3dlr.pBits, desc.Width, desc.Height, NULL, sizeof(DWORD));

	// Unlock our texture
	Texture->UnlockRect(0);

	//delete [] g_pBlitBuff;
	//g_pBlitBuff = NULL;


	src.left   = 0;
	src.top    = 0;
	src.right  = theWidth  + 1;
	src.bottom = theHeight + 2;

	UINT iWidth  = theWidth;
	UINT iHeight = theHeight;
	
	// win_start_maximized the rect, constraining to the aspect ratio
	dst.left   = dst.top = 0;
	dst.right  = iWidth;
	dst.bottom = iHeight;
	
	// center
	//dst.left   += ((iWidth - (dst.right - dst.left)) / 2)  + ((640-iWidth)/2);
	//dst.top    += ((iHeight - (dst.bottom - dst.top)) / 2) + ((480-iHeight)/2);
	//dst.right  += dst.left;
	//dst.bottom += dst.top;
	
    // Clear the viewport
//	if ( ( m_DefaultGamepad.bAnalogButtons[ XINPUT_GAMEPAD_A ] ) || ( m_DefaultGamepad.bAnalogButtons[ XINPUT_GAMEPAD_X ] ) )  
	    g_pd3dDevice->Clear(0L, NULL, D3DCLEAR_TARGET, D3DCOLOR_XRGB(0,0,0), 1.0f, 0L);
	
	// Begin the Scene
	g_pd3dDevice->BeginScene();

	// Compute the source and dest image sizes
	const float dw = dst.right-dst.left;
	const float dh = dst.bottom-dst.top;
	const float sw = src.right-src.left;
	const float sh = src.bottom-src.top;

	// Compute the scale and transform vectors
	//D3DXVECTOR2 vecScale(dw/sw, dh/sh);
	D3DXVECTOR2 vecScale(2, 2);
	D3DXVECTOR2 vecTranslate(0, 240-theHeight );
	//D3DXVECTOR2 vecTranslate(dst.left, dst.top);
	
	D3DXCOLOR d3color(1.0, 1.0, 1.0, 1.0);
	
	// Draw the sprite
	//if ( ( m_DefaultGamepad.bAnalogButtons[ XINPUT_GAMEPAD_A ] ) || ( m_DefaultGamepad.bAnalogButtons[ XINPUT_GAMEPAD_Y ] ) )  
		Sprite->Draw(Texture, &rectSource, &vecScale, NULL, 0, &vecTranslate, d3color);
	
	// End the scene.
	g_pd3dDevice->EndScene();
	
	// Present the scene
	//if ( ( m_DefaultGamepad.bAnalogButtons[ XINPUT_GAMEPAD_A ] ) || ( m_DefaultGamepad.bAnalogButtons[ XINPUT_GAMEPAD_BLACK ] ) )  
		//g_pd3dDevice->Present(NULL, NULL, NULL, NULL);

	return 1;
}

//-----------------------------------------------------------------------------
// Name: Render
// Desc: Renders the scene
//-----------------------------------------------------------------------------
HRESULT CXBoxSample::Render()
{
	if ( m_state == IN_GAME )
	{
		// Clear the zbuffer
		m_pd3dDevice->Clear( 0L, NULL, D3DCLEAR_ZBUFFER|D3DCLEAR_STENCIL,
							 0x00000000, 1.0f, 0L );

		// Draw a gradient filled background
		RenderGradientBackground( 0xff404040, 0xff404080 );

		//wcscpy( g_buf, L" 1" ) ;

		theConsole->mediaSource().update();
		render_to_texture(theConsole->mediaSource());
		handleEvents();
		m_sound.process() ;


		if ( m_msgDelay > 0 )
		{
			m_msgDelay-- ;
			m_Font.Begin();
			m_Font.DrawText(  32, 32, 0xffffff00, m_strMessage );
			m_Font.End();
		}

		
		// Present the scene
		m_pd3dDevice->Present( NULL, NULL, NULL, NULL );
	}
	else if ( m_state == IN_GAME_PAUSED )
	{
		// Clear the zbuffer
		m_pd3dDevice->Clear( 0L, NULL, D3DCLEAR_ZBUFFER|D3DCLEAR_STENCIL,
							 0x00000000, 1.0f, 0L );

		// Draw a gradient filled background
		RenderGradientBackground( 0xff404040, 0xff404080 );

		//wcscpy( g_buf, L" 1" ) ;

		//theConsole->mediaSource().update();
		render_to_texture(theConsole->mediaSource());
		//handleEvents();
		//m_sound.process() ;


		m_Font.Begin();
		m_Font.DrawText(  32, 32, 0xffffff00, L"PAUSED" );
		m_Font.End();

		
		// Present the scene
		m_pd3dDevice->Present( NULL, NULL, NULL, NULL );
	}
	else if ( m_state == MAIN_MENU )
	{
		// Clear the zbuffer
		m_pd3dDevice->Clear( 0L, NULL, D3DCLEAR_ZBUFFER|D3DCLEAR_STENCIL,
							 0x00000000, 1.0f, 0L );
		RenderGradientBackground( 0xff404040, 0xff404080 );

		if(m_DefaultGamepad.bAnalogButtons[XINPUT_GAMEPAD_Y])
		{
			m_Font.Begin(); 
			m_Font.DrawText(32, 16*3,  0x40ffffff, L"Stella for XBOX");
			m_Font.DrawText(32, 16*5,  0x40ffffff, L"Main Menu Controls");
			m_Font.DrawText(32, 16*6,  0x40ffffff, L"A - Play Selected Game");
			m_Font.DrawText(32, 16*7,  0x40ffffff, L"B - Lookup Game Name");
			m_Font.DrawText(32, 16*8,  0x40ffffff, L"Y - Show This Help Screen");
			m_Font.DrawText(32, 16*9,  0x40ffffff, L"DPAD/LS/RS - Select Game");
			m_Font.DrawText(32, 16*11, 0x40ffffff, L"In-Game Controls");
			m_Font.DrawText(32, 16*12, 0x40ffffff, L"A - Joystick/Paddle Fire Button");
			m_Font.DrawText(32, 16*13, 0x40ffffff, L"X - BoosterGrip Fire Button");
			m_Font.DrawText(32, 16*14, 0x40ffffff, L"DPAD - Joystick Movement");
			m_Font.DrawText(32, 16*15, 0x40ffffff, L"Left Analog Stick - Paddle Movement");
			m_Font.DrawText(32, 16*16, 0x40ffffff, L"START - Reset");
			m_Font.DrawText(32, 16*17, 0x40ffffff, L"BACK - Select");
			m_Font.DrawText(32, 16*18, 0x40ffffff, L"LS - Left Difficulty Toggle");
			m_Font.DrawText(32, 16*19, 0x40ffffff, L"RS - Right Difficulty Toggle");
			m_Font.DrawText(32, 16*20, 0x40ffffff, L"BLACK - Color Toggle");
			m_Font.DrawText(32, 16*21, 0x40ffffff, L"START+BACK - Return to Main Menu");
			m_Font.End();
		}
		else if ( ( m_DefaultGamepad.bAnalogButtons[ XINPUT_GAMEPAD_BLACK ] ) &&
				  ( m_DefaultGamepad.bAnalogButtons[ XINPUT_GAMEPAD_WHITE ] ) &&
				  ( m_DefaultGamepad.wButtons & XINPUT_GAMEPAD_LEFT_THUMB ) &&
				  ( m_DefaultGamepad.wButtons & XINPUT_GAMEPAD_RIGHT_THUMB ) )
		{
			m_Font.Begin(); 
			m_Font.DrawText(48, 32, 0x40ffffff, L"Stella for XBOX - made by me");
			m_Font.End();
		}
		else
		{
			m_Font.Begin(); 
			m_Font.DrawText(48, 32, 0x40ffffff, L"Stella for XBOX  Y-Help Screen");
			//m_Font.DrawText(48, 48, 0x40ffffff, L"In game : START+BACK to return here");

			//WCHAR str[200];
			//swprintf( str, L"%f %f", g_Gamepads[0].fX1, g_Gamepads[0].fY1 );
			// m_Font.DrawText( 300, 250, 0x40ffffff, str );

			
			
			float fWinX = 80, fWinY = 64;


			for ( unsigned int idx = topIdx ; ( idx < numfiles ) && ( idx < topIdx+NAMES_PER_PAGE) ; idx++ )
			{
				if ( curr == idx )
					m_Font.DrawText(fWinX - 16, fWinY, 0xffffffff, ( files[idx].gamename[0] == 0 ) ? files[idx].name : files[idx].gamename );
				else
					m_Font.DrawText(fWinX, fWinY, 0x50ffffff, ( files[idx].gamename[0] == 0 ) ? files[idx].name : files[idx].gamename);
				fWinY += 20;
			}
			

			// end font drawing
			m_Font.End();


		}

		m_pd3dDevice->Present( NULL, NULL, NULL, NULL );
	}
	else if ( m_state == INIT_SYSTEM )
	{
	}
	else if ( m_state == INIT_SYSTEM_SHOW_SCREEN )
	{
	}
	else
	{
	}



    return S_OK;
}

/**
  This routine should be called regularly to handle events
*/

void CXBoxSample::handleEvents()
{

    Int32 resistance ;
	float newRes ;
  

	theEvent.set(Event::PaddleZeroFire, ( g_Gamepads[0].hDevice && g_Gamepads[0].bAnalogButtons[ XINPUT_GAMEPAD_A ] ) ? 1 : 0 ) ;
	theEvent.set(Event::PaddleOneFire, ( g_Gamepads[1].hDevice && g_Gamepads[1].bAnalogButtons[ XINPUT_GAMEPAD_A ] ) ? 1 : 0 ) ;
	theEvent.set(Event::PaddleTwoFire, ( g_Gamepads[2].hDevice && g_Gamepads[2].bAnalogButtons[ XINPUT_GAMEPAD_A ] ) ? 1 : 0 ) ;
	theEvent.set(Event::PaddleThreeFire, ( g_Gamepads[3].hDevice && g_Gamepads[3].bAnalogButtons[ XINPUT_GAMEPAD_A ] ) ? 1 : 0 ) ;

	if ( g_Gamepads[0].hDevice )
	{
		if ( g_Gamepads[0].fX1 < 0.0f )
		{
			newRes = ((MAX_RESIST * ( g_Gamepads[0].fX1  )  * -1.0f) );
			resistance = newRes ;
		}
		else
		{
			newRes = ((MAX_RESIST * ( g_Gamepads[0].fX1  ) ) );
			resistance = newRes ;
		}
	}
	else
	{
		resistance = 0 ;
	}

	theEvent.set(Event::PaddleZeroResistance, resistance);

	if ( g_Gamepads[1].hDevice )
	{
		if ( g_Gamepads[1].fX1 < 0.0f )
		{
			newRes = ((MAX_RESIST * ( g_Gamepads[1].fX1  )  * -1.0f) );
			resistance = newRes ;
		}
		else
		{
			newRes = ((MAX_RESIST * ( g_Gamepads[1].fX1  ) ) );
			resistance = newRes ;
		}
	}
	else
	{
		resistance = 0 ;
	}

	theEvent.set(Event::PaddleOneResistance, resistance);

	if ( g_Gamepads[2].hDevice )
	{
		if ( g_Gamepads[2].fX1 < 0.0f )
		{
			newRes = ((MAX_RESIST * ( g_Gamepads[2].fX1  )  * -1.0f) );
			resistance = newRes ;
		}
		else
		{
			newRes = ((MAX_RESIST * ( g_Gamepads[2].fX1  ) ) );
			resistance = newRes ;
		}
	}
	else
	{
		resistance = 0 ;
	}

	theEvent.set(Event::PaddleTwoResistance, resistance);

	if ( g_Gamepads[3].hDevice )
	{
		if ( g_Gamepads[3].fX1 < 0.0f )
		{
			newRes = ((MAX_RESIST * ( g_Gamepads[3].fX1  )  * -1.0f) );
			resistance = newRes ;
		}
		else
		{
			newRes = ((MAX_RESIST * ( g_Gamepads[3].fX1  ) ) );
			resistance = newRes ;
		}
	}
	else
	{
		resistance = 0 ;
	}

	theEvent.set(Event::PaddleThreeResistance, resistance);


	theEvent.set(Event::JoystickZeroFire, ( g_Gamepads[0].hDevice && g_Gamepads[0].bAnalogButtons[ XINPUT_GAMEPAD_A ] ) ? 1 : 0 ) ;
	theEvent.set(Event::JoystickOneFire, ( g_Gamepads[1].hDevice && g_Gamepads[1].bAnalogButtons[ XINPUT_GAMEPAD_A ] ) ? 1 : 0 ) ;
	theEvent.set(Event::BoosterGripZeroTrigger, ( g_Gamepads[0].hDevice && g_Gamepads[0].bAnalogButtons[ XINPUT_GAMEPAD_X ] ) ? 1 : 0 ) ;
	theEvent.set(Event::BoosterGripOneTrigger, ( g_Gamepads[1].hDevice && g_Gamepads[1].bAnalogButtons[ XINPUT_GAMEPAD_X ] ) ? 1 : 0 ) ;

	theEvent.set(Event::JoystickZeroLeft, ( g_Gamepads[0].hDevice && g_Gamepads[0].wButtons & XINPUT_GAMEPAD_DPAD_LEFT ) ? 1 : 0 ) ;
	theEvent.set(Event::JoystickZeroRight, ( g_Gamepads[0].hDevice && g_Gamepads[0].wButtons & XINPUT_GAMEPAD_DPAD_RIGHT ) ? 1 : 0 ) ;
	theEvent.set(Event::JoystickZeroUp, ( g_Gamepads[0].hDevice && g_Gamepads[0].wButtons & XINPUT_GAMEPAD_DPAD_UP ) ? 1 : 0 ) ;
	theEvent.set(Event::JoystickZeroDown, ( g_Gamepads[0].hDevice && g_Gamepads[0].wButtons & XINPUT_GAMEPAD_DPAD_DOWN ) ? 1 : 0 ) ;

	theEvent.set(Event::JoystickOneLeft, ( g_Gamepads[1].hDevice && ( g_Gamepads[1].wButtons & XINPUT_GAMEPAD_DPAD_LEFT ) ) ? 1 : 0 ) ;
	theEvent.set(Event::JoystickOneRight, ( g_Gamepads[1].hDevice && ( g_Gamepads[1].wButtons & XINPUT_GAMEPAD_DPAD_RIGHT ) ) ? 1 : 0 ) ;
	theEvent.set(Event::JoystickOneUp, ( g_Gamepads[1].hDevice && ( g_Gamepads[1].wButtons & XINPUT_GAMEPAD_DPAD_UP ) ) ? 1 : 0 ) ;
	theEvent.set(Event::JoystickOneDown, ( g_Gamepads[1].hDevice && ( g_Gamepads[1].wButtons & XINPUT_GAMEPAD_DPAD_DOWN ) ) ? 1 : 0 ) ;
		
	theEvent.set(Event::ConsoleReset, ( g_Gamepads[0].hDevice && g_Gamepads[0].wButtons & XINPUT_GAMEPAD_START )  ? 1 : 0 ) ;
	theEvent.set(Event::ConsoleSelect, ( g_Gamepads[0].hDevice && g_Gamepads[0].wButtons & XINPUT_GAMEPAD_BACK )  ? 1 : 0 ) ;

	if ( g_Gamepads[0].hDevice && g_Gamepads[0].bPressedAnalogButtons[ XINPUT_GAMEPAD_LEFT_TRIGGER ] )
	{
		if ( m_bDiffLeft )
		{
			theEvent.set(Event::ConsoleLeftDifficultyA, 1 ) ;
			m_bDiffLeft = 0 ;
			wcscpy( m_strMessage, L"Left Difficulty A" ) ;
			m_msgDelay = 180 ;
		}
		else
		{
			theEvent.set(Event::ConsoleLeftDifficultyB, 1 ) ;
			m_bDiffLeft = 1 ;
			wcscpy( m_strMessage, L"Left Difficulty B" ) ;
			m_msgDelay = 180 ;
		}
	}

	if ( g_Gamepads[0].hDevice && g_Gamepads[0].bPressedAnalogButtons[ XINPUT_GAMEPAD_RIGHT_TRIGGER ] )
	{
		if ( m_bDiffRight )
		{
			theEvent.set(Event::ConsoleRightDifficultyA, 1 ) ;
			m_bDiffRight = 0 ;
			wcscpy( m_strMessage, L"Right Difficulty A" ) ;
			m_msgDelay = 180 ;
		}
		else
		{
			theEvent.set(Event::ConsoleRightDifficultyB, 1 ) ;
			m_bDiffRight = 1 ;
			wcscpy( m_strMessage, L"Right Difficulty B" ) ;
			m_msgDelay = 180 ;
		}
	}

	if ( g_Gamepads[0].hDevice && g_Gamepads[0].bPressedAnalogButtons[ XINPUT_GAMEPAD_BLACK ] )
	{
		if ( m_bColor )
		{
			theEvent.set(Event::ConsoleColor, 0 ) ;
			m_bColor = 0 ;
			wcscpy( m_strMessage, L"Color" ) ;
			m_msgDelay = 180 ;
		}
		else
		{
			theEvent.set(Event::ConsoleColor, 1 ) ;
			m_bColor = 1 ;
			wcscpy( m_strMessage, L"Black and White" ) ;
			m_msgDelay = 180 ;
		}
	}


}


void CXBoxSample::FindAvailRoms()
{
	// Search for all files in our rom directory
	HANDLE hFind;	
	WIN32_FIND_DATAA oFindData;
	hFind = FindFirstFile( "D:\\a26roms\\*", &oFindData);
	
	// If we didn't find any just return
	if (hFind == INVALID_HANDLE_VALUE)
	{
		return;
	}
	
	do 
	{
		numfiles++ ;
	} while (FindNextFile(hFind, &oFindData));

	FindClose( hFind );

	if (files != NULL)
	{
		delete [] files;
		files = NULL;
	}
	
	// Allocate a buffer to blit our frames to
	files = new FILENAME[numfiles];

	numfiles = 0 ;

	hFind = FindFirstFile( "D:\\a26roms\\*", &oFindData);
	
	// If we didn't find any just return
	if (hFind == INVALID_HANDLE_VALUE)
	{
		return;
	}
	
	do 
	{
		// Mame's games are in 8-bit ansi convert them to unicode for display
		//WCHAR wcName[200];
		//mbsrtowcs(wcName, &pName, 200, NULL);

		files[numfiles].name[0] = 0 ;
        swprintf( files[numfiles].name, L"%S", oFindData.cFileName );
		strcpy( (char*)(files[numfiles].filename), oFindData.cFileName ) ;
//		mbsrtowcs(files[numfiles].name, (const char**)( &(oFindData.cFileName) ), 30, NULL);
		files[numfiles].gamename[0] = 0 ;
		numfiles++ ;
	} while (FindNextFile(hFind, &oFindData));

	FindClose( hFind );
}

// check for move cursor and move accordingly (with clamp etc)
void CXBoxSample::MoveCursor()
{

		if (m_DefaultGamepad.bPressedAnalogButtons[XINPUT_GAMEPAD_RIGHT_TRIGGER])
		{
			if ( topIdx + NAMES_PER_PAGE < numfiles )
			{
				topIdx += NAMES_PER_PAGE ;
				curr = topIdx ;
			}
		}
		else if (m_DefaultGamepad.bPressedAnalogButtons[XINPUT_GAMEPAD_LEFT_TRIGGER])
		{
			if ( topIdx >= NAMES_PER_PAGE )
			{
				topIdx -= NAMES_PER_PAGE ;
				curr = topIdx ;
			}
		}
		else if ( m_DefaultGamepad.wPressedButtons & XINPUT_GAMEPAD_DPAD_DOWN ) 
		{
			if ( curr == topIdx + (NAMES_PER_PAGE-1) )
			{
				if ( curr < numfiles - 1 )
				{
					topIdx++ ;
					curr++ ;
				}
			}
			else
			{
				if ( curr < numfiles-1 )
					curr++ ;
			}
		}
		else if ( m_DefaultGamepad.wPressedButtons & XINPUT_GAMEPAD_DPAD_UP ) 
		{
			if ( curr == topIdx )
			{
				if ( curr > 0 )
				{
					topIdx-- ;
					curr-- ;
				}
			}
			else
			{
				if ( curr > 0 )
					curr-- ;
			}
		}

}

void CXBoxSample::namegame( uInt32 idx ) 
{
	unsigned char filename[150] ;
	unsigned long fsize ;
	unsigned char *gimage ;
	FILE     *infile ;
	unsigned long numread ;
	string   md5buf ;
	Properties gameProps ;
	string gname ;
	const char *gname_c ;

	strcpy((char*)filename, "D:\\a26roms\\" ) ;
	//wcsrtombs( (char*)gfilename, (const wchar_t**)(&(files[idx].name)), 100, NULL ) ;
	strcat( (char*)filename, (const char*)files[idx].filename ) ;

	//strcpy((char*)filename, "D:\\a26roms\\advnture.bin" ) ;
	infile = fopen( (const char*)filename, "rb" ) ;
	
	fseek( infile, 0, SEEK_END ) ;
	fsize = ftell( infile ) ;
	fseek( infile, 0, SEEK_SET ) ;

	gimage = (unsigned char*)malloc( fsize ) ;
	fread( gimage, sizeof(char), fsize, infile ) ;

	
	md5buf = MD5( gimage, fsize ) ;

	fclose( infile ) ;
	free( gimage ) ;

	// Search for the properties based on MD5
	allProps.getMD5(md5buf, gameProps );
	gname = gameProps.get("Cartridge.Name");


	if ( gname.size() > 0 )
	{
		gname_c = gname.c_str() ;
        swprintf( files[idx].gamename, L"%S", gname.c_str() ) ;
		//mbsrtowcs(files[idx].gamename, &gname_c, 40, NULL);
	}
	

}

void CXBoxSample::initConsole( uInt32 idx )
{
	unsigned char       filename[128] ;
	unsigned char       *gimage ;
	FILE				*infile ;
	uInt32				fsize ;


	
	strcpy((char*)filename, "D:\\a26roms\\" ) ;
	//wcsrtombs( (char*)gfilename, (const wchar_t**)(&(files[idx].name)), 100, NULL ) ;
	strcat( (char*)filename, (const char*)files[idx].filename ) ;

	//m_sound.dsound_init() ;
	m_sound.init() ;

	//strcpy((char*)filename, "D:\\a26roms\\advnture.bin" ) ;
	infile = fopen( (const char*)filename, "rb" ) ;
	
	fseek( infile, 0, SEEK_END ) ;
	fsize = ftell( infile ) ;
	fseek( infile, 0, SEEK_SET ) ;

	gimage = (unsigned char*)malloc( fsize ) ;
	fread( gimage, sizeof(char), fsize, infile ) ;


  // Create the 2600 game console
  theConsole = new Console(gimage, fsize, "", theEvent, allProps, m_sound);

	free(gimage) ;

	m_bDiffLeft = 1 ;
	m_bDiffRight = 1 ;
	m_bColor = 1 ;

	theEvent.set(Event::ConsoleColor, 1 ) ;
	theEvent.set(Event::ConsoleLeftDifficultyB, 1 ) ;
	theEvent.set(Event::ConsoleRightDifficultyB, 1 ) ;

  // Get the desired width and height of the display
  theWidth = theConsole->mediaSource().width() * 2;
  theHeight = theConsole->mediaSource().height();

	// Create our texture
	init_texture();

	// Create our sprite driver
	if ( Sprite == NULL )
		D3DXCreateSprite(m_pd3dDevice, &Sprite);
	


}

