//============================================================================
//
//   SSSS    tt          lll  lll
//  SS  SS   tt           ll   ll
//  SS     tttttt  eeee   ll   ll   aaaa
//   SSSS    tt   ee  ee  ll   ll      aa
//      SS   tt   eeeeee  ll   ll   aaaaa  --  "An Atari 2600 VCS Emulator"
//  SS  SS   tt   ee      ll   ll  aa  aa
//   SSSS     ttt  eeeee llll llll  aaaaa
//
// Copyright (c) 1995-1998 by Bradford W. Mott
//
// See the file "license" for information on usage and redistribution of
// this file, and for a DISCLAIMER OF ALL WARRANTIES.
//
// $Id: Props.cxx,v 1.2 2002/01/08 17:11:32 stephena Exp $
//============================================================================

#include "Props.hxx"

#ifdef __cplusplus
extern "C" {
#endif

#include "gpstdlib.h"
#include "gpstdio.h"
#include "gpgraphic.h"
#include "gpfont.h"
#include "string.h"

#ifdef __cplusplus
}
#endif

extern GPDRAWSURFACE gpDraw[];
extern uInt32 numframes  ;
extern uInt32 totalStart ;
extern char NULL_STR[] ;

// - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
Properties::Properties(Properties* defaults)
{
//  myDefaults = defaults;
  myCapacity = 16;
  mySize = 0;
}


// - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
Properties::Properties(Properties& properties)
{
  copy(properties);
}

// - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
Properties::~Properties()
{
  // Free the properties array
}

// - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
char* Properties::get(const char *key) const
{
  // Try to find the named property and answer its value
  for(uInt32 i = 0; i < mySize; ++i)
  {
    if( gp_str_func.compare( key, myProperties[i].key ) == 0 )
    {
      return (char*)myProperties[i].value;
    }
  }

	return NULL_STR ;
  /*
  // Oops, property wasn't found so ask defaults if we have one
  if(myDefaults != 0)
  {
	GpRectFill(NULL, &gpDraw[0], 30, 60, 10, 10, 0xFF ) ;
	GpRectFill(NULL, &gpDraw[1], 30, 60, 10, 10, 0xFF ) ;
	#ifndef __GP_WIN_LAYER
	{int yyy = GpTickCountGet() ; while ( ( GpTickCountGet() - yyy ) < 2700 ) ; }
	#endif
    // Ask the default properties object to find the key
    return myDefaults->get(key);
  } 
  else
  {
	GpRectFill(NULL, &gpDraw[0], 40, 60, 10, 10, 0xFF ) ;
	GpRectFill(NULL, &gpDraw[1], 40, 60, 10, 10, 0xFF ) ;
	#ifndef __GP_WIN_LAYER
	{int yyy = GpTickCountGet() ; while ( ( GpTickCountGet() - yyy ) < 2700 ) ; }
	#endif
    // No default properties object so just return the empty string
    return NULL_STR;
  } */
}

// - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
void Properties::set(const char* key, const char* value)
{
  // See if the property already exists
  for(uInt32 i = 0; i < mySize; ++i)
  {
    if( gp_str_func.compare( key, myProperties[i].key ) == 0 )
    {
      gp_str_func.strcpy( myProperties[i].value,  value ) ;
      return;
    }
  }

  // See if the array needs to be resized

  // Add new property to the array
  strcpy(myProperties[mySize].key, key ) ;
  strcpy(myProperties[mySize].value,  value ) ;

  ++mySize;
}

bool Properties::readpropline( unsigned char *loc, unsigned char *buf)
{
	unsigned char *ptr ;
	unsigned long numread ;

	*buf = 0 ;
	ptr = buf ;

	do
	{
		*ptr = *loc++ ;
	}
	while ( *ptr++ != 10 ) ;

	*ptr = 0 ;
	return true ;

}
// - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
bool Properties::load( unsigned char *md5loc )
{


	unsigned char line[200] ;
	unsigned char key[100];
	unsigned char value[100] ;

	unsigned char *one;
	unsigned char *two;
	unsigned char *three;
	unsigned char *four ;
	unsigned char md5str[33] ;


	strncpy( (char*)md5str, (const char*)md5loc, 32 ) ;
	md5str[32] = 0 ;

	set( "Cartridge.MD5", (const char*)md5str ) ;



	
	while ( *md5loc != 10 )
		md5loc++ ;

	md5loc++ ;

	// Loop reading properties
	while( readpropline( md5loc, line))
	{

		md5loc += strlen( (const char*)line ) ;

		// Ignore commented and empty lines
		if((strlen((const char*)line) == 0) || (line[0] == ';'))
			continue;

		// End of this record
		if( gp_str_func.compare( (const char*)line,"\"\"" ) == 0 ) 
			return true ;

		one = (unsigned char*)strchr( (const char*)line, '\"' ) ;

		if ( one == NULL )
			return true ;

		two = (unsigned char*)strchr( (const char*)one+1, '\"' ) ;

		if ( two == NULL )
			return true ;

		three = (unsigned char*)strchr( (const char*)two+1, '\"' ) ;

		if ( three == NULL )
			return true ;

		four = (unsigned char*)strchr( (const char*)three+1, '\"' ) ;

		if ( four == NULL )
			return true ;


		strncpy( (char*)key, (const char*)one+1, two-one-1 ) ;
		key[two-one-1] = 0 ;
		strncpy( (char*)value, (const char*)three+1, four-three-1 ) ;
		value[four-three-1] = 0 ;

		// Set the property 
		set((const char*)key, (const char*)value);
	}

	return false ;
}


// - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
void Properties::save( F_HANDLE out)
{
/*
  // Write out each of the key and value pairs
  for(uInt32 i = 0; i < mySize; ++i)
  {
    writeQuotedString(out, myProperties[i].key);
    out.put(' ');
    writeQuotedString(out, myProperties[i].value);
    out.put('\n');
  }

  // Put a trailing null string so we know when to stop reading
  writeQuotedString(out, "");
  out.put('\n');
*/
}

// - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
void Properties::readQuotedString( F_HANDLE in, char* szBuf)
{
/*
  char c;

  // Read characters until we see a quote
  while(in.get(c))
  {
    if(c == '"')
    {
      break;
    }
  }

  // Read characters until we see the close quote
  string s;
  while(in.get(c))
  {
    if((c == '\\') && (in.peek() == '"'))
    {
      in.get(c);
    }
    else if((c == '\\') && (in.peek() == '\\'))
    {
      in.get(c);
    }
    else if(c == '"')
    {
      break;
    }
    else if(c == '\r')
    {
      continue;
    }

    s += c;
  }

  return s;
*/
}

// - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
void Properties::writeQuotedString( F_HANDLE out, const char* s)
{
/*
  out.put('"');
  for(uInt32 i = 0; i < s.length(); ++i)
  {
    if(s[i] == '\\')
    {
      out.put('\\');
      out.put('\\');
    }
    else if(s[i] == '\"')
    {
      out.put('\\');
      out.put('"');
    }
    else
    {
      out.put(s[i]);
    }
  }
  out.put('"');
*/
}

// - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
Properties& Properties::operator = (Properties& properties)
{
   // Now, make myself a copy of the given object
   copy(properties);

  return *this;
}

// - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
void Properties::copy(Properties& properties)
{

  // Create an array of the same size as properties
  myCapacity = properties.myCapacity;

  // Now, copy each property from properties
  mySize = properties.mySize;
  for(uInt32 i = 0; i < mySize; ++i)
  {
    gp_str_func.strcpy( myProperties[i].key, properties.myProperties[i].key) ;
    gp_str_func.strcpy( myProperties[i].value, properties.myProperties[i].value) ;
  }
}
