#include <stdio.h>
#include <stdlib.h>
#include <windows.h>
#include "d.h"

int pad_code[32]=
{
  0xc8,0xd0,0xcb,0xcd,
  0x1e,0x1f,0x20,0x1c,
  0x10,0x11,0x12,0x13,
  0x00,0x00,0x00,0x00,
  0x10001,0x10002,0x10003,0x10004,
  0x10010,0x10012,0x10013,0x10011,
  0x10014,0x10015,0x10016,0x10017,
  0x00,0x00,0x00,0x00
};

// Use kinp.cpp to get the input for a megadrive
int get_megad_pad(int pad[2],int ignore)
{
  int p;
  for (p=0;p<2;p++)
    pad[p]=0x000f303f; // 0x000f303f; = untouched pad

  directinput_update();
  for (p=0;p<2;p++)
  {
    int bse=0,k;
    static const int msk[12]={~1,~2,~4,~8,~0x1000,~0x10,~0x20,~0x2000,
      ~0x40000,~0x20000,~0x10000,~0x80000,};
    if (p==1) bse=16;
    // Putting extra buttons in the top f
    // X=1011 Y=1101 Z=1110 Mode=0111


    for (k=0;k<12;k++)
    {
      int code; code=pad_code[bse+k];
      if (ignore==1 && code<0x300) continue; // ignore keys

      if (directinput_check(code,0)) pad[p]&=msk[k];
    }
  }

  return 0;
}


static int common_codes[3][32]=
{
  {
    0xc8,0xd0,0xcb,0xcd,
    0x1e,0x1f,0x20,0x1c,
    0x10,0x11,0x12,0x13,
    0x00,0x00,0x00,0x00,
    0x10001,0x10002,0x10003,0x10004,
    0x10010,0x10012,0x10013,0x10011,
    0x10014,0x10015,0x10016,0x10017,
    0x00,0x00,0x00,0x00
  },
  {
    0x10001,0x10002,0x10003,0x10004,
    0x10010,0x10012,0x10013,0x10011,
    0x10014,0x10015,0x10016,0x10017,
    0x00,0x00,0x00,0x00,
    0xc8,0xd0,0xcb,0xcd,
    0x1e,0x1f,0x20,0x1c,
    0x10,0x11,0x12,0x13,
    0x00,0x00,0x00,0x00
  },
  {
    0x10001,0x10002,0x10003,0x10004,
    0x10010,0x10012,0x10013,0x10011,
    0x10014,0x10015,0x10016,0x10017,
    0x00,0x00,0x00,0x00,
    0x10101,0x10102,0x10103,0x10104,
    0x10110,0x10112,0x10113,0x10111,
    0x10114,0x10115,0x10116,0x10117,
    0x00,0x00,0x00,0x00
  }
};

int common_keys(int type)
{
  if (type>=0 && type<3)
  {
    memcpy(pad_code,common_codes[type],32*sizeof(int));
    dprintf ("Set input type to common_codes[%d]\n",type);
  }
  else dprintf ("common_codes %d out of range\n",type);
  return 0;
}
