/* FCE Ultra - NES/Famicom Emulator
 *
 * Copyright notice for this file:
 *  Copyright (C) 2002 Ben Parnell
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

static uint32 powerpadbuf[2];
static int powerpadside=0;

static int powerpadsc[2][12]={
                              {
                               SDLK_o,SDLK_p,SDLK_LEFTBRACKET,
                               SDLK_RIGHTBRACKET,SDLK_k,SDLK_l,SDLK_SEMICOLON,SDLK_QUOTE,
                               SDLK_m,SDLK_COMMA,SDLK_PERIOD,SDLK_SLASH
                              },
                              {
                               SDLK_o,SDLK_p,SDLK_LEFTBRACKET,
                               SDLK_RIGHTBRACKET,SDLK_k,SDLK_l,SDLK_SEMICOLON,SDLK_QUOTE,
                               SDLK_m,SDLK_COMMA,SDLK_PERIOD,SDLK_SLASH
                              }
                             };



static uint32 UpdatePPadData(int w)
{
 static const char shifttableA[12]={8,9,0,1,11,7,4,2,10,6,5,3};
 static const char shifttableB[12]={1,0,9,8,2,4,7,11,3,5,6,10};
 uint32 r=0;
 int *ppadtsc=powerpadsc[w];
 int x;

 if(powerpadside&(1<<w))
 {
  for(x=0;x<12;x++)
   if(keys[ppadtsc[x]]) r|=1<<shifttableA[x];
 }
 else
 {
  for(x=0;x<12;x++)
   if(keys[ppadtsc[x]]) r|=1<<shifttableB[x];
 }
 return r;
}

