/* FCE Ultra - NES/Famicom Emulator
 *
 * Copyright notice for this file:
 *  Copyright (C) 2002 Ben Parnell
 *  Copyright (C) 2002 Paul Kuliniewicz
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

/* PK: Only #define these if they haven't been #defined yet. */
#ifndef JOY_A
#define JOY_A   1
#define JOY_B   2
#define JOY_SELECT      4
#define JOY_START       8
#define JOY_UP  0x10
#define JOY_DOWN        0x20
#define JOY_LEFT        0x40
#define JOY_RIGHT       0x80
#endif


static uint32 KeyboardGamepad(void)
{
 uint32 JS=0;

 if(sdlgametype!=GIT_NSF)
 {
  int x,y;
  x=y=0;
  keyonly(CAPSLOCK,
                   {
                    char tmp[64];
                    JoySwap=(JoySwap+8)%32;
                    sprintf(tmp,"Joystick %d selected.",(JoySwap>>3)+1);
                    FCEUI_DispMessage(tmp);
                   })

  if(KEY(LALT) || KEY(x))        JS|=JOY_A<<JoySwap;
  if(KEY(LCTRL) || KEY(SPACE) || KEY(x) ) JS |=JOY_B<<JoySwap;
  if(KEY(RETURN))       JS |= JOY_START<<JoySwap;
  if(KEY(TAB))         JS |= JOY_SELECT<<JoySwap;
  if(KEY(DOWN))  y|= JOY_DOWN;
  if(KEY(UP))    y|= JOY_UP;
  if(KEY(LEFT))  x|= JOY_LEFT;
  if(KEY(RIGHT)) x|= JOY_RIGHT;
  if(y!=(JOY_DOWN|JOY_UP)) JS|=y<<JoySwap;
  if(x!=(JOY_LEFT|JOY_RIGHT)) JS|=x<<JoySwap;
 }
 return JS;
}

