//---------------------------------------------------------------------------
// NEOPOP : Emulator as in Dreamland
//
// Copyright (c) 2001-2002 by neopop_uk
//---------------------------------------------------------------------------

//---------------------------------------------------------------------------
//	This program is free software; you can redistribute it and/or modify
//	it under the terms of the GNU General Public License as published by
//	the Free Software Foundation; either version 2 of the License, or
//	(at your option) any later version. See also the license.txt file for
//	additional informations.
//---------------------------------------------------------------------------

/*
//---------------------------------------------------------------------------

  History of changes:
  ===================

20 JUL 2002 - neopop_uk
=======================================
- Cleaned and tidied up for the source release

//---------------------------------------------------------------------------
*/

#include "neopop.h"
#include "eeprom.h"
#include "mem.h"

//=============================================================================

bool	eepromOverride;
_u8		eepromPendingCommand[6];
_u8		eepromPendingCommandPtr;
_u32	eepromData;

//=============================================================================

void eepromResetDecode(void)
{
	int i;

	eepromData = 0;

	eepromOverride = false;

	for (i = 0; i < 6; i++)
		eepromPendingCommand[i] = 0;
	eepromPendingCommandPtr = 0;

	//system_debug_message("reset EEPROM decode");
}

void eepromWrite(_u32 address, _u32 data)
{
	bool hirom = false;

	if (address >= HIROM_START)
		hirom = true;

	address &= 0xFFFF;

#ifdef NEOPOP_DEBUG
	system_debug_message("eepromWrite: %X <- 0x%02X", address, data);
#endif

	//Which command?
	switch (eepromPendingCommandPtr)
	{
		//======= FIRST
	case 0:
		switch(data)
		{
		case 0xAA:
			eepromPendingCommand[0] = 0xAA;
			eepromPendingCommandPtr++;
			break;

		case 0xF0:
		default:
			eepromResetDecode();
			break;
		}
		break;

		//======= SECOND
	case 1:
		switch(data)
		{
		case 0x55:
			eepromPendingCommand[1] = 0x55;
			eepromPendingCommandPtr++;
			eepromOverride = true;
			break;

		default:
			eepromResetDecode();
			break;
		}
		break;

		//======= THIRD
	case 2:
		switch(data)
		{
		case 0x90:
			eepromPendingCommand[2] = 0x90;
			eepromPendingCommandPtr++;
			eepromOverride = true;
			break;

		default:
			eepromResetDecode();
			break;
		}
		break;
	}
}

void eepromRead(_u32 address)
{
	bool hirom = false;

	if (address >= HIROM_START)
		hirom = true;

	address &= 0xFFFF;

	if (eepromPendingCommand[0] == 0xAA &&
		eepromPendingCommand[1] == 0x55 &&
		eepromPendingCommand[2] == 0x90)
	{
		switch(address)
		{
		case 0:	{
#ifdef NEOPOP_DEBUG
				system_debug_message("eeprom: Get Manufacturer Id + 0");
#endif
				eepromData = 0x98;		//Valid Manufacturer.Id
				return;
			}

		case 1:	{
#ifdef NEOPOP_DEBUG
				system_debug_message("eeprom: Get Manufacturer Id + 1");
#endif
				eepromData = 0xAB;		//"Type 1" EEPROM
				return;
			}

		case 2:	{
#ifdef NEOPOP_DEBUG
				system_debug_message("eeprom: Get Manufacturer Id + 2");
#endif
				eepromData = 0xFF;		//Unknown, random value
				return;
			}

		case 3:	{
#ifdef NEOPOP_DEBUG
				system_debug_message("eeprom: Get Manufacturer Id + 3");
#endif
				eepromData = 0x80;		//??
				return;
			}
		}

	}

#ifdef NEOPOP_DEBUG
	system_debug_message("eepromRead, unknown from %06X", address);
#endif
	
	eepromResetDecode();
}

//=============================================================================
