//---------------------------------------------------------------------------
// NEOPOP : Emulator as in Dreamland
//
// Copyright (c) 2001-2002 by neopop_uk
//---------------------------------------------------------------------------

//---------------------------------------------------------------------------
//	This program is free software; you can redistribute it and/or modify
//	it under the terms of the GNU General Public License as published by
//	the Free Software Foundation; either version 2 of the License, or
//	(at your option) any later version. See also the license.txt file for
//	additional informations.
//---------------------------------------------------------------------------

/*
//---------------------------------------------------------------------------

  History of changes:
  ===================

20 JUL 2002 - neopop_uk
=======================================
- Cleaned and tidied up for the source release

21 JUL 2002 - neopop_uk
=======================================
- Added all of the necessary #includes to this file.

//---------------------------------------------------------------------------
*/

#ifndef __STATE__
#define __STATE__
//=============================================================================

#define STATE_VALID_ID		0x0050		//This value is used to verify states

//=============================================================================

#include "rom.h"					//For RomHeader
#include "Z80_interface.h"			//For state.h
#include "mem.h"					//For RAM_START / RAM_END
#include "sound.h"					//For SoundChip

typedef struct
{
	//Save State Id
	_u16 valid_state_id;		// = STATE_VALID_ID

	//Memory
	_u8 ram[1 + RAM_END - RAM_START];

	//TLCS-900h Registers
	_u32 pc;
	_u16 sr;
	_u8 f_dash;
	_u32 gprBank[4][4], gpr[4];
	bool halted;

	//Z80 Registers
	Z80 Z80_regs;

	//Timers
	_u32 timer_hint;
	_u8 timer[4];	//Up-counters
	_u32 timer_clock0, timer_clock1, timer_clock2, timer_clock3;

	//Sound Chips
	SoundChip leftChip;
	SoundChip rightChip;

	//DMA
	_u32 dmaS[4], dmaD[4];
	_u16 dmaC[4];
	_u8 dmaM[4];

	//================================

	// Put this part last, for better error detection

	//Rom Description
	RomHeader header;
}
NEOPOPSTATE;

void state_restore(char* filename);
void state_store(char* filename);

//=============================================================================
#endif

