//---------------------------------------------------------------------------
// NEOPOP : Emulator as in Dreamland
//
// Copyright (c) 2001-2002 by neopop_uk
//---------------------------------------------------------------------------

//---------------------------------------------------------------------------
//	This program is free software; you can redistribute it and/or modify
//	it under the terms of the GNU General Public License as published by
//	the Free Software Foundation; either version 2 of the License, or
//	(at your option) any later version. See also the license.txt file for
//	additional informations.
//---------------------------------------------------------------------------

/*
//---------------------------------------------------------------------------

  History of changes:
  ===================

20 JUL 2002 - neopop_uk
=======================================
- Cleaned and tidied up for the source release

//---------------------------------------------------------------------------
*/

#ifndef __SOUND__
#define __SOUND__
//=============================================================================

typedef struct
{
	int LastRegister;	/* last register written */
	int Register[8];	/* registers */
	int Volume[4];		
	int Period[4];		
	int Count[4];		
	int Output[4];		

	unsigned int RNG;	/* noise generator      */
	int NoiseFB;		/* noise feedback mask */

} SoundChip; 

//=============================================================================

extern SoundChip leftChip;
extern SoundChip rightChip;

void dac_write(_u8 left, _u8 right);

void WriteSoundChip(SoundChip* chip, _u8 data);

#define Write_SoundChipLeft(VALUE)		(WriteSoundChip(&leftChip, VALUE))
#define Write_SoundChipRight(VALUE)		(WriteSoundChip(&rightChip, VALUE))

//=============================================================================

void sound_init(int SampleRate);
void sound_update(_s16* buffer, int length_samples);

//=============================================================================
#endif
