//---------------------------------------------------------------------------
// NEOPOP : Emulator as in Dreamland
//
// Copyright (c) 2001-2002 by neopop_uk
//---------------------------------------------------------------------------

//---------------------------------------------------------------------------
//	This program is free software; you can redistribute it and/or modify
//	it under the terms of the GNU General Public License as published by
//	the Free Software Foundation; either version 2 of the License, or
//	(at your option) any later version. See also the license.txt file for
//	additional informations.
//---------------------------------------------------------------------------

/*
//---------------------------------------------------------------------------

  History of changes:
  ===================

20 JUL 2002 - neopop_uk
=======================================
- Cleaned and tidied up for the source release

21 JUL 2002 - neopop_uk
=======================================
- Removed _MAX_PATH from RomInfo::filename, and added extra comments.
- Added new function 'rom_loaded' which unifies rom_hack, rom_display_header,
	and also builds RomInfo::name.

//---------------------------------------------------------------------------
*/

#ifndef __ROM__
#define __ROM__
//=============================================================================

typedef struct 
{
	_u8* data;		//Pointer to the rom data
	_u32 length;	//Length of the rom

	char name[16];	//Null terminated string, holding the Game name

	//For use as flash file and default state name
	char filename[256];	
}
RomInfo;

extern RomInfo rom;

typedef struct
{
	char	licence[28];		// 0x00 - 0x1B
	_u32	startPC;			// 0x1C - 0x1F
	_u16	catalog;			// 0x20 - 0x21
	_u8		subCatalog;			// 0x22
	_u8		mode;				// 0x23
	char	name[12];			// 0x24 - 0x2F

	_u32	reserved1;			// 0x30 - 0x33
	_u32	reserved2;			// 0x34 - 0x37
	_u32	reserved3;			// 0x38 - 0x3B
	_u32	reserved4;			// 0x3C - 0x3F
}
RomHeader;

extern RomHeader* rom_header;

//=============================================================================

// Call this function when a rom has just been loaded, it
// will perform the system independent actions required.

void rom_loaded(void);

void rom_hack(void);
//=============================================================================
#endif
