//---------------------------------------------------------------------------
// NEOPOP : Emulator as in Dreamland
//
// Copyright (c) 2001-2002 by neopop_uk
//---------------------------------------------------------------------------

//---------------------------------------------------------------------------
//	This program is free software; you can redistribute it and/or modify
//	it under the terms of the GNU General Public License as published by
//	the Free Software Foundation; either version 2 of the License, or
//	(at your option) any later version. See also the license.txt file for
//	additional informations.
//---------------------------------------------------------------------------

/*
//---------------------------------------------------------------------------

  History of changes:
  ===================

20 JUL 2002 - neopop_uk
=======================================
- Cleaned and tidied up for the source release

//---------------------------------------------------------------------------
*/

#include "neopop.h"
#include "TLCS900H_registers.h"

//=============================================================================

void biosDecode(int function)
{
#ifdef NEOPOP_DEBUG
	switch(function)
	{
	case 0:
		system_debug_message("bios: VECT_SHUTDOWN (Called from %06X)", pc);
		break;

	case 1:
		system_debug_message("bios: VECT_CLOCKGEARSET (Called from %06X)", pc);
		break;

	case 2:
		system_debug_message("bios: VECT_RTCGET (Called from %06X)", pc);
		break;

	case 4:	
		system_debug_message("bios: VECT_INTLVSET (Called from %06X)", pc);
		break;

	case 5:
		system_debug_message("bios: VECT_SYSFONTSET (Called from %06X)", pc);
		break;

	case 6:	
		system_debug_message("bios: VECT_FLASHWRITE (Called from %06X)", pc);
		break;

	case 7:	
		system_debug_message("bios: VECT_FLASHALLERS (Called from %06X)", pc);
		break;

	case 8:	
		system_debug_message("bios: VECT_FLASHERS (Called from %06X)", pc);
		break;

	case 9:	
		system_debug_message("bios: VECT_ALARMSET (Called from %06X)", pc);
		break;

	case 11:
		system_debug_message("bios: VECT_ALARMDOWNSET (Called from %06X)", pc);
		break;

	case 13:
		system_debug_message("bios: VECT_FLASHPROTECT (Called from %06X)", pc);
		break;

	case 14:
		system_debug_message("bios: VECT_GEMODESET (Called from %06X)", pc);
		break;

	case 0x10:	
		system_debug_message("bios: VECT_COMINIT (Called from %06X)", pc);
		break;

	case 0x11:	
		system_debug_message("bios: VECT_COMSENDSTART (Called from %06X)", pc);
		break;

	case 0x12:	
		system_debug_message("bios: VECT_COMRECIVESTART (Called from %06X)", pc);
		break;

	case 0x13:	
		system_debug_message("bios: VECT_COMCREATEDATA (Called from %06X)", pc);
		break;

	case 0x14:	
		system_debug_message("bios: VECT_COMGETDATA (Called from %06X)", pc);
		break;

	case 0x15:	
		system_debug_message("bios: VECT_COMONRTS (Called from %06X)", pc);
		break;

	case 0x16:	
		system_debug_message("bios: VECT_COMOFFRTS (Called from %06X)", pc);
		break;

	case 0x17:	
		system_debug_message("bios: VECT_COMSENDSTATUS (Called from %06X)", pc);
		break;

	case 0x18:	
		system_debug_message("bios: VECT_COMRECIVESTATUS (Called from %06X)", pc);
		break;

	case 0x19:	
		system_debug_message("bios: VECT_COMCREATEBUFDATA (Called from %06X)", pc);
		break;

	case 0x1a:	
		system_debug_message("bios: VECT_COMGETBUFDATA (Called from %06X)", pc);
		break;

	default:
		system_debug_message("bios: Unknown function call %d (Called from %06X)", function, pc);
		break;
	}
#endif
}

//=============================================================================
