//---------------------------------------------------------------------------
// NEOPOP : Emulator as in Dreamland
//
// Copyright (c) 2001-2002 by neopop_uk
//---------------------------------------------------------------------------

//---------------------------------------------------------------------------
//	This program is free software; you can redistribute it and/or modify
//	it under the terms of the GNU General Public License as published by
//	the Free Software Foundation; either version 2 of the License, or
//	(at your option) any later version. See also the license.txt file for
//	additional informations.
//---------------------------------------------------------------------------

/*
//---------------------------------------------------------------------------

  History of changes:
  ===================

20 JUL 2002 - neopop_uk
=======================================
- Cleaned and tidied up for the source release

21 JUL 2002 - neopop_uk
=======================================
- Added new function 'rom_loaded' which unifies rom_hack, rom_display_header,
	and also builds RomInfo::name.

21 JUL 2002 - neopop_uk
=======================================
- Added a hack for "Evolution - Eternal Dungeons" to allow you to play in
	one of the dungeon stages. Not 100% sure this is a good hack...


//---------------------------------------------------------------------------
*/

#include "neopop.h"
#include "rom.h"

//=============================================================================

RomInfo rom;
RomHeader* rom_header;

//=============================================================================

static void rom_hack(void)
{
	//=============================
	// SPECIFIC ROM HACKS !
	//=============================

	//"Puyo Pop (V06) (JUE)"
	if (rom_header->catalog == 65 && rom_header->subCatalog == 6)
	{
		int i;
		for (i = 0x8F0; i < 0x8FC; i++)
			rom.data[i] = 0;

#ifdef NEOPOP_DEBUG
		system_debug_message("HACK: \"Puyo Pop (V06) (JUE)\"\n");
#endif
	}

	//"Puyo Pop (V05) (JUE)"
	if (rom_header->catalog == 65 && rom_header->subCatalog == 5)
	{
		int i;
		for (i = 0x8F0; i < 0x8FC; i++)
			rom.data[i] = 0;

#ifdef NEOPOP_DEBUG
		system_debug_message("HACK: \"Puyo Pop (V05) (JUE)\"\n");
#endif
	}

	//"Sonic the Hedgehog - Pocket Adventure (JUE) [!]"
	if (rom_header->catalog == 89 && rom_header->subCatalog == 5)
	{
		//Enable the correct code-path
		rom.data[0x1f] = 0xFF;
		
		//Prevents a bad system call from being made
		rom.data[0x376A5] = 0;		//2376A5: "SWI 1" -> NOP
	
#ifdef NEOPOP_DEBUG
		system_debug_message("HACK: \"Sonic the Hedgehog - Pocket Adventure (JUE)\"\n");
#endif
	}

	//"Metal Slug - 2nd Mission (JUE) [!]"
	//"Metal Slug - 2nd Mission (JUE) [h1]"
	if (rom_header->catalog == 97 && rom_header->subCatalog == 4)
	{
		//Enable the correct code-path
		rom.data[0x1f] = 0xFF;

		//Prevents a bad loop from preventing access to next level.
		rom.data[0x02E7] = rom.data[0x02E8] = 0;//2002E7: "JR GT,xxx" -> NOP
		
#ifdef NEOPOP_DEBUG
		system_debug_message("HACK: \"Metal Slug - 2nd Mission (JUE)\"\n");
#endif
	}


	//"Evolution - Eternal Dungeons (U)"
	//"Evolution - Eternal Dungeons (U) [T-French0.3_Fry]"
	if (rom_header->catalog == 153 && rom_header->subCatalog == 161)
	{
		//20BE5D: "DJNZ C,xxx" -> NOP
		rom.data[0xBE5D] = rom.data[0xBE5E] = rom.data[0xBE5F] = 0;
		
#ifdef NEOPOP_DEBUG
		system_debug_message("HACK: \"Evolution - Eternal Dungeons (U)\"\n");
#endif
	}

}

//=============================================================================

static void rom_display_header(void)
{
#ifdef NEOPOP_DEBUG
	system_debug_message("Rom Header =========================");
	system_debug_message(rom.name);

	//Colour / BW mode?
	switch(rom_header->mode)
	{
	case 0x00: system_debug_message("Presented in Black & White"); break;
	case 0x10: system_debug_message("Presented in Colour"); break;
	default: system_debug_message("Presented in Unknown mode %x", rom_header->mode); break;
	}

	//Catalog Numbers
	system_debug_message("Catalogue %d (sub %d)", rom_header->catalog, rom_header->subCatalog);

	//Starting PC
	system_debug_message("Starting PC = %06X", rom_header->startPC & 0xFFFFFF);

	system_debug_message("====================================");
#endif
}

//=============================================================================

//-----------------------------------------------------------------------------
// rom_loaded()
//-----------------------------------------------------------------------------
void rom_loaded(void)
{
	int i;

	//Extract the header
	rom_header = (RomHeader*)(rom.data);

	//Rom Name
	for(i = 0; i < 12; i++)
	{
		if (rom_header->name[i] >= 32 && rom_header->name[i] < 128)
			rom.name[i] = rom_header->name[i];
		else
			rom.name[i] = ' ';
	}
	rom.name[i] = 0;

	rom_hack();	//Apply a hack if reuqired!

	rom_display_header();	//Show the header (debugger only)
}

//=============================================================================
