//---------------------------------------------------------------------------
// NEOPOP : Emulator as in Dreamland
//
// Copyright (c) 2001-2002 by neopop_uk
//---------------------------------------------------------------------------

//---------------------------------------------------------------------------
//	This program is free software; you can redistribute it and/or modify
//	it under the terms of the GNU General Public License as published by
//	the Free Software Foundation; either version 2 of the License, or
//	(at your option) any later version. See also the license.txt file for
//	additional informations.
//---------------------------------------------------------------------------

/*
//---------------------------------------------------------------------------

  History of changes:
  ===================

20 JUL 2002 - neopop_uk
=======================================
- Cleaned and tidied up for the source release

//---------------------------------------------------------------------------
*/

#include "neopop.h"
#include "TLCS900h_disassemble.h"
#include "Z80_interface.h"
#include "TLCS900h_registers.h"

//=========================================================================

#ifdef NEOPOP_DEBUG
char* disassemble(void)
{
	if (pc >= 0x7000 && pc <= 0x7FFF)
	{
		char* s;
		_u16 p = (_u16)(pc & 0xFFF);
		s = Z80_disassemble(&p);
		pc = p + 0x7000;
		return s;
	}
	else
		return TLCS900h_disassemble();
}
#endif

//=============================================================================
