//-----------------------------------------------------------------------------
// File: WMVCutScene.cpp
//
// Desc: This sample demonstrates how to play back WMV cut scenes using the
//       Direct3D overlay surface
//
// Hist: 10.10.01 - New for Novermber XDK
//
// Copyright (c) Microsoft Corporation. All rights reserved.
//-----------------------------------------------------------------------------

#include <XBApp.h>
#include <XBFont.h>
#include <XBHelp.h>
#include <xgraphics.h>
#include <assert.h>
#include <d3d8perf.h>
#include "SndXBOX.hxx"
#include <stdio.h>
#include <vector>
#include "zlib.h"
#include "unzip.h"

#ifdef __cplusplus
extern "C" {
#endif

#include "fb.h"
#include "exports.h"
#include "rc.h"
#include "loader.h"
#include "cpu.h"
#include "regs.h"
#include "sound.h"
#include "rtc.h"
#include "hw.h" 
#include "lcd.h"
#include "pcm.h"

extern char *savedir;

char global_error_message[1024] ;

void die(char *fmt, ...) ;

//SoundXBOX nothersound ;
//extern SoundXBOX nothersound ;

#ifdef __cplusplus
}
#endif

//WCHAR g_buf[1024];
// constants for controller dead zone / speed up banding etc.
const float GAMESEL_cfDeadZone = 0.3f;
const float GAMESEL_cfMaxThresh = 0.93f;
const float GAMESEL_cfMaxPossible = 1.0f;
const float GAMESEL_cfRectifyScale = GAMESEL_cfMaxPossible/(GAMESEL_cfMaxPossible-GAMESEL_cfDeadZone);
const float GAMESEL_cfSpeedBandFastest = 3.0f;	// seconds (don`t worry for PAL NTSC dif xbapp handles that)
const float GAMESEL_cfFastestScrollMult = 10.0f;
const float GAMESEL_cfSpeedBandMedium = 2.0f;	// if the pad is held at max for given seconds list will move faster
const float GAMESEL_cfMediumScrollMult = 5.0f;
const float GAMESEL_cfSpeedBandLowest = 1.0f;
const float GAMESEL_cfLowestScrollMult = 2.0f;


#define IN_GAME						0
#define IN_GAME_PAUSED				1
#define MAIN_MENU					2
#define INIT_SYSTEM					3
#define INIT_SYSTEM_SHOW_SCREEN     4

#define NAMES_PER_PAGE 25
#define MAX_RESIST 1000000.0


#define CONSOLE_MEMORY_SIZE 0x8000


//-----------------------------------------------------------------------------
// Callouts for labelling the gamepad on the help screen
//-----------------------------------------------------------------------------
XBHELP_CALLOUT g_HelpCallouts[] = 
{
    { XBHELP_BACK_BUTTON,  XBHELP_PLACEMENT_2, L"Display help" },
    { XBHELP_A_BUTTON,     XBHELP_PLACEMENT_1, L"Play video" },
    { XBHELP_B_BUTTON,     XBHELP_PLACEMENT_1, L"Stop playback" },
};

#define NUM_HELP_CALLOUTS ( sizeof( g_HelpCallouts ) / sizeof( g_HelpCallouts[0] ) )

SoundXBOX *g_sound ;
float     *g_apptime ;
UINT32    *g_numframes ;
DWORD     g_dwStartTime ;
DWORD     g_dwTimePaused ;

//-----------------------------------------------------------------------------
// Name: class CXBoxSample
// Desc: Main class to run this application. Most functionality is inherited
//       from the CXBApplication base class.
//-----------------------------------------------------------------------------
class CXBoxSample : public CXBApplication
{
public:
    CXBoxSample();

    virtual HRESULT Initialize();
    virtual HRESULT InitializeWithScreen();
    virtual HRESULT Render();
    virtual HRESULT FrameMove();
	virtual void MoveCursor() ;
	virtual void    initConsole( UINT32 idx) ;
	virtual void    cleanupConsole( ) ;
	virtual void    handleEvents() ;
	virtual int     init_texture() ;
	virtual int		render_to_texture() ;
	virtual void	FindAvailRoms() ;
	virtual void    doStartSearchMenu() ;
	virtual void    doCodeListMenu() ;
	virtual void    doAddFoundCodes() ;
	virtual void    doContinueSearchMenu() ;
	virtual void    doCheatMenu() ;
	virtual void    updateCheats() ;
	virtual void    processEmu( BOOL render ) ;
	virtual void    cht_load() ;
	virtual void    cht_save() ;
	virtual void    deleteSaveFiles( int which ) ;
	virtual void    doEditCode( int which ) ;
	virtual BOOL    hasFiles( int which ) ;
	virtual int     rom_load_zip() ;
	

	float fGameSelect;
	float fCursorPos;
	float m_fFrameTime ;
	float fMaxCount;
	int   iGameSelect;
	int   iCursorPos;
	UINT32 m_numFrames ;


	UINT32 topIdx  ;
	UINT32 curr  ;

    CXBFont     m_Font;             // Font object
    CXBFont     m_FontSmall;             // Font object
    CXBHelp     m_Help;             // Help object
    BOOL        m_bDrawHelp;        // TRUE to draw help screen

    LPDIRECTSOUND8      m_pDSound;      // DirectSound object
    DWORD               m_dwCurrent;    // Current surface

	byte *m_memBuf1, *m_memBuf2, *m_consoleMemory, *m_memMatches ;
	UINT32 m_currentMemMatches ;

	typedef struct _filenamestruct {
		WCHAR name[200] ;
		unsigned char filename[200] ;
	} FILENAME ;

	FILENAME *files ;
	unsigned long numfiles ;
	UINT32   m_iMaxWindowList;
	UINT32   m_iWindowMiddle ;
	UINT32   m_steps ;
	DWORD    m_dwStartPause ;

	LPDIRECT3DTEXTURE8	Texture;
	LPD3DXSPRITE			Sprite;
	byte*				g_pBlitBuff ;
	byte*				g_pAlignBuff ;
	
	
	UINT32				m_state ;
    WCHAR      m_strMessage[80];
	UINT32              m_msgDelay ;


	SoundXBOX			m_sound;
	char				g_savePath[500] ;
	char				g_saveprefix[500] ;
	char				g_sramfile[500] ;
	char				g_rtcfile[500] ;
	char				g_chtfile[500] ;

// Indicates the width and height of the screen
	UINT32 theWidth;
	UINT32 theHeight;
    RECT SrcRect;
    RECT DestRect;

	typedef struct _cheat_code {
		char code[20] ;
		UINT32 adr ;
		UINT32 val ;
		byte   enabled ;
	} CHEAT_CODE;

	CHEAT_CODE *m_cheatCodes;

	UINT32 m_numCheats ;


};



//-----------------------------------------------------------------------------
// Name: main()
// Desc: Entry point to the program.
//-----------------------------------------------------------------------------
VOID __cdecl main()
{
    CXBoxSample xbApp;

	//check for pal60 mode
	if(XGetVideoStandard() == XC_VIDEO_STANDARD_PAL_I)
	{
		//get supported video flags
		DWORD videoFlags = XGetVideoFlags();
		
		//set pal60 if available.
		if(videoFlags && XC_VIDEO_FLAGS_PAL_60Hz)
			xbApp.m_d3dpp.FullScreen_RefreshRateInHz = 60 ;
		else
			xbApp.m_d3dpp.FullScreen_RefreshRateInHz = 50 ;
	}

    if( FAILED( xbApp.Create() ) )
        return;
    xbApp.Run();
}



//-----------------------------------------------------------------------------
// Name: CXBoxSample (constructor)
// Desc: Constructor for CXBoxSample class
//-----------------------------------------------------------------------------
CXBoxSample::CXBoxSample() 
            :CXBApplication()
{
    m_bDrawHelp = FALSE;
	m_state = MAIN_MENU ;
	files = NULL ;
	global_error_message[0] = 0 ;
	g_sound = &m_sound ;
	g_apptime = &m_fAppTime ;
	g_numframes = &m_numFrames ;
	m_sound.m_ptrapp = this ;
}



int CXBoxSample::init_texture()
{
	// Release any previous texture
	if (Texture) 
	{ 
		Texture->Release();
		Texture = NULL;
	}
	
	// Create the texture
	D3DXCreateTexture(m_pd3dDevice, theWidth, theHeight, 0, 0, D3DFMT_X8R8G8B8, D3DPOOL_DEFAULT, &Texture);
//	D3DXCreateTexture(m_pd3dDevice, theWidth, theHeight, 0, 0, D3DFMT_LIN_A8R8G8B8, D3DPOOL_DEFAULT, &Texture);
	
	D3DSURFACE_DESC desc;
    Texture->GetLevelDesc(0, &desc);

	if (g_pBlitBuff != NULL)
	{
		delete [] g_pBlitBuff;
		g_pBlitBuff = NULL;
	}
	
	// Allocate a buffer to blit our frames to
	g_pBlitBuff = new byte[desc.Size];


	if (g_pAlignBuff != NULL)
	{
		delete [] g_pAlignBuff;
		g_pAlignBuff = NULL;
	}
	
	// Allocate a buffer to blit our frames to
	g_pAlignBuff = new byte[desc.Size];

	
	RECT rectSource;
	rectSource.top = 0;
	rectSource.left = 0;
	rectSource.bottom = theHeight-1 ;
	rectSource.right  = theWidth-1 ;

	D3DLOCKED_RECT d3dlr;
	Texture->LockRect(0, &d3dlr, &rectSource, 0);

	fb.pitch = d3dlr.Pitch ;

	// Unlock our texture
	Texture->UnlockRect(0);


	return 0;
}


//-----------------------------------------------------------------------------
// Name: Initialize
// Desc: Peforms initialization
//-----------------------------------------------------------------------------
HRESULT CXBoxSample::Initialize()
{
    // Create a font
    if( FAILED( m_Font.Create( m_pd3dDevice, "Font.xpr" ) ) )
        return XBAPPERR_MEDIANOTFOUND;

    // Create a font
    if( FAILED( m_FontSmall.Create( m_pd3dDevice, "Font12.xpr" ) ) )
        return XBAPPERR_MEDIANOTFOUND;

    // Create DirectSound
    if( FAILED( DirectSoundCreate( NULL, &(m_sound.dsound),  NULL ) ) )
        return E_FAIL;

	if ( ( XCreateSaveGame( "U:\\", L"GBSAV", OPEN_ALWAYS, 0, g_savePath, 500 ) ) != ERROR_SUCCESS )
        return E_FAIL;

	m_sound.dsound_init() ;

	m_sound.m_fps = m_d3dpp.FullScreen_RefreshRateInHz ;

	m_state = INIT_SYSTEM ;

	return S_OK ;
}

HRESULT CXBoxSample::InitializeWithScreen()
{

	m_pd3dDevice->Clear( 0L, NULL, D3DCLEAR_ZBUFFER|D3DCLEAR_STENCIL,
						 0x00000000, 1.0f, 0L );
	RenderGradientBackground( 0xff404040, 0xff404080 );
	m_Font.Begin();
	m_Font.DrawText(  32, 16*2, 0x40ffffff, L"Reading gbroms directory...please wait." ) ;
	m_Font.End();
	m_pd3dDevice->Present( NULL, NULL, NULL, NULL );

	fGameSelect = 0.0f;
	iGameSelect = 0;
	fCursorPos = 0.0f;
	iCursorPos = 0;
	fMaxCount = 0.0f;
	curr = 0 ;
	topIdx = 0 ;
	numfiles = 0 ;

	m_msgDelay = 0 ;
	wcscpy( m_strMessage, L" " ) ;
	
	g_pBlitBuff = NULL ;
	g_pAlignBuff = NULL ;
	Texture = NULL ;
	Sprite = NULL ;
	m_cheatCodes = NULL ;
	m_numCheats = 0 ;

	g_saveprefix[0] = 0 ;

	FindAvailRoms() ;


	m_memBuf1 = (byte*)malloc( CONSOLE_MEMORY_SIZE ) ;
	m_memBuf2 = (byte*)malloc( CONSOLE_MEMORY_SIZE ) ;
	m_memMatches = (byte*)malloc( CONSOLE_MEMORY_SIZE ) ;
	m_consoleMemory = ram.ibank[0] ;


//BEGIN ONE TIME

	init_exports();
	//this calls 	rcvars = realloc(rcvars, sizeof (rcvar_t) * (nvars+1));
	//so free it in cleanup

	char *forcebuf ;

	forcebuf = ".";
	rc_setvar("rcpath", 1, &forcebuf);
	forcebuf = "U:\\GBSAV\\";
	rc_setvar("savedir", 1, &forcebuf);

	savedir = g_savePath ;

	fb.w = 160;
	fb.h = 144;
	//fb.pitch = 160*4;
	fb.ptr = g_pBlitBuff ;
	fb.pelsize = 4 ;
	fb.indexed = 0 ;
	fb.cc[0].r = 0 ;
	fb.cc[1].r = 0 ;
	fb.cc[2].r = 0 ;
	fb.cc[0].l = 16;
	fb.cc[1].l = 8;
	fb.cc[2].l = 0;
	fb.enabled = 1;
	fb.dirty = 0;
	fb.yuv = 0 ;


	pcm.hz = 44100 ;
	pcm.len = 32*1024 ;
	//pcm.len = 44100 / 60;;
	pcm.stereo = 1 ;
	pcm.buf = (byte *) malloc(pcm.len);
	memset(pcm.buf, 0, pcm.len);
	pcm.pos = 0;



//END ONE TIME	
	
	
	m_state = MAIN_MENU ;

    return S_OK;
}




void CXBoxSample::doStartSearchMenu()
{

	memcpy( m_memBuf1, m_consoleMemory, CONSOLE_MEMORY_SIZE ) ;
	memset( m_memMatches, 1, CONSOLE_MEMORY_SIZE ) ;
	m_currentMemMatches = CONSOLE_MEMORY_SIZE ;

	while ( 1 )
	{
		m_pd3dDevice->Clear( 0L, NULL, D3DCLEAR_ZBUFFER|D3DCLEAR_STENCIL,
							 0x00000000, 1.0f, 0L );
		RenderGradientBackground( 0xff404040, 0xff404080 );

		m_Font.Begin();
		m_Font.DrawText(  32, 16*2, 0x40ffffff, L"The search has begun.  " );
		m_Font.DrawText(  32, 16*4, 0x40ffffff, L"Press B to go back to the Options menu." );
		m_Font.End();

		m_pd3dDevice->Present( NULL, NULL, NULL, NULL );

        XBInput_GetInput();
		if ( g_Gamepads[0].hDevice && g_Gamepads[0].bPressedAnalogButtons[ XINPUT_GAMEPAD_B ] ) 
		{
			break ;
		}
	}
}

void CXBoxSample::doEditCode( int which )
{
	CHEAT_CODE code ;
	int curr_pos ;
	int val1, val2 ;

	if ( which < 0 )
	{
		strcpy( code.code, "010000C0" ) ;
		code.enabled = 1 ;
		code.adr = 0xC000 ;
		code.val = 0 ;
	}
	else
	{
		memcpy( &code, &(m_cheatCodes[which]), sizeof(CHEAT_CODE) ) ;
	}


	curr_pos = 0 ;

	while ( 1 )
	{
		m_pd3dDevice->Clear( 0L, NULL, D3DCLEAR_ZBUFFER|D3DCLEAR_STENCIL,
							 0x00000000, 1.0f, 0L );
		RenderGradientBackground( 0xff404040, 0xff404080 );

		m_Font.Begin();

		if ( which < 0 )
			m_Font.DrawText(  32, 16*2, 0x40ffffff, L"Add New Cheat Code" );
		else
			m_Font.DrawText(  32, 16*2, 0x40ffffff, L"Edit Cheat Code" );

		m_Font.DrawText(  32, 16*4, 0x40ffffff, L"Press B to cancel." );
		m_Font.DrawText(  32, 16*5, 0x40ffffff, L"Press A to save." );
		m_Font.DrawText(  32, 16*6, 0x40ffffff, L"Use DPAD to select/change values." );

		WCHAR str[200];

		for ( int i = 0 ; i < 8 ; i++ )
		{
			swprintf( str, L"%c", (code.code)[i] ) ;
			if ( i == curr_pos+2 )
				m_Font.DrawText(  50 + ( i * 16 ), 16*9, 0x40000000, str ) ;
			else
				m_Font.DrawText(  50 + ( i * 16 ), 16*9, 0x40ffffff, str ) ;
		}

		swprintf( str, L"Address : %04.4X", code.adr ) ;
		m_Font.DrawText(  50 , 16*11, 0x40ffffff, str ) ;
		swprintf( str, L"Value : %u", code.val ) ;
		m_Font.DrawText(  50 , 16*12, 0x40ffffff, str ) ;
		
		m_Font.End();

		m_pd3dDevice->Present( NULL, NULL, NULL, NULL );

        XBInput_GetInput();
		if ( g_Gamepads[0].hDevice && g_Gamepads[0].bPressedAnalogButtons[ XINPUT_GAMEPAD_B ] ) 
		{
			break ;
		}
		else if ( g_Gamepads[0].hDevice && g_Gamepads[0].bPressedAnalogButtons[ XINPUT_GAMEPAD_A ] ) 
		{
			if ( ( code.adr < 0xC000 ) || ( code.adr > 0xDFFF ) )
			{
				while ( 1 )
				{
					m_pd3dDevice->Clear( 0L, NULL, D3DCLEAR_ZBUFFER|D3DCLEAR_STENCIL,
										 0x00000000, 1.0f, 0L );
					RenderGradientBackground( 0xff404040, 0xff404080 );

					m_Font.Begin();
					m_Font.DrawText(  32, 16*2, 0x40ffffff, L"The Address must be between 0xC000 and 0xDFFF" );
					m_Font.DrawText(  32, 16*4, 0x40ffffff, L"Press B to try again." );
					m_Font.End();

					m_pd3dDevice->Present( NULL, NULL, NULL, NULL );

					XBInput_GetInput();
					if ( g_Gamepads[0].hDevice && g_Gamepads[0].bPressedAnalogButtons[ XINPUT_GAMEPAD_B ] ) 
					{
						break ;
					}
				}
			}
			else
			{
				if ( which < 0 )
				{
					m_cheatCodes = (CHEAT_CODE*)realloc( m_cheatCodes, sizeof(CHEAT_CODE) * ( m_numCheats  + 1 ) ) ;
					memcpy( &(m_cheatCodes[m_numCheats]),&code, sizeof(CHEAT_CODE) ) ;
					m_numCheats++ ;
				}
				else
				{
					memcpy( &(m_cheatCodes[which]), &code, sizeof(CHEAT_CODE) ) ;
				}
				break ;
			}
		}
		else if ( g_Gamepads[0].hDevice && g_Gamepads[0].wPressedButtons & XINPUT_GAMEPAD_DPAD_DOWN ) 
		{
			switch ( curr_pos )
			{
				case 0 :
				{
					if ( ( ( code.val >> 4 ) &  0x0F ) == 0 )
						code.val = 0xF0 + ( code.val & 0x0F ) ;
					else
						code.val = ( code.val - 0x10 ) & 0xFF ;
					break ;
				}
				case 1 :
				{
					if ( ( code.val & 0x0F ) == 0x00 )
						code.val = 0x0F + ( code.val & 0xF0 ) ;
					else
						code.val = ( code.val - 0x01 ) & 0xFF ;
					break ;
				}
				case 2 :
				{
					if ( ( ( code.adr >> 4 ) &  0x0F ) == 0 )
						code.adr = 0xF0 + ( code.adr & 0xFF0F ) ;
					else
						code.adr = ( code.adr - 0x10 ) & 0xFFFF ;
					break ;
				}
				case 3 :
				{
					if ( ( ( code.adr ) &  0x0F ) == 0 )
						code.adr = 0x0F + ( code.adr & 0xFFF0 ) ;
					else
						code.adr = ( code.adr - 0x01 ) & 0xFFFF ;
					break ;
				}
				case 4 :
				{
					if ( ( ( code.adr >> 12 ) &  0x0F ) == 0 )
						code.adr = 0xF000 + ( code.adr & 0x0FFF ) ;
					else
						code.adr = ( code.adr - 0x1000 ) & 0xFFFF ;
					break ;
				}
				case 5 :
				{
					if ( ( ( code.adr >> 8 ) &  0x0F ) == 0 )
						code.adr = 0x0F00 + ( code.adr & 0xF0FF ) ;
					else
						code.adr = ( code.adr - 0x100 ) & 0xFFFF ;
					break ;
				}
				default : break ;
			}
			sprintf( code.code, "01%02.2X%02.2X%02.2X", code.val, code.adr & 0xFF, (code.adr >> 8 ) & 0xFF ) ;
		}
		else if ( g_Gamepads[0].hDevice && g_Gamepads[0].wPressedButtons & XINPUT_GAMEPAD_DPAD_UP ) 
		{
			switch ( curr_pos )
			{
				case 0 :
				{
					if ( ( ( code.val >> 4 ) &  0x0F ) == 0x0F )
						code.val = 0x00 + ( code.val & 0x0F ) ;
					else
						code.val = ( code.val + 0x10 ) & 0xFF ;
					break ;
				}
				case 1 :
				{
					if ( ( code.val & 0x0F ) == 0x0F )
						code.val = 0x00 + ( code.val & 0xF0 ) ;
					else
						code.val = ( code.val + 0x01 ) & 0xFF ;
					break ;
				}
				case 2 :
				{
					if ( ( ( code.adr >> 4 ) &  0x0F ) == 0x0F )
						code.adr = 0x00 + ( code.adr & 0xFF0F ) ;
					else
						code.adr = ( code.adr + 0x10 ) & 0xFFFF ;
					break ;
				}
				case 3 :
				{
					if ( ( ( code.adr ) &  0x0F ) == 0x0F )
						code.adr = 0x00 + ( code.adr & 0xFFF0 ) ;
					else
						code.adr = ( code.adr + 0x01 ) & 0xFFFF ;
					break ;
				}
				case 4 :
				{
					if ( ( ( code.adr >> 12 ) &  0x0F ) == 0x0F )
						code.adr = 0x0000 + ( code.adr & 0x0FFF ) ;
					else
						code.adr = ( code.adr + 0x1000 ) & 0xFFFF ;
					break ;
				}
				case 5 :
				{
					if ( ( ( code.adr >> 8 ) &  0x0F ) == 0x0F )
						code.adr = 0x0000 + ( code.adr & 0xF0FF ) ;
					else
						code.adr = ( code.adr + 0x100 ) & 0xFFFF ;
					break ;
				}
				default : break ;
			}
			sprintf( code.code, "01%02.2X%02.2X%02.2X", code.val, code.adr & 0xFF, (code.adr >> 8 ) & 0xFF ) ;

		}
		else if ( g_Gamepads[0].hDevice && g_Gamepads[0].wPressedButtons & XINPUT_GAMEPAD_DPAD_LEFT ) 
		{
			if ( curr_pos == 0 )
				curr_pos = 5 ;
			else
				curr_pos-- ;
		}
		else if ( g_Gamepads[0].hDevice && g_Gamepads[0].wPressedButtons & XINPUT_GAMEPAD_DPAD_RIGHT ) 
		{
			if ( curr_pos == 5 )
				curr_pos = 0 ;
			else
				curr_pos++ ;
		}
	}


}

void CXBoxSample::doCodeListMenu()
{

	int selected  ;
	int cheatTopIdx ;
	WCHAR str[400];
	CHEAT_CODE *tempbuf ;

	selected = cheatTopIdx = 0 ;

	if ( m_numCheats == 0 )
	{
		while ( 1 )
		{
			m_pd3dDevice->Clear( 0L, NULL, D3DCLEAR_ZBUFFER|D3DCLEAR_STENCIL,
								 0x00000000, 1.0f, 0L );
			RenderGradientBackground( 0xff404040, 0xff404080 );

			m_Font.Begin();
			m_Font.DrawText(  32, 16*2, 0x40ffffff, L"Search Code List" );
			m_Font.DrawText(  32, 16*4, 0x40ffffff, L"Press B to go back to the Options menu." );
			m_Font.DrawText(  32, 16*6, 0x40ffffff, L"There are no cheat codes in the list." ) ;

			m_Font.End();

			m_pd3dDevice->Present( NULL, NULL, NULL, NULL );

			XBInput_GetInput();
			if(g_Gamepads[0].hDevice && g_Gamepads[0].bPressedAnalogButtons[XINPUT_GAMEPAD_B])
			{
				return ;
			}
		}
	}
	while ( 1 )
	{
		m_pd3dDevice->Clear( 0L, NULL, D3DCLEAR_ZBUFFER|D3DCLEAR_STENCIL,
							 0x00000000, 1.0f, 0L );
		RenderGradientBackground( 0xff404040, 0xff404080 );

		m_Font.Begin();
		m_Font.DrawText(  32, 16*2, 0x40ffffff, L"Search Code List" );
		m_Font.DrawText(  32, 16*4, 0x40ffffff, L"Press B to go back to the Options menu." );
		m_Font.DrawText(  32, 16*5, 0x40ffffff, L"Press A to add a new code." );
		m_Font.DrawText(  32, 16*6, 0x40ffffff, L"Press X to edit the selected code." );
		m_Font.DrawText(  32, 16*7, 0x40ffffff, L"Press Y to enable/disable the selected code." );
		m_Font.DrawText(  32, 16*8, 0x40ffffff, L"Press BLACK to delete the selected code." );
		m_Font.DrawText(  32, 16*9, 0x40ffffff, L"Press UP/DOWN/LS/RS to select code." );

		for ( unsigned int idx = cheatTopIdx ; ( idx < m_numCheats ) && ( idx < cheatTopIdx+10) ; idx++ )
		{
			CHEAT_CODE *code = &(m_cheatCodes[idx]) ;

			swprintf( str, L"%S Adr:0x%04.4X val:%u %S", code->code, code->adr, code->val, code->enabled ? "ON" : "OFF" ) ;
			
			if ( selected == idx )
				m_Font.DrawText(32, 16*(11+idx), 0xffffffff, str );
			else
				m_Font.DrawText(48, 16*(11+idx), 0x50ffffff, str );
		}
		
		m_Font.End();

		m_pd3dDevice->Present( NULL, NULL, NULL, NULL );

        XBInput_GetInput();
		if(g_Gamepads[0].hDevice && g_Gamepads[0].bPressedAnalogButtons[XINPUT_GAMEPAD_B])
		{
			break ;
		}
		else if(g_Gamepads[0].hDevice && g_Gamepads[0].bPressedAnalogButtons[XINPUT_GAMEPAD_A])
		{
			doEditCode( -1 ) ;
		}
		else if(g_Gamepads[0].hDevice && g_Gamepads[0].bPressedAnalogButtons[XINPUT_GAMEPAD_X])
		{
			doEditCode( selected ) ;
		}
		else if(g_Gamepads[0].hDevice && g_Gamepads[0].bPressedAnalogButtons[XINPUT_GAMEPAD_Y])
		{
			if ( m_cheatCodes[selected].enabled )
				m_cheatCodes[selected].enabled = 0 ;
			else
				m_cheatCodes[selected].enabled = 1 ;
		}
		else if (g_Gamepads[0].hDevice && g_Gamepads[0].bPressedAnalogButtons[XINPUT_GAMEPAD_BLACK]) 
		{
			tempbuf = (CHEAT_CODE*)malloc( sizeof(CHEAT_CODE) * ( m_numCheats - 1 ) ) ;

			memcpy( tempbuf, m_cheatCodes, sizeof(CHEAT_CODE) * selected ) ;

			if ( selected < m_numCheats-1 )
			{
				memcpy( &(tempbuf[selected]), &(m_cheatCodes[selected+1]), sizeof(CHEAT_CODE) * ( (m_numCheats - selected ) - 1) ) ;
			}

			free( m_cheatCodes ) ;

			m_cheatCodes = tempbuf ;
			m_numCheats-- ;
			if ( m_numCheats == 0 )
				break ;

			if ( selected >= (m_numCheats) )
				selected = m_numCheats - 1 ;

		}
		if (g_Gamepads[0].hDevice && g_Gamepads[0].bPressedAnalogButtons[XINPUT_GAMEPAD_RIGHT_TRIGGER])
		{
			if ( cheatTopIdx + 10 < m_numCheats )
			{
				cheatTopIdx += 10 ;
				selected = cheatTopIdx ;
			}
		}
		else if (g_Gamepads[0].hDevice && g_Gamepads[0].bPressedAnalogButtons[XINPUT_GAMEPAD_LEFT_TRIGGER])
		{
			if ( cheatTopIdx >= 10 )
			{
				cheatTopIdx -= 10 ;
				selected = cheatTopIdx ;
			}
		}
		else if ( g_Gamepads[0].hDevice && g_Gamepads[0].wPressedButtons & XINPUT_GAMEPAD_DPAD_DOWN ) 
		{
			if ( selected == cheatTopIdx + (10-1) )
			{
				if ( selected < m_numCheats - 1 )
				{
					cheatTopIdx++ ;
					selected++ ;
				}
			}
			else
			{
				if ( selected < m_numCheats-1 )
					selected++ ;
			}
		}
		else if ( g_Gamepads[0].hDevice && g_Gamepads[0].wPressedButtons & XINPUT_GAMEPAD_DPAD_UP ) 
		{
			if ( selected == cheatTopIdx )
			{
				if ( selected > 0 )
				{
					cheatTopIdx-- ;
					selected-- ;
				}
			}
			else
			{
				if ( selected > 0 )
					selected-- ;
			}
		}

		
		
		
		
	}
}

void CXBoxSample::doAddFoundCodes()
{
	CHEAT_CODE code ;

	for ( int i = 0 ; i < CONSOLE_MEMORY_SIZE ; i++ )
	{
		if ( m_memMatches[i] )
		{
			if ( i >= 0x1000 )
			{
				code.adr = 0xD000 + ( i & 0x0FFF ) ;
			}
			else
			{
				code.adr = 0xC000 + i ;
			}

			code.val = m_memBuf1[i] ;
			code.enabled = 0 ;
			sprintf( code.code, "01%02.2X%02.2X%02.2X", code.val, code.adr & 0xFF, (code.adr >> 8 ) & 0xFF ) ;

			m_cheatCodes = (CHEAT_CODE*)realloc( m_cheatCodes, sizeof(CHEAT_CODE) * ( m_numCheats  + 1 ) ) ;

			memcpy( &(m_cheatCodes[m_numCheats]),&code, sizeof(CHEAT_CODE) ) ;
			m_numCheats++ ;

		}
	}

	memset( m_memMatches, 0, CONSOLE_MEMORY_SIZE ) ;
	m_currentMemMatches = 0 ;

	while ( 1 )
	{
		m_pd3dDevice->Clear( 0L, NULL, D3DCLEAR_ZBUFFER|D3DCLEAR_STENCIL,
							 0x00000000, 1.0f, 0L );
		RenderGradientBackground( 0xff404040, 0xff404080 );

		m_Font.Begin();
		m_Font.DrawText(  32, 16*2, 0x40ffffff, L"The search found 1 to 4 possible matches for your search." );
		m_Font.DrawText(  32, 16*3, 0x40ffffff, L"They have been added to your list." );
		m_Font.DrawText(  32, 16*5, 0x40ffffff, L"Press B to go back to the Options menu." );
		m_Font.End();

		m_pd3dDevice->Present( NULL, NULL, NULL, NULL );

        XBInput_GetInput();
		if(g_Gamepads[0].hDevice && g_Gamepads[0].bPressedAnalogButtons[XINPUT_GAMEPAD_B])
		{
			break ;
		}
	}
}

void CXBoxSample::doContinueSearchMenu()
{

	WCHAR str[200];
	int value ;

	memcpy( m_memBuf2, m_consoleMemory, CONSOLE_MEMORY_SIZE ) ;
	value = 0 ;

	while ( 1 )
	{
		m_pd3dDevice->Clear( 0L, NULL, D3DCLEAR_ZBUFFER|D3DCLEAR_STENCIL,
							 0x00000000, 1.0f, 0L );
		RenderGradientBackground( 0xff404040, 0xff404080 );

		m_Font.Begin();
		m_Font.DrawText(  32, 16*2, 0x40ffffff, L"Search Options" );
		m_Font.DrawText(  32, 16*4, 0x40ffffff, L"Press B to go back to the Options menu." );

		swprintf( str, L"Press X to search for this value : %u", value );
		m_Font.DrawText(  32, 16*5, 0x40ffffff, str );

		m_Font.DrawText(  32, 16*6, 0x40ffffff, L"Press Y to search for values less than before." );
		m_Font.DrawText(  32, 16*7, 0x40ffffff, L"Press A to search for values greater than before." );
		m_Font.DrawText(  32, 16*8, 0x40ffffff, L"Press BLACK to search for values equal to before." );
		m_Font.DrawText(  32, 16*9, 0x40ffffff, L"Press WHITE to search for values not equal to before." );
		m_Font.DrawText(  32, 16*10, 0x40ffffff, L"Press DPAD-UP to add 1 to the value" ) ;
		m_Font.DrawText(  32, 16*11, 0x40ffffff, L"Press DPAD-DOWN to subtract 1 from the value" ) ;
		m_Font.DrawText(  32, 16*12, 0x40ffffff, L"Press DPAD-RIGHT to add 10 to the value" ) ;
		m_Font.DrawText(  32, 16*13, 0x40ffffff, L"Press DPAD-LEFT to subtract 10 from the value" ) ;
		m_Font.DrawText(  32, 16*14, 0x40ffffff, L"Press LS+RS to add the found codes to your list" ) ;

		swprintf( str, L"Number of hits from last search : %u", m_currentMemMatches );
		m_Font.DrawText(  32, 16*16, 0x40ffffff, str );

		m_Font.End();

		m_pd3dDevice->Present( NULL, NULL, NULL, NULL );

        XBInput_GetInput();
		if(g_Gamepads[0].hDevice && g_Gamepads[0].bPressedAnalogButtons[XINPUT_GAMEPAD_B])
		{
			break ;
		}
		else if(g_Gamepads[0].hDevice && g_Gamepads[0].bPressedAnalogButtons[XINPUT_GAMEPAD_A])
		{
			m_currentMemMatches = 0 ;
			for ( int i = 0 ; i < CONSOLE_MEMORY_SIZE ; i++ )
			{
				if ( m_memMatches[i] )
					if ( m_memBuf1[i] < m_memBuf2[i] )
					{
						m_memMatches[i] = 1 ;
						m_currentMemMatches++ ;
					}
					else
						m_memMatches[i] = 0 ;
			}

			if ( m_currentMemMatches == 1 )
			{
				doAddFoundCodes() ;
				break ;
			}
		}
		else if(g_Gamepads[0].hDevice && g_Gamepads[0].bPressedAnalogButtons[XINPUT_GAMEPAD_X])
		{
			m_currentMemMatches = 0 ;
			for ( int i = 0 ; i < CONSOLE_MEMORY_SIZE ; i++ )
			{
				if ( m_memMatches[i] )
					if ( m_memBuf2[i] == value )
					{
						m_memMatches[i] = 1 ;
						m_currentMemMatches++ ;
					}
					else
						m_memMatches[i] = 0 ;
			}
			if ( m_currentMemMatches == 1 )
			{
				doAddFoundCodes() ;
				break ;
			}
		}
		else if(g_Gamepads[0].hDevice && g_Gamepads[0].bPressedAnalogButtons[XINPUT_GAMEPAD_Y])
		{
			m_currentMemMatches = 0 ;
			for ( int i = 0 ; i < CONSOLE_MEMORY_SIZE ; i++ )
			{
				if ( m_memMatches[i] )
					if ( m_memBuf1[i] > m_memBuf2[i] )
					{
						m_memMatches[i] = 1 ;
						m_currentMemMatches++ ;
					}
					else
						m_memMatches[i] = 0 ;
			}
			if ( m_currentMemMatches == 1 )
			{
				doAddFoundCodes() ;
				break ;
			}
		}
		else if(g_Gamepads[0].hDevice && g_Gamepads[0].bPressedAnalogButtons[XINPUT_GAMEPAD_BLACK])
		{
			m_currentMemMatches = 0 ;
			for ( int i = 0 ; i < CONSOLE_MEMORY_SIZE ; i++ )
			{
				if ( m_memMatches[i] )
					if ( m_memBuf1[i] == m_memBuf2[i] )
					{
						m_memMatches[i] = 1 ;
						m_currentMemMatches++ ;
					}
					else
						m_memMatches[i] = 0 ;
			}
			if ( m_currentMemMatches == 1 )
			{
				doAddFoundCodes() ;
				break ;
			}
		}
		else if(g_Gamepads[0].hDevice && g_Gamepads[0].bPressedAnalogButtons[XINPUT_GAMEPAD_WHITE])
		{
			m_currentMemMatches = 0 ;
			for ( int i = 0 ; i < CONSOLE_MEMORY_SIZE ; i++ )
			{
				if ( m_memMatches[i] )
					if ( m_memBuf1[i] != m_memBuf2[i] )
					{
						m_memMatches[i] = 1 ;
						m_currentMemMatches++ ;
					}
					else
						m_memMatches[i] = 0 ;
			}
			if ( m_currentMemMatches == 1 )
			{
				doAddFoundCodes() ;
				break ;
			}
		}
		else if ( g_Gamepads[0].hDevice && g_Gamepads[0].wPressedButtons & XINPUT_GAMEPAD_DPAD_DOWN ) 
		{
			value = ( value - 1 ) & 0xFF ;
		}
		else if ( g_Gamepads[0].hDevice && g_Gamepads[0].wPressedButtons & XINPUT_GAMEPAD_DPAD_UP ) 
		{
			value = ( value + 1 ) & 0xFF ;
		}
		else if ( g_Gamepads[0].hDevice && g_Gamepads[0].wPressedButtons & XINPUT_GAMEPAD_DPAD_LEFT ) 
		{
			value = ( value - 10 ) & 0xFF ;
		}
		else if ( g_Gamepads[0].hDevice && g_Gamepads[0].wPressedButtons & XINPUT_GAMEPAD_DPAD_RIGHT ) 
		{
			value = ( value + 10  ) & 0xFF ;
		}
		else if ( (g_Gamepads[0].hDevice && g_Gamepads[0].bAnalogButtons[XINPUT_GAMEPAD_LEFT_TRIGGER]) && (g_Gamepads[0].hDevice && g_Gamepads[0].bAnalogButtons[XINPUT_GAMEPAD_RIGHT_TRIGGER]) )
		{
			if ( ( m_currentMemMatches > 0 ) && ( m_currentMemMatches < 5 ) )
			{
				doAddFoundCodes() ;
				break ;
			}
			else
			{
				while ( 1 )
				{
					m_pd3dDevice->Clear( 0L, NULL, D3DCLEAR_ZBUFFER|D3DCLEAR_STENCIL,
										 0x00000000, 1.0f, 0L );
					RenderGradientBackground( 0xff404040, 0xff404080 );

					m_Font.Begin();
					m_Font.DrawText(  32, 16*2, 0x40ffffff, L"You can only add when you have narrowed " ) ;
					m_Font.DrawText(  32, 16*3, 0x40ffffff, L"it down to less than 5 matches." );
					m_Font.DrawText(  32, 16*5, 0x40ffffff, L"Press B to go back." );
					m_Font.End();

					m_pd3dDevice->Present( NULL, NULL, NULL, NULL );

					XBInput_GetInput();
					if ( g_Gamepads[0].hDevice && g_Gamepads[0].bPressedAnalogButtons[ XINPUT_GAMEPAD_B ] ) 
					{
						break ;
					}
				}
			}
		}
	}
	memcpy( m_memBuf1, m_memBuf2, CONSOLE_MEMORY_SIZE ) ;
}

void CXBoxSample::doCheatMenu()
{

	while ( 1 )
	{
		m_pd3dDevice->Clear( 0L, NULL, D3DCLEAR_ZBUFFER|D3DCLEAR_STENCIL,
							 0x00000000, 1.0f, 0L );
		RenderGradientBackground( 0xff404040, 0xff404080 );

		m_Font.Begin();
		m_Font.DrawText(  32, 16*2, 0x40ffffff, L"OPTIONS MENU" );
		m_Font.DrawText(  32, 16*4, 0x40ffffff, L"B - Return to Game" );
		m_Font.DrawText(  32, 16*5, 0x40ffffff, L"START+BACK - Quit Game" );
		m_Font.DrawText(  32, 16*6, 0x40ffffff, L"BLACK - Start Search for Cheat Code" );
		m_Font.DrawText(  32, 16*7, 0x40ffffff, L"A - Continue Cheat Search" );
		m_Font.DrawText(  32, 16*8, 0x40ffffff, L"RS+LS - Cheat Code List" );
		m_Font.End();

		m_pd3dDevice->Present( NULL, NULL, NULL, NULL );

        XBInput_GetInput();
		if(g_Gamepads[0].hDevice && g_Gamepads[0].bPressedAnalogButtons[XINPUT_GAMEPAD_B])
		{
			m_sound.pause( FALSE ) ;
			m_state = IN_GAME ;
			break ;
		}
		else if ( ( g_Gamepads[0].hDevice && g_Gamepads[0].wButtons & XINPUT_GAMEPAD_START )  &&
			      ( g_Gamepads[0].hDevice && g_Gamepads[0].wButtons & XINPUT_GAMEPAD_BACK )  )
		{
			m_sound.cleanup() ;
			cleanupConsole() ;
			m_state = MAIN_MENU ;
			break ;
		}
		else if(g_Gamepads[0].hDevice && g_Gamepads[0].bPressedAnalogButtons[XINPUT_GAMEPAD_A])
		{
			doContinueSearchMenu() ;
		}
		else if(g_Gamepads[0].hDevice && g_Gamepads[0].bPressedAnalogButtons[XINPUT_GAMEPAD_BLACK])
		{
			doStartSearchMenu() ;
		}
		else if ( (g_Gamepads[0].hDevice && g_Gamepads[0].bAnalogButtons[XINPUT_GAMEPAD_LEFT_TRIGGER]) && (g_Gamepads[0].hDevice && g_Gamepads[0].bAnalogButtons[XINPUT_GAMEPAD_RIGHT_TRIGGER]) )
		{
			doCodeListMenu() ;
		}


	}

}


//-----------------------------------------------------------------------------
// Name: FrameMove
// Desc: Performs per-frame updates
//-----------------------------------------------------------------------------
HRESULT CXBoxSample::FrameMove()
{

	m_bPaused =  ( m_state != IN_GAME ) ;

	if ( m_state == IN_GAME )
	{
		if ( m_dwStartPause > 0 )
		{
			g_dwTimePaused += ( GetTickCount() - m_dwStartPause ) ;
			m_dwStartPause = 0;
		}

		if(m_DefaultGamepad.bPressedAnalogButtons[XINPUT_GAMEPAD_Y])
		{
			m_sound.pause( TRUE ) ;
			m_state = IN_GAME_PAUSED ;
			m_dwStartPause = GetTickCount();
			return S_OK ;
		}
	}
	else if ( m_state == MAIN_MENU )
	{
		if(m_DefaultGamepad.bAnalogButtons[XINPUT_GAMEPAD_Y])
		{
		}
		else if ( ( g_Gamepads[0].hDevice && g_Gamepads[0].wButtons & XINPUT_GAMEPAD_START )  &&
			      ( g_Gamepads[0].hDevice && g_Gamepads[0].wButtons & XINPUT_GAMEPAD_BACK )  &&
				  ( g_Gamepads[0].hDevice && g_Gamepads[0].bAnalogButtons[XINPUT_GAMEPAD_RIGHT_TRIGGER]) &&
				  ( g_Gamepads[0].hDevice && g_Gamepads[0].bAnalogButtons[XINPUT_GAMEPAD_LEFT_TRIGGER]) )
		{
			LD_LAUNCH_DASHBOARD LaunchData = { XLD_LAUNCH_DASHBOARD_MAIN_MENU };
			XLaunchNewImage( NULL, (LAUNCH_DATA*)&LaunchData );
		}
		else if ( (m_DefaultGamepad.bAnalogButtons[XINPUT_GAMEPAD_X]) && (m_DefaultGamepad.bAnalogButtons[XINPUT_GAMEPAD_B]) )
		{
			m_pd3dDevice->Clear( 0L, NULL, D3DCLEAR_ZBUFFER|D3DCLEAR_STENCIL,
								 0x00000000, 1.0f, 0L );
			RenderGradientBackground( 0xff404040, 0xff404080 );
			m_Font.Begin();
			m_Font.DrawText(  32, 16*2, 0x40ffffff, L"Reloading game list..." ) ;
			m_Font.End();
			m_pd3dDevice->Present( NULL, NULL, NULL, NULL );

			if ( numfiles > 0 )
			{
				delete [] files;
				files = NULL;
			}

			numfiles = 0 ;
			FindAvailRoms() ;
		}
		else
		{
			// check for cursor select movement and move
			MoveCursor();

			// check for selection of game and do something (anything!)
			if(m_DefaultGamepad.bAnalogButtons[XINPUT_GAMEPAD_A])
			{
				m_pd3dDevice->Clear( 0L, NULL, D3DCLEAR_ZBUFFER|D3DCLEAR_STENCIL,
									 0x00000000, 1.0f, 0L );
				RenderGradientBackground( 0xff404040, 0xff404080 );
				m_Font.Begin();
				m_Font.DrawText(  32, 16*2, 0x40ffffff, L"Loading game...please wait." ) ;
				m_Font.End();
				m_pd3dDevice->Present( NULL, NULL, NULL, NULL );
				initConsole(curr) ;
				m_state = IN_GAME ;
				return S_OK ;
			}
		}
	}
	else if ( m_state == IN_GAME_PAUSED )
	{
		m_sound.pause( TRUE ) ;
		m_bPaused =  TRUE ;
		doCheatMenu() ;

		return S_OK ;
	}
	else
	{
	}

    return S_OK;
}


int CXBoxSample::render_to_texture()
{
	RECT src, dst;
	byte *curr1, *curr2 ;
	
	// Get a description of our level 0 texture so we can figure
	// out the pitch of the texture
	D3DSURFACE_DESC desc;
    Texture->GetLevelDesc(0, &desc);
	
	
	// Allocate a buffer to blit our frames to

	// Figure out how big of a rect to lock in our texture
	RECT rectSource;
	rectSource.top = 0;
	rectSource.left = 0;
	rectSource.bottom = theHeight-1 ;
	rectSource.right  = theWidth-1 ;

	// Lock the rect in our texture
	D3DLOCKED_RECT d3dlr;
	Texture->LockRect(0, &d3dlr, &rectSource, 0);

	
	curr1 = g_pAlignBuff ;
	curr2 = g_pBlitBuff ;
/*
	for ( int y = 0 ; y < theHeight ; y++ )
	{
		curr1 = ((byte*)g_pAlignBuff) + ( y*d3dlr.Pitch ) ;
		curr2 = ((byte*)g_pBlitBuff) + ( y*fb.pitch ) ;
		memcpy( curr1, curr2, fb.pitch ) ;
	}
	
	// Swizzle the blittled surface back to the texture
	XGSwizzleRect(g_pAlignBuff, 0, NULL, d3dlr.pBits, desc.Width, desc.Height, NULL, 4);
*/

	// Swizzle the blittled surface back to the texture
	XGSwizzleRect(g_pBlitBuff, 0, NULL, d3dlr.pBits, desc.Width, desc.Height, NULL, 4);

	// Unlock our texture
	Texture->UnlockRect(0);

	//delete [] g_pBlitBuff;
	//g_pBlitBuff = NULL;


	src.left   = 0;
	src.top    = 0;
	src.right  = theWidth  + 0;
	src.bottom = theHeight + 1;

	UINT iWidth  = theWidth;
	UINT iHeight = theHeight;
	
	// win_start_maximized the rect, constraining to the aspect ratio
	dst.left   = dst.top = 0;
	dst.right  = iWidth;
	dst.bottom = iHeight;
	
	// center
	//dst.left   += ((iWidth - (dst.right - dst.left)) / 2)  + ((640-iWidth)/2);
	//dst.top    += ((iHeight - (dst.bottom - dst.top)) / 2) + ((480-iHeight)/2);
	//dst.right  += dst.left;
	//dst.bottom += dst.top;
	
    // Clear the viewport
//	if ( ( m_DefaultGamepad.bAnalogButtons[ XINPUT_GAMEPAD_A ] ) || ( m_DefaultGamepad.bAnalogButtons[ XINPUT_GAMEPAD_X ] ) )  
	    g_pd3dDevice->Clear(0L, NULL, D3DCLEAR_TARGET, D3DCOLOR_XRGB(0,0,0), 1.0f, 0L);
	
	// Begin the Scene
	g_pd3dDevice->BeginScene();

	// Compute the source and dest image sizes
	const float dw = dst.right-dst.left;
	const float dh = dst.bottom-dst.top;
	const float sw = src.right-src.left;
	const float sh = src.bottom-src.top;

	// Compute the scale and transform vectors
	//D3DXVECTOR2 vecScale(dw/sw, dh/sh);
	D3DXVECTOR2 vecScale(2, 2);
	D3DXVECTOR2 vecTranslate(160, 240-144 );
	//D3DXVECTOR2 vecTranslate(dst.left, dst.top);
	
	D3DXCOLOR d3color(1.0, 1.0, 1.0, 1.0);
	
	// Draw the sprite
	//if ( ( m_DefaultGamepad.bAnalogButtons[ XINPUT_GAMEPAD_A ] ) || ( m_DefaultGamepad.bAnalogButtons[ XINPUT_GAMEPAD_Y ] ) )  
		Sprite->Draw(Texture, &rectSource, &vecScale, NULL, 0, &vecTranslate, d3color);
	
	// End the scene.
	g_pd3dDevice->EndScene();
	
	// Present the scene
	//if ( ( m_DefaultGamepad.bAnalogButtons[ XINPUT_GAMEPAD_A ] ) || ( m_DefaultGamepad.bAnalogButtons[ XINPUT_GAMEPAD_BLACK ] ) )  
		//g_pd3dDevice->Present(NULL, NULL, NULL, NULL);

	return 1;
}

//-----------------------------------------------------------------------------
// Name: Render
// Desc: Renders the scene
//-----------------------------------------------------------------------------
HRESULT CXBoxSample::Render()
{
	m_bPaused =  ( m_state != IN_GAME ) ;


	if ( m_state == IN_GAME )
	{
		if ( m_dwStartPause > 0 )
		{
			g_dwTimePaused += ( GetTickCount() - m_dwStartPause ) ;
			m_dwStartPause = 0;
		}

		// Clear the zbuffer
		m_pd3dDevice->Clear( 0L, NULL, D3DCLEAR_ZBUFFER|D3DCLEAR_STENCIL,
							 0x00000000, 1.0f, 0L );

		// Draw a gradient filled background
		RenderGradientBackground( 0xff404040, 0xff404080 );

		if ( global_error_message[0] != 0 )
		{
			WCHAR str[5000];

			m_Font.Begin();
			//swprintf( str, L"%S", global_error_message );
			//m_Font.DrawText( 32, 48, 0x40ffffff, str );
			m_Font.DrawText( 32, 48, 0x40ffffff, L"ERROR" );
			m_Font.End();
		}
		else
		{

			processEmu( TRUE ) ;

			if ( m_msgDelay > 0 )
			{
				m_msgDelay-- ;
				m_Font.Begin();
				m_Font.DrawText(  32, 32, 0xffffff00, m_strMessage );
				m_Font.End();
			}
			else
			{
				float elapsedTime ;
				m_Font.Begin();
				WCHAR str[2000];
				elapsedTime = ( (float)GetTickCount() - (float)g_dwStartTime - (float)g_dwTimePaused ) / 1000.0f ;
				swprintf( str, L"apptime %5.5f, sndbytes %u, avg %6.5f, fps %5.5f cfps %5.5f", elapsedTime, m_sound.m_totalBytesWritten, 
					((float)m_sound.m_totalBytesWritten) / elapsedTime, m_fFPS, ((float)m_numFrames) / m_fAppTime );
				//m_Font.DrawText( 20, 32, 0x40ffffff, str );
				m_Font.End();
			}
		}
		
		// Present the scene
		m_pd3dDevice->Present( NULL, NULL, NULL, NULL );
	}
	else if ( m_state == IN_GAME_PAUSED )
	{
	}
	else if ( m_state == MAIN_MENU )
	{
		// Clear the zbuffer
		m_pd3dDevice->Clear( 0L, NULL, D3DCLEAR_ZBUFFER|D3DCLEAR_STENCIL,
							 0x00000000, 1.0f, 0L );
		RenderGradientBackground( 0xff404040, 0xff404080 );

		if(m_DefaultGamepad.bAnalogButtons[XINPUT_GAMEPAD_Y])
		{
			m_Font.Begin(); 
			m_Font.DrawText(32, 16*3,  0x40ffffff, L"Gnuboy for XBOX");
			m_Font.DrawText(32, 16*5,  0x40ffffff, L"Main Menu Controls");
			m_Font.DrawText(32, 16*6,  0x40ffffff, L"A - Play Selected Game");
			m_Font.DrawText(32, 16*7,  0x40ffffff, L"Y - Show This Help Screen");
			m_Font.DrawText(32, 16*8,  0x40ffffff, L"UP/DOWN - Select Game");
			m_Font.DrawText(32, 16*9,  0x40ffffff, L"RIGHT/LEFT - Next/Prev Page");
			m_Font.DrawText(32, 16*10,  0x40ffffff, L"LS/RS - Next/Prev Letter");
			m_Font.DrawText(32, 16*11,  0x40ffffff, L"START+BACK+LS+RS - Exit to dashboard");
			m_Font.DrawText(32, 16*12,  0x40ffffff, L"X+B - Reload list");
			m_Font.DrawText(32, 16*13,  0x40ffffff, L"BLACK+WHITE - Delete save files");
			m_Font.DrawText(32, 16*14,  0x5000ff00, L"Lines colored like this have save files on the HD.");

			m_Font.DrawText(32, 16*16, 0x40ffffff, L"In-Game Controls");
			m_Font.DrawText(32, 16*17, 0x40ffffff, L"A - A Button");
			m_Font.DrawText(32, 16*18, 0x40ffffff, L"X - B Button");
			m_Font.DrawText(32, 16*19, 0x40ffffff, L"DPAD - Joystick Movement");
			m_Font.DrawText(32, 16*20, 0x40ffffff, L"START - Start");
			m_Font.DrawText(32, 16*21, 0x40ffffff, L"BACK - Select");
			m_Font.DrawText(32, 16*22, 0x40ffffff, L"Y - Options Menu");
			m_Font.End();
		}
		else if ( ( m_DefaultGamepad.bAnalogButtons[ XINPUT_GAMEPAD_BLACK ] ) &&
				  ( m_DefaultGamepad.wButtons & XINPUT_GAMEPAD_LEFT_THUMB ) &&
				  ( m_DefaultGamepad.wButtons & XINPUT_GAMEPAD_RIGHT_THUMB ) )
		{
			m_Font.Begin(); 
			m_Font.DrawText(48, 32, 0x40ffffff, L"Gnuboy for XBOX - made by me");
			m_Font.End();
		}
		else if ( ( m_DefaultGamepad.bAnalogButtons[ XINPUT_GAMEPAD_BLACK ] ) &&
				  ( m_DefaultGamepad.bAnalogButtons[ XINPUT_GAMEPAD_WHITE ] ) )
		{
			deleteSaveFiles( curr ) ;
		}
		else
		{
			WCHAR str[2000];
			swprintf( str, L"Gnuboy for XBOX  Y-Help Screen  Found %u games", numfiles);

			m_Font.Begin(); 
			m_FontSmall.Begin(); 
			m_Font.DrawText( 48, 32, 0x40ffffff, str );
			//m_Font.DrawText(48, 32, 0x40ffffff, L"Gnuboy for XBOX  Y-Help Screen");


			
			
			float fWinX = 32, fWinY = 64;


			for ( unsigned int idx = topIdx ; ( idx < numfiles ) && ( idx < topIdx+NAMES_PER_PAGE) ; idx++ )
			{
				if ( curr == idx )
				{
					if ( hasFiles( idx ) )
						m_FontSmall.DrawText(fWinX +10 , fWinY, 0xff00ff00, files[idx].name );
					else
						m_FontSmall.DrawText(fWinX +10, fWinY, 0xffffffff, files[idx].name );
				}
				else
				{
					if ( hasFiles( idx ) )
						m_FontSmall.DrawText(fWinX, fWinY, 0x5000ff00, files[idx].name );
					else
						m_FontSmall.DrawText(fWinX, fWinY, 0x50ffffff, files[idx].name );
				}
				fWinY += 14;
			}
			

			// end font drawing
			m_Font.End();
			m_FontSmall.End();


		}

		m_pd3dDevice->Present( NULL, NULL, NULL, NULL );
	}
	else if ( m_state == INIT_SYSTEM )
	{
		InitializeWithScreen() ;
	}
	else if ( m_state == INIT_SYSTEM_SHOW_SCREEN )
	{
	}
	else
	{
	}



    return S_OK;
}

/**
  This routine should be called regularly to handle events
*/

void CXBoxSample::handleEvents()
{

    INT32 resistance ;
	float newRes ;
  
	if ( g_Gamepads[0].hDevice && g_Gamepads[0].bAnalogButtons[ XINPUT_GAMEPAD_A ] ) 
		pad_press( PAD_A ) ;
	else
		pad_release( PAD_A ) ;

	if ( g_Gamepads[0].hDevice && g_Gamepads[0].bAnalogButtons[ XINPUT_GAMEPAD_X ] ) 
		pad_press( PAD_B ) ;
	else
		pad_release( PAD_B ) ;

	if ( g_Gamepads[0].hDevice && g_Gamepads[0].wButtons & XINPUT_GAMEPAD_DPAD_LEFT ) 
		pad_press( PAD_LEFT ) ;
	else
		pad_release( PAD_LEFT ) ;

	if ( g_Gamepads[0].hDevice && g_Gamepads[0].wButtons & XINPUT_GAMEPAD_DPAD_RIGHT ) 
		pad_press( PAD_RIGHT ) ;
	else
		pad_release( PAD_RIGHT ) ;


	if ( g_Gamepads[0].hDevice && g_Gamepads[0].wButtons & XINPUT_GAMEPAD_DPAD_UP ) 
		pad_press( PAD_UP ) ;
	else
		pad_release( PAD_UP ) ;
	
	if ( g_Gamepads[0].hDevice && g_Gamepads[0].wButtons & XINPUT_GAMEPAD_DPAD_DOWN ) 
		pad_press( PAD_DOWN ) ;
	else
		pad_release( PAD_DOWN ) ;
	
	
	
	if ( g_Gamepads[0].hDevice && g_Gamepads[0].wButtons & XINPUT_GAMEPAD_START )  
		pad_press( PAD_START ) ;
	else
		pad_release( PAD_START ) ;

	if ( g_Gamepads[0].hDevice && g_Gamepads[0].wButtons & XINPUT_GAMEPAD_BACK )  
		pad_press( PAD_SELECT ) ;
	else
		pad_release( PAD_SELECT ) ;



}


void CXBoxSample::FindAvailRoms()
{
	// Search for all files in our rom directory
	HANDLE hFind;	
	WIN32_FIND_DATAA oFindData;
	hFind = FindFirstFile( "D:\\gbroms\\*", &oFindData);
	
	// If we didn't find any just return
	if (hFind == INVALID_HANDLE_VALUE)
	{
		return;
	}
	
	do 
	{
		numfiles++ ;
	} while (FindNextFile(hFind, &oFindData));

	FindClose( hFind );

	if (files != NULL)
	{
		delete [] files;
		files = NULL;
	}
	
	// Allocate a buffer to blit our frames to
	files = new FILENAME[numfiles];

	numfiles = 0 ;

	hFind = FindFirstFile( "D:\\gbroms\\*", &oFindData);
	
	// If we didn't find any just return
	if (hFind == INVALID_HANDLE_VALUE)
	{
		return;
	}
	
	do 
	{
		// Mame's games are in 8-bit ansi convert them to unicode for display
		//WCHAR wcName[200];
		//mbsrtowcs(wcName, &pName, 200, NULL);

		files[numfiles].name[0] = 0 ;
		strcpy( (char*)(files[numfiles].filename), oFindData.cFileName ) ;
		strlwr( (char*)( files[numfiles].filename )) ;
        swprintf( files[numfiles].name, L"%S", files[numfiles].filename );
//		mbsrtowcs(files[numfiles].name, (const char**)( &(oFindData.cFileName) ), 30, NULL);
		numfiles++ ;
	} while (FindNextFile(hFind, &oFindData));

	FindClose( hFind );
}

// check for move cursor and move accordingly (with clamp etc)
void CXBoxSample::MoveCursor()
{
	char c ;
	int  lcv ;

		if (m_DefaultGamepad.bPressedAnalogButtons[XINPUT_GAMEPAD_RIGHT_TRIGGER])
		{
			c = tolower(files[curr].filename[0]) ;

			lcv = curr ;

			while ( ( lcv < numfiles ) && ( tolower(files[lcv].filename[0]) <= c ) )
				lcv++ ;

			if ( lcv < numfiles )
			{
				topIdx = lcv ;
				curr = lcv ;
			}
			else
			{
				topIdx = numfiles - 1 ;
				curr = numfiles - 1 ;
			}
		}
		else if (m_DefaultGamepad.bPressedAnalogButtons[XINPUT_GAMEPAD_LEFT_TRIGGER])
		{
			c = tolower(files[curr].filename[0]) ;

			lcv = curr ;

			while ( ( lcv >= 0 ) && ( tolower(files[lcv].filename[0]) >= c ) )
				lcv-- ;

			if ( lcv >= 0 )
			{
				topIdx = lcv ;
				curr = lcv ;
			}
			else
			{
				topIdx = 0 ;
				curr = 0 ;
			}
		}
		else if ( m_DefaultGamepad.wPressedButtons & XINPUT_GAMEPAD_DPAD_LEFT ) 
		{
			if ( topIdx >= NAMES_PER_PAGE )
			{
				topIdx -= NAMES_PER_PAGE ;
				curr = topIdx ;
			}
			else
			{
				topIdx = 0 ;
				curr = 0 ;
			}
		}
		else if ( m_DefaultGamepad.wPressedButtons & XINPUT_GAMEPAD_DPAD_RIGHT ) 
		{
			if ( topIdx + NAMES_PER_PAGE < numfiles )
			{
				topIdx += NAMES_PER_PAGE ;
				curr = topIdx ;
			}
			else
			{
				topIdx = numfiles - 1 ;
				curr = numfiles - 1 ;
			}
		}
		else if ( m_DefaultGamepad.wPressedButtons & XINPUT_GAMEPAD_DPAD_DOWN ) 
		{
			if ( curr == topIdx + (NAMES_PER_PAGE-1) )
			{
				if ( curr < numfiles - 1 )
				{
					topIdx++ ;
					curr++ ;
				}
			}
			else
			{
				if ( curr < numfiles-1 )
					curr++ ;
			}
		}
		else if ( m_DefaultGamepad.wPressedButtons & XINPUT_GAMEPAD_DPAD_UP ) 
		{
			if ( curr == topIdx )
			{
				if ( curr > 0 )
				{
					topIdx-- ;
					curr-- ;
				}
			}
			else
			{
				if ( curr > 0 )
					curr-- ;
			}
		}

}



void CXBoxSample::initConsole( UINT32 idx )
{
	char                filename[500] ;
	unsigned char       *gimage ;
	FILE				*infile ;
	UINT32				fsize ;
	char *forcebuf ;

	global_error_message[0] = 0 ;

	m_numFrames = 0 ;

	memset( m_memMatches, 1, CONSOLE_MEMORY_SIZE ) ;
	m_currentMemMatches = CONSOLE_MEMORY_SIZE ;
	m_numCheats = 0 ;

	strcpy((char*)filename, "D:\\gbroms\\" ) ;
	//wcsrtombs( (char*)gfilename, (const wchar_t**)(&(files[idx].name)), 100, NULL ) ;
	strcat( (char*)filename, (const char*)files[idx].filename ) ;

	m_sound.init() ;


	// Get the desired width and height of the display
	theWidth = 160 ;
	theHeight = 144 ;

	// Create our texture
	init_texture();

	fb.ptr = g_pBlitBuff ;

	// Create our sprite driver
	if ( Sprite == NULL )
		D3DXCreateSprite(m_pd3dDevice, &Sprite);
	


	//BEGIN EACH TIME
	char *p;


	memset(&rom, 0, sizeof(rom)) ;
	memset(&mbc, 0, sizeof(mbc)) ;
	memset(&rtc, 0, sizeof(rtc)) ;
	memset(&hw,  0, sizeof(hw)) ;
	memset(&scan,0, sizeof(scan)) ;
	memset(&cpu, 0, sizeof(cpu)) ;

	nobatt = 0 ;
	forcebatt = 0 ;
	forcedmg = 0 ;
	gbamode = 0 ;

	memset(pcm.buf, 0, pcm.len);
	pcm.pos = 0;

	romfile = filename ;

	if ( strstr( romfile, ".zip" ) == NULL )
		rom_load();
	else
		rom_load_zip() ;


	saveprefix = g_saveprefix ;
	strcpy( g_saveprefix, savedir ) ;
	strcat( g_saveprefix, "\\" ) ;
	strcat( g_saveprefix, (const char*)(files[idx].filename) ) ;
	//sprintf(saveprefix, "%s\\%s", savedir, (const char*)files[idx].filename);
	p = strchr(g_saveprefix, '.');
	if (p) *p = 0;

	sramfile = g_sramfile ;
	strcpy(sramfile, saveprefix);
	strcat(sramfile, ".sav");

	rtcfile = g_rtcfile ;
	strcpy(rtcfile, saveprefix);
	strcat(rtcfile, ".rtc");

	strcpy(g_chtfile, saveprefix);
	strcat(g_chtfile, ".cht");

	sram_load();
	rtc_load();
	cht_load();

	emu_reset();
	lcd_begin();

	m_fAppTime = 0.0f ;

	g_dwStartTime = GetTickCount() ;
	g_dwTimePaused = 0 ;
	m_dwStartPause = 0 ;

	m_steps = 0 ;

	//put 3 frames of data in the audio buffer
	processEmu(FALSE) ;
	processEmu(FALSE) ;
	processEmu(FALSE) ;

	//Then start it up
	m_sound.pause( FALSE ) ;

}

void CXBoxSample::cleanupConsole( )
{
	sram_save();
	rtc_save();
	cht_save() ;
	//pcm_close();

	if ( rom.bank != NULL )
		free( rom.bank ) ;

	if ( ram.sbank != NULL )
		free( ram.sbank ) ;


	if (m_cheatCodes != NULL)
	{
		free(m_cheatCodes);
		m_cheatCodes = NULL;
	}
	//see loader_unload() for other things to free
}

void CXBoxSample::cht_load()
{
	FILE *f;
	CHEAT_CODE code ;
	int fsize ;
	int numread ;

	if (m_cheatCodes != NULL)
	{
		free(m_cheatCodes);
		m_cheatCodes = NULL;
	}
	

	f = fopen(g_chtfile, "rb");
	if (!f) return ;

	fseek( f, 0, SEEK_END ) ;
	fsize = ftell( f ) ;
	fseek( f, 0, SEEK_SET ) ;

	m_numCheats = fsize / sizeof(CHEAT_CODE) ;

	m_cheatCodes = (CHEAT_CODE*)malloc( sizeof(CHEAT_CODE) *  m_numCheats );


	numread = 0 ;
	fread(m_cheatCodes, sizeof(CHEAT_CODE), m_numCheats, f);

	fclose(f);
}

void CXBoxSample::cht_save()
{
	FILE *f;
	CHEAT_CODE code ;

	if ( m_numCheats == 0 )
	{
		DeleteFile( g_chtfile ) ;
		return ;
	}

	f = fopen(g_chtfile, "wb");
	if (!f) return ;

	fwrite(m_cheatCodes, sizeof(CHEAT_CODE), m_numCheats, f);

	fclose(f);
	
}

BOOL CXBoxSample::hasFiles( int idx )
{
	char                filename[500] ;
	unsigned char       *gimage ;
	FILE				*infile ;
	UINT32				fsize ;
	char *forcebuf ;
	char *p;


	saveprefix = g_saveprefix ;
	strcpy( g_saveprefix, savedir ) ;
	strcat( g_saveprefix, "\\" ) ;
	strcat( g_saveprefix, (const char*)(files[idx].filename) ) ;
	//sprintf(saveprefix, "%s\\%s", savedir, (const char*)files[idx].filename);
	p = strchr(g_saveprefix, '.');
	if (p) *p = 0;

	sramfile = g_sramfile ;
	strcpy(sramfile, saveprefix);
	strcat(sramfile, ".sav");

	rtcfile = g_rtcfile ;
	strcpy(rtcfile, saveprefix);
	strcat(rtcfile, ".rtc");

	strcpy(g_chtfile, saveprefix);
	strcat(g_chtfile, ".cht");

	infile = fopen( g_sramfile, "rb" ) ;

	if ( infile )
	{
		fclose(infile) ;
		return TRUE ;
	}

	infile = fopen( g_rtcfile, "rb" ) ;

	if ( infile )
	{
		fclose(infile) ;
		return TRUE ;
	}

	infile = fopen( g_chtfile, "rb" ) ;

	if ( infile )
	{
		fclose(infile) ;
		return TRUE ;
	}

	return FALSE ;

}
void CXBoxSample::updateCheats( )
{
	for ( int i = 0 ; i < m_numCheats ; i++ )
	{
		if ( m_cheatCodes[i].enabled )
			m_consoleMemory[ m_cheatCodes[i].adr - 0xC000 ] = ( m_cheatCodes[i].val & 0xFF ) ;
	}
}

void CXBoxSample::deleteSaveFiles( int idx )
{
	char                filename[500] ;
	unsigned char       *gimage ;
	FILE				*infile ;
	UINT32				fsize ;
	char *forcebuf ;
	char *p;


	saveprefix = g_saveprefix ;
	strcpy( g_saveprefix, savedir ) ;
	strcat( g_saveprefix, "\\" ) ;
	strcat( g_saveprefix, (const char*)(files[idx].filename) ) ;
	//sprintf(saveprefix, "%s\\%s", savedir, (const char*)files[idx].filename);
	p = strchr(g_saveprefix, '.');
	if (p) *p = 0;

	sramfile = g_sramfile ;
	strcpy(sramfile, saveprefix);
	strcat(sramfile, ".sav");

	rtcfile = g_rtcfile ;
	strcpy(rtcfile, saveprefix);
	strcat(rtcfile, ".rtc");

	strcpy(g_chtfile, saveprefix);
	strcat(g_chtfile, ".cht");

	DeleteFile( g_sramfile ) ;
	DeleteFile( g_rtcfile ) ;
	DeleteFile( g_chtfile ) ;

}
#ifdef __cplusplus
extern "C" {
#endif

void audio_callback()
{
	g_sound->process( *g_apptime, *g_numframes ) ;

}

#ifdef __cplusplus
}
#endif

void CXBoxSample::processEmu( BOOL render )
{
			cpu_emulate(2280);
			
			updateCheats() ;

			while (R_LY > 0 && R_LY < 144)
				emu_step();
			
			updateCheats() ;

			if ( render )
			{
				render_to_texture();
				m_numFrames++ ;
			}

			rtc_tick();
			sound_mix();
			m_sound.process( m_fAppTime, m_numFrames ) ;
			handleEvents();
 			
			if (!(R_LCDC & 0x80))
				cpu_emulate(32832);
			
			updateCheats() ;

			while (R_LY > 0) // wait for next frame 
				emu_step();

			updateCheats() ;

}


int CXBoxSample::rom_load_zip()
{
	byte c, *data, *header;
	int len = 0, rlen;

    unzFile file = unzOpen(romfile);

    if(file == NULL)
		die("cannot open rom file: %s\n", romfile);


    char filename[132];
    int filesize = 0;
    int port = unzGoToFirstFile(file);
    unz_file_info info;

    while(port == UNZ_OK)
    {
		char name[132];
		unzGetCurrentFileInfo(file, &info, name,128, NULL,0, NULL,0);

		if ((int) info.uncompressed_size > filesize)
		{
			strcpy(filename,name);
			filesize = info.uncompressed_size;
		}
		port = unzGoToNextFile(file);
    }

    if( !(port == UNZ_END_OF_LIST_OF_FILE || port == UNZ_OK) || filesize == 0)
    {
		unzClose(file) ;
		die("cannot open rom file: %s\n", romfile);
    }

    unzLocateFile(file,filename,1);
    unzGetCurrentFileInfo(file, &info, filename,128, NULL,0, NULL,0);
    
    if( unzOpenCurrentFile(file) != UNZ_OK )
    {
		unzClose(file);
		die("cannot open rom file: %s\n", romfile);
    }

	data = (byte*)malloc( info.uncompressed_size ) ;

	int l = unzReadCurrentFile(file,data,info.uncompressed_size);
	if(unzCloseCurrentFile(file) == UNZ_CRCERROR)
	{
		free(data) ;
	    unzClose(file);
		die("cannot open rom file: %s\n", romfile);
	}

    unzClose(file);

	len = info.uncompressed_size ;

	header = data ;
	
	memcpy(rom.name, header+0x0134, 16);
	if (rom.name[14] & 0x80) rom.name[14] = 0;
	if (rom.name[15] & 0x80) rom.name[15] = 0;
	rom.name[16] = 0;

	c = header[0x0147];
	mbc.type = mbc_table[c];
	mbc.batt = (batt_table[c] && !nobatt) || forcebatt;
	rtc.batt = rtc_table[c];
	mbc.romsize = romsize_table[header[0x0148]];
	mbc.ramsize = ramsize_table[header[0x0149]];

	if (!mbc.romsize) die("unknown ROM size %02X\n", header[0x0148]);
	if (!mbc.ramsize) die("unknown SRAM size %02X\n", header[0x0149]);

	rlen = 16384 * mbc.romsize;
	rom.bank = (byte(*)[16384])realloc(data, rlen);
	if (rlen > len) memset(rom.bank[0]+len, 0xff, rlen - len);
	
	ram.sbank = (byte(*)[8192])malloc(8192 * mbc.ramsize);

	//initmem(ram.sbank, 8192 * mbc.ramsize);
	//initmem(ram.ibank, 4096 * 8);

	mbc.rombank = 1;
	mbc.rambank = 0;

	c = header[0x0143];
	hw.cgb = ((c == 0x80) || (c == 0xc0)) && !forcedmg;
	hw.gba = (hw.cgb && gbamode);

	return 0;
}

//sometimes items are just gone
//re-load list
//pAL/ntsc
//quit app to return to dashboard
