/*
	WinSTon

	Sound Property Page
*/

#include "..\includes\winston.h"
#include "..\includes\dialog.h"
#include "..\includes\daudio.h"
#include "..\includes\file.h"
#include "..\includes\sound.h"

// List of possible playback frequencies(MUST match PLAYBACK_xxxx)
static char *pszPlayBackItemStrings[] = {
	"Low (11Khz)",
	"Medium (22Khz)",
	"High (44Khz)",
	NULL	//term
};

// Button IDs
static int AllSound_DialogItems[] = {
	IDC_RADIO_ENABLESOUND,
	IDC_RADIO_ENABLE_SAMPLES,
	IDC_STATIC_PLAYBACKQUALITY,
	IDC_COMBO_PLAYBACKQUALITY,
	IDC_BUTTON_CAPTUREYM_BROWSE,
	IDC_EDIT_CAPTUREYM,
	IDC_BUTTON_CAPTUREYM_RECORD,
	IDC_BUTTON_CAPTUREYM_STOP,
	0,	//term
};

static int Sound_DialogItems[] = {
	IDC_RADIO_ENABLE_SAMPLES,
	IDC_STATIC_PLAYBACKQUALITY,
	IDC_COMBO_PLAYBACKQUALITY,
	IDC_BUTTON_CAPTUREYM_BROWSE,
	IDC_EDIT_CAPTUREYM,
	IDC_BUTTON_CAPTUREYM_RECORD,
	IDC_BUTTON_CAPTUREYM_STOP,
	0,	//term
};

static int CaptureYM_DialogItems[] = {
	IDC_BUTTON_CAPTUREYM_RECORD,
	IDC_BUTTON_CAPTUREYM_STOP,
	0,	//term
};

HWND SoundhDlg = NULL;

//-----------------------------------------------------------------------
/*
	Set defaults for Sound
*/
void Dialog_Sound_SetDefaults(void)
{
	// Set defaults for Sound
	ConfigureParams.Sound.bEnableSound = TRUE;
	ConfigureParams.Sound.nPlaybackQuality = PLAYBACK_HIGH;
	strcpy(ConfigureParams.Sound.szYMCaptureFileName,"");
}

//-----------------------------------------------------------------------
/*
	Store/Clear hDlg handle so can change options on this page while viewing another
*/
void Dialog_Sound_ClearHandle(void)
{
	SoundhDlg = NULL;
}

//-----------------------------------------------------------------------
/*
	Get hDlg handle
*/
HWND Dialog_Sound_GetHandle(void)
{
	return(SoundhDlg);
}

//-----------------------------------------------------------------------
/*
	Enable item according to options states
*/
void Dialog_Sound_EnableItems(HWND hDlg)
{
	// Valid handle?
	if (hDlg) {
		// Is sound working?
		if (bDirectSoundWorking) {
			// Turn on all by default
			Dialog_EnableItems(hDlg,Sound_DialogItems,TRUE);

			// Is sound enabled? If not grey out
			if (!Dialog_ReadButton(hDlg,IDC_RADIO_ENABLESOUND))
				Dialog_EnableItems(hDlg,Sound_DialogItems,FALSE);
			else {
				// Are we recording? If so, grey 'Record'
				if (Sound_AreWeRecording())
					Dialog_EnableItem(hDlg,IDC_BUTTON_CAPTUREYM_RECORD,FALSE);
				// If not recording, disable 'Stop'
				if (!Sound_AreWeRecording())
					Dialog_EnableItem(hDlg,IDC_BUTTON_CAPTUREYM_STOP,FALSE);
			}
		}
		else {
			// Sound has not been initialised correctly, disable all sound options
			Dialog_EnableItems(hDlg,AllSound_DialogItems,FALSE);
		}
	}
}

//-----------------------------------------------------------------------
/*
	Write settings into dialog page
*/
void Dialog_Sound_WritePopulate(HWND hDlg)
{
	// Set global dialog handle
	SoundhDlg = hDlg;

	// Set items
	Dialog_SetButton(hDlg,IDC_RADIO_ENABLESOUND,DialogParams.Sound.bEnableSound);
	Dialog_SetComboBoxItems(hDlg,IDC_COMBO_PLAYBACKQUALITY,pszPlayBackItemStrings,DialogParams.Sound.nPlaybackQuality);
	Dialog_SetText(hDlg,IDC_EDIT_CAPTUREYM,DialogParams.Sound.szYMCaptureFileName);

	Dialog_Sound_EnableItems(hDlg);

	bOKDialog = TRUE;
}

//-----------------------------------------------------------------------
/*
	Read settings back from dialog page
*/
void Dialog_Sound_ReadPopulate(HWND hDlg)
{
	// Read items
	DialogParams.Sound.bEnableSound = Dialog_ReadButton(hDlg,IDC_RADIO_ENABLESOUND);
	DialogParams.Sound.nPlaybackQuality = Dialog_GetSelectedComboBoxItem(hDlg,IDC_COMBO_PLAYBACKQUALITY);
	Dialog_ReadText(hDlg,IDC_EDIT_CAPTUREYM,DialogParams.Sound.szYMCaptureFileName);
}

//-----------------------------------------------------------------------
/*
	Browse for sound capture image file (*.YM, *.WAV)
*/
void Dialog_Sound_BrowseCapture_YM_WAV_File(HWND hDlg)
{
	// Browse for file and change edit box if OK
	if (File_OpenSelectDlg(hWnd,DialogParams.Sound.szYMCaptureFileName,FILEFILTER_YMFILE,FALSE,TRUE))
		Dialog_SetText(hDlg,IDC_EDIT_CAPTUREYM,DialogParams.Sound.szYMCaptureFileName);
}

//-----------------------------------------------------------------------
/*
	Start recording of YM/WAV data
*/
void Dialog_Sound_YM_WAV_Record(HWND hDlg)
{
	// Read details from dialog
	Dialog_ReadText(hDlg,IDC_EDIT_CAPTUREYM,DialogParams.Sound.szYMCaptureFileName);
	// Begin recording from here, inform user
	if (Sound_BeginRecording(hDlg,DialogParams.Sound.szYMCaptureFileName)) {
		Dialog_SetText(hDlg,IDC_EDIT_CAPTUREYM,DialogParams.Sound.szYMCaptureFileName);
		// Copy to global as may be needed
		strcpy(ConfigureParams.Sound.szYMCaptureFileName,DialogParams.Sound.szYMCaptureFileName);
	}
	Dialog_Sound_EnableItems(hDlg);
}

//-----------------------------------------------------------------------
/*
	Stop recording of YMWAV data
*/
void Dialog_Sound_YM_WAV_Stop(HWND hDlg)
{
	// Stop recording now, inform user
	Sound_EndRecording(hDlg);
	Dialog_Sound_EnableItems(hDlg);
}

//-----------------------------------------------------------------------
/*
	Sound Property page handler
*/
BOOL FAR PASCAL Dialog_Sound_DlgProc(HWND hDlg, UINT Message, UINT wParam, LONG lParam)
{
	switch(Message) {
		case WM_INITDIALOG:
			Dialog_Sound_WritePopulate(hDlg);
			nLastOpenPage = DIALOG_PAGE_SOUND;
			return(TRUE);

		case WM_NOTIFY:
			switch(((NMHDR *)lParam)->code) {
				case PSN_APPLY:
					Dialog_Sound_ReadPopulate(hDlg);
					return(TRUE);
				case PSN_HELP:
					WinSTon_GoWeb("help\\options\\sound.html",FALSE);
					return(TRUE);
			}
			break;

		case WM_HELP:
			// Open help
			WinSTon_GoWeb("help\\options\\sound.html",FALSE);
			return(TRUE);

		case WM_COMMAND:
			switch(LOWORD(wParam)) {
				case IDC_EDIT_CAPTUREYM:
					if (HIWORD(wParam)==EN_CHANGE)
						Dialog_Sound_EnableItems(hDlg);
					return(TRUE);

				case IDC_RADIO_ENABLESOUND:
					// Update as used on Sound+Configure dialog
					DialogParams.Sound.bEnableSound = Dialog_ReadButton(hDlg,IDC_RADIO_ENABLESOUND);
					Dialog_SetButton(Dialog_Configure_GetHandle(),IDC_RADIO_CONFIG_ENABLESOUND,DialogParams.Sound.bEnableSound);
					Dialog_Sound_EnableItems(hDlg);
					return(TRUE);

				case IDC_BUTTON_CAPTUREYM_RECORD:
					Dialog_Sound_YM_WAV_Record(hDlg);
					return(TRUE);
				case IDC_BUTTON_CAPTUREYM_STOP:
					Dialog_Sound_YM_WAV_Stop(hDlg);
					return(TRUE);

				case IDC_BUTTON_CAPTUREYM_BROWSE:
					Dialog_Sound_BrowseCapture_YM_WAV_File(hDlg);
					Dialog_Sound_EnableItems(hDlg);
					return(TRUE);
			}
			break;
	}

	return(FALSE);	// Not Processed!
}
