/*
	WinSTon

	Printer Property Page
*/

#include "..\includes\winston.h"
#include "..\includes\dialog.h"
#include "..\includes\file.h"
#include "..\includes\misc.h"

// Button IDs
static int AllPrinter_DialogItems[] = {
	IDC_RADIO_PRINTTOFILE,
	IDC_STATIC_PRINTERPORT,
	IDC_BUTTON_PRINTER_BROWSE,
	IDC_EDIT_PRINTER,
	0,	//term
};

static int PrintToFile_DialogItems[] = {
	IDC_BUTTON_PRINTER_BROWSE,
	IDC_EDIT_PRINTER,
	0,	//term
};

static int PrintToPrinter_DialogItems[] = {
	IDC_STATIC_PRINTERPORT,
	0,	//term
};

//-----------------------------------------------------------------------
/*
	Set defaults for Printer
*/
void Dialog_Printer_SetDefaults(void)
{
	// Set defaults for Printer
	ConfigureParams.Printer.bEnablePrinting = FALSE;
	ConfigureParams.Printer.bPrintToFile = FALSE;
	strcpy(ConfigureParams.Printer.szPrintToFileName,"");
}

//-----------------------------------------------------------------------
/*
	Enable item according to options states
*/
void Dialog_Printer_EnableItems(HWND hDlg)
{
	// Turn on all by default
	Dialog_EnableItems(hDlg,AllPrinter_DialogItems,TRUE);

	// Is printer enabled? If not grey out all options
	if (!Dialog_ReadButton(hDlg,IDC_RADIO_ENABLEPRINTING))
		Dialog_EnableItems(hDlg,AllPrinter_DialogItems,FALSE);
	else {
		// Is print to file enabled?
		if (!Dialog_ReadButton(hDlg,IDC_RADIO_PRINTTOFILE))
			Dialog_EnableItems(hDlg,PrintToFile_DialogItems,FALSE);
		else	
			Dialog_EnableItems(hDlg,PrintToPrinter_DialogItems,FALSE);
	}
}

//-----------------------------------------------------------------------
/*
	Write settings into dialog page
*/
void Dialog_Printer_WritePopulate(HWND hDlg)
{
	// Set items
	Dialog_SetButton(hDlg,IDC_RADIO_ENABLEPRINTING,DialogParams.Printer.bEnablePrinting);
	Dialog_SetButton(hDlg,IDC_RADIO_PRINTTOFILE,DialogParams.Printer.bPrintToFile);
	Dialog_SetText(hDlg,IDC_EDIT_PRINTER,DialogParams.Printer.szPrintToFileName);

	Dialog_Printer_EnableItems(hDlg);

	bOKDialog = TRUE;
}

//-----------------------------------------------------------------------
/*
	Read settings back from dialog page
*/
void Dialog_Printer_ReadPopulate(HWND hDlg)
{
	// Read items
	DialogParams.Printer.bEnablePrinting = Dialog_ReadButton(hDlg,IDC_RADIO_ENABLEPRINTING);
	DialogParams.Printer.bPrintToFile = Dialog_ReadButton(hDlg,IDC_RADIO_PRINTTOFILE);
	Dialog_ReadText(hDlg,IDC_EDIT_PRINTER,DialogParams.Printer.szPrintToFileName);
}

//-----------------------------------------------------------------------
/*
	Browse for printing output file (*.*)
*/
void Dialog_Printer_BrowseFile(HWND hDlg)
{
	// Browse for file and change edit box if OK
	if (File_OpenSelectDlg(hWnd,DialogParams.Printer.szPrintToFileName,FILEFILTER_ALLFILES,FALSE,TRUE))
		Dialog_SetText(hDlg,IDC_EDIT_PRINTER,DialogParams.Printer.szPrintToFileName);
}

//-----------------------------------------------------------------------
/*
	Printer Property page handler
*/
BOOL FAR PASCAL Dialog_Printer_DlgProc(HWND hDlg, UINT Message, UINT wParam, LONG lParam)
{
	switch(Message) {
		case WM_INITDIALOG:
			Dialog_Printer_WritePopulate(hDlg);
			nLastOpenPage = DIALOG_PAGE_PRINTER;
			return(TRUE);

		case WM_NOTIFY:
			switch(((NMHDR *)lParam)->code) {
				case PSN_APPLY:
					Dialog_Printer_ReadPopulate(hDlg);
					return(TRUE);
				case PSN_HELP:
					WinSTon_GoWeb("help\\options\\printer.html",FALSE);
					return(TRUE);
			}
			break;

		case WM_HELP:
			// Open help
			WinSTon_GoWeb("help\\options\\printer.html",FALSE);
			return(TRUE);

		case WM_COMMAND:
			switch(LOWORD(wParam)) {
				case IDC_RADIO_ENABLEPRINTING:
				case IDC_RADIO_PRINTTOFILE:
					Dialog_Printer_EnableItems(hDlg);
					return(TRUE);

				case IDC_BUTTON_PRINTER_BROWSE:
					Dialog_Printer_BrowseFile(hDlg);
					return(TRUE);
			}
			break;
	}

	return(FALSE);	// Not Processed!
}
