/*
	WinSTon

	Joysticks Image Property Page
*/

#include "..\includes\winston.h"
#include "..\includes\dialog.h"
#include "..\includes\joy.h"
#include "..\includes\djoy.h"

// Button IDs
static int Joysticks_DialogItems[] = {
	IDC_RADIO_USEDIRECTINPUT,
	IDC_RADIO_JOY0ENABLE,
	IDC_RADIO_JOY0CURSOR,
	IDC_RADIO_JOY0AUTO,
	IDC_RADIO_JOY1ENABLE,
	IDC_RADIO_JOY1CURSOR,
	IDC_RADIO_JOY1AUTO,
	0,	//term
};

//-----------------------------------------------------------------------
/*
	Set defaults for Joysticks
*/
void Dialog_Joysticks_SetDefaults(void)
{
	int i;

	// Set defaults for Joysticks
	ConfigureParams.Joysticks.bUseDirectInput = TRUE;
	for(i=0; i<2; i++) {
		ConfigureParams.Joysticks.Joy[i].bCursorEmulation = FALSE;
		ConfigureParams.Joysticks.Joy[i].bEnableAutoFire = FALSE;
	}
}

//-----------------------------------------------------------------------
/*
	Enable item according to options states
*/
void Dialog_Joysticks_EnableItems(HWND hDlg)
{
	// Enable all options
	Dialog_EnableItems(hDlg,Joysticks_DialogItems,TRUE);

	// Do we have DirectInput
	if (!bAllowDirectInput)
		Dialog_EnableItem(hDlg,IDC_RADIO_USEDIRECTINPUT,FALSE);
	// And cursor emulation(only allow one)
	if (Dialog_ReadButton(hDlg,IDC_RADIO_JOY0CURSOR))
		Dialog_EnableItem(hDlg,IDC_RADIO_JOY1CURSOR,FALSE);
	if (Dialog_ReadButton(hDlg,IDC_RADIO_JOY1CURSOR))
		Dialog_EnableItem(hDlg,IDC_RADIO_JOY0CURSOR,FALSE);
}

//-----------------------------------------------------------------------
/*
	Write settings into dialog page
*/
void Dialog_Joysticks_WritePopulate(HWND hDlg)
{
	// Set items
	Dialog_SetButton(hDlg,IDC_RADIO_USEDIRECTINPUT,DialogParams.Joysticks.bUseDirectInput);
	Dialog_SetButton(hDlg,IDC_RADIO_JOY0CURSOR,DialogParams.Joysticks.Joy[0].bCursorEmulation);
	Dialog_SetButton(hDlg,IDC_RADIO_JOY0AUTO,DialogParams.Joysticks.Joy[0].bEnableAutoFire);
	Dialog_SetButton(hDlg,IDC_RADIO_JOY1CURSOR,DialogParams.Joysticks.Joy[1].bCursorEmulation);
	Dialog_SetButton(hDlg,IDC_RADIO_JOY1AUTO,DialogParams.Joysticks.Joy[1].bEnableAutoFire);

	Dialog_Joysticks_EnableItems(hDlg);

	bOKDialog = TRUE;
}

//-----------------------------------------------------------------------
/*
	Read settings back from dialog page
*/
void Dialog_Joysticks_ReadPopulate(HWND hDlg)
{
	// Read items
	DialogParams.Joysticks.bUseDirectInput = Dialog_ReadButton(hDlg,IDC_RADIO_USEDIRECTINPUT);
	DialogParams.Joysticks.Joy[0].bCursorEmulation = Dialog_ReadButton(hDlg,IDC_RADIO_JOY0CURSOR);
	DialogParams.Joysticks.Joy[0].bEnableAutoFire = Dialog_ReadButton(hDlg,IDC_RADIO_JOY0AUTO);
	DialogParams.Joysticks.Joy[1].bCursorEmulation = Dialog_ReadButton(hDlg,IDC_RADIO_JOY1CURSOR);
	DialogParams.Joysticks.Joy[1].bEnableAutoFire = Dialog_ReadButton(hDlg,IDC_RADIO_JOY1AUTO);
}

//-----------------------------------------------------------------------
/*
	Joystick Property page handler
*/
BOOL FAR PASCAL Dialog_Joysticks_DlgProc(HWND hDlg, UINT Message, UINT wParam, LONG lParam)
{
	switch(Message) {
		case WM_INITDIALOG:
			Dialog_Joysticks_WritePopulate(hDlg);
			nLastOpenPage = DIALOG_PAGE_JOYSTICKS;
			return(TRUE);

		case WM_NOTIFY:
			switch(((NMHDR *)lParam)->code) {
				case PSN_APPLY:
					Dialog_Joysticks_ReadPopulate(hDlg);
					return(TRUE);
				case PSN_HELP:
					WinSTon_GoWeb("help\\options\\joysticks.html",FALSE);
					return(TRUE);
			}
			break;

		case WM_HELP:
			// Open help
			WinSTon_GoWeb("help\\options\\joysticks.html",FALSE);
			return(TRUE);

		case WM_COMMAND:
			switch(LOWORD(wParam)) {
				case IDC_RADIO_USEDIRECTINPUT:
				case IDC_RADIO_JOY0CURSOR:
				case IDC_RADIO_JOY1CURSOR:
					Dialog_Joysticks_EnableItems(hDlg);
					return(TRUE);
			}
			break;
	}

	return(FALSE);	// Not Processed!
}
