/*
	WinSTon

	Hard Disc Property Page
*/

#include "..\includes\winston.h"
#include "..\includes\dialog.h"
#include "..\includes\file.h"
#include "..\includes\misc.h"

// List of possible Drive configurations(MUST match DRIVELIST_xxxx)
#define NUM_DRIVELISTITEMSTRINGS	5
static char *pszDriveListItemStrings[] = {
	"(none)",
	"C:",
	"C:, D:",
	"C:, D:, E:",
	"C:, D:, E:, F:",
	NULL	//term
};

#define NUM_DRIVEITEMSTRINGS	4
static char *pszDriveItemStrings[] = {
	"C:",
	"D:",
	"E:",
	"F:",
	NULL	//term
};

// Button IDs
static int AllHardDisc_DialogItems[] = {
	IDC_RADIO_BOOTHARDDRIVE,
	IDC_EDIT_SELECTEDDISC,
	IDC_SPIN_SELECTEDDISC,
	IDC_BUTTON_HARDDRIVE,
	IDC_EDIT_HARDDISC,
	0,	//term
};

int nActiveDrive;										// Active drives directory(used to write details back to dialog when change)

//-----------------------------------------------------------------------
/*
	Set defaults for Hard Disc
*/
void Dialog_HardDisc_SetDefaults(void)
{
	int i;

	// Set defaults for Hard Disc
	ConfigureParams.HardDisc.nDriveList = DRIVELIST_CD;
	ConfigureParams.HardDisc.bBootFromHardDisc = FALSE;
	ConfigureParams.HardDisc.nHardDiscDir = DRIVE_D;
	for(i=0; i<MAX_HARDDRIVES; i++) {
		sprintf(ConfigureParams.HardDisc.szHardDiscDirectories[i],"%s\\Hard_Drv",szWorkingDir);
		File_CleanFileName(ConfigureParams.HardDisc.szHardDiscDirectories[i]);
	}
}

//-----------------------------------------------------------------------
/*
	Write details for selected drive
*/
void Dialog_HardDisc_Update_SelectedDriveDirectory(HWND hDlg, int nDrive)
{
	// Read off old value back into structure
	if (nActiveDrive!=-1)
		Dialog_ReadText(hDlg,IDC_EDIT_HARDDISC,DialogParams.HardDisc.szHardDiscDirectories[nActiveDrive]);

	// Show new chosen directory
	if (nDrive!=-1)
		Dialog_SetText(hDlg,IDC_EDIT_HARDDISC,DialogParams.HardDisc.szHardDiscDirectories[nDrive]);
	// Set new active drive
	nActiveDrive = nDrive;
}

//-----------------------------------------------------------------------
/*
	Return number of available drives to be selected from
*/
int Dialog_HardDisc_GetAvailableDrives(HWND hDlg)
{
	int nAvailableDrives;

	// Read available drives from dialog
	nAvailableDrives = Dialog_GetSelectedComboBoxItem(hDlg,IDC_COMBO_DRIVELIST);
	return(nAvailableDrives);
}

//-----------------------------------------------------------------------
/*
	Enable item according to options states
*/
void Dialog_HardDisc_EnableItems(HWND hDlg)
{
	// Turn on all by default
	Dialog_EnableItems(hDlg,AllHardDisc_DialogItems,TRUE);

	// Have we selected a hard-drive? If not disable all options
	if (Dialog_GetSelectedComboBoxItem(hDlg,IDC_COMBO_DRIVELIST)==DRIVELIST_NONE) {
		Dialog_EnableItems(hDlg,AllHardDisc_DialogItems,FALSE);
	}
	else {
		// Do we have just one drive to select from? Disable spin control
		if (Dialog_HardDisc_GetAvailableDrives(hDlg)<=1)
			Dialog_EnableItem(hDlg,IDC_SPIN_SELECTEDDISC,FALSE);
	}
}

//-----------------------------------------------------------------------
/*
	Limited selected drive to those available, ie if only have drives C:,D: don't show E:
*/
void Dialog_HardDisc_LimitSelectedDrive(HWND hDlg)
{
	int nAvailableDrives, nSelectedDrive;

	// Limit selected drive
	nAvailableDrives = Dialog_HardDisc_GetAvailableDrives(hDlg);
	nSelectedDrive = Dialog_GetSpinList(hDlg,IDC_SPIN_SELECTEDDISC);
	DialogParams.HardDisc.nHardDiscDir = Dialog_SetSpinList(hDlg,IDC_EDIT_SELECTEDDISC,IDC_SPIN_SELECTEDDISC,pszDriveItemStrings,nAvailableDrives,nSelectedDrive);
	// And update edit box
	Dialog_HardDisc_Update_SelectedDriveDirectory(hDlg,DialogParams.HardDisc.nHardDiscDir);//-1);
}

//-----------------------------------------------------------------------
/*
	Write settings into dialog page
*/
void Dialog_HardDisc_WritePopulate(HWND hDlg)
{
	// Set active drive directory
	nActiveDrive = -1;
	// Set items
	Dialog_SetComboBoxItems(hDlg,IDC_COMBO_DRIVELIST,pszDriveListItemStrings,DialogParams.HardDisc.nDriveList);
	Dialog_SetButton(hDlg,IDC_RADIO_BOOTHARDDRIVE,DialogParams.HardDisc.bBootFromHardDisc);
	Dialog_SetSpinList(hDlg,IDC_EDIT_SELECTEDDISC,IDC_SPIN_SELECTEDDISC,pszDriveItemStrings,NUM_DRIVEITEMSTRINGS,DialogParams.HardDisc.nHardDiscDir);
	Dialog_HardDisc_LimitSelectedDrive(hDlg);
	Dialog_HardDisc_EnableItems(hDlg);

	bOKDialog = TRUE;
}

//-----------------------------------------------------------------------
/*
	Read settings back from dialog page
*/
void Dialog_HardDisc_ReadPopulate(HWND hDlg)
{
	int i;

	// Read items
	DialogParams.HardDisc.nDriveList = Dialog_GetSelectedComboBoxItem(hDlg,IDC_COMBO_DRIVELIST);
	DialogParams.HardDisc.bBootFromHardDisc = Dialog_ReadButton(hDlg,IDC_RADIO_BOOTHARDDRIVE);
	DialogParams.HardDisc.nHardDiscDir = Dialog_GetSpinList(hDlg,IDC_SPIN_SELECTEDDISC);
	Dialog_HardDisc_Update_SelectedDriveDirectory(hDlg,-1);
	for(i=0; i<MAX_HARDDRIVES; i++)
		File_CleanFileName(DialogParams.HardDisc.szHardDiscDirectories[i]);
}

//-----------------------------------------------------------------------
/*
	Browse for Hard Disc directory
*/
void Dialog_HardDisc_BrowseDirectory(HWND hDlg)
{
	// Browse for directory and change edit box if OK
	if (File_OpenBrowseDlg(hWnd,DialogParams.HardDisc.szHardDiscDirectories[ Dialog_GetSpinList(hDlg,IDC_SPIN_SELECTEDDISC) ],FALSE,FALSE))
		Dialog_SetText(hDlg,IDC_EDIT_HARDDISC,DialogParams.HardDisc.szHardDiscDirectories[ Dialog_GetSpinList(hDlg,IDC_SPIN_SELECTEDDISC) ]);
}

//-----------------------------------------------------------------------
/*
	Hard Disc Property page handler
*/
BOOL FAR PASCAL Dialog_HardDisc_DlgProc(HWND hDlg, UINT Message, UINT wParam, LONG lParam)
{
	NMUPDOWN *pUpDown;
	int Offset, nAvailableDrives;

	switch(Message) {
		case WM_INITDIALOG:
			Dialog_HardDisc_WritePopulate(hDlg);
			nLastOpenPage = DIALOG_PAGE_HARDDISC;
			return(TRUE);

		case WM_NOTIFY:
			switch(wParam) {
				case IDC_SPIN_SELECTEDDISC:
					pUpDown = (NMUPDOWN *)lParam;
					nAvailableDrives = Dialog_HardDisc_GetAvailableDrives(hDlg);
					Offset = Misc_LimitInt(pUpDown->iPos + pUpDown->iDelta, 0,nAvailableDrives-1);
					Dialog_UpdateSpinList(hDlg,IDC_EDIT_SELECTEDDISC,pszDriveItemStrings,nAvailableDrives,Offset);
					Dialog_HardDisc_Update_SelectedDriveDirectory(hDlg,Offset);
					return(TRUE);
			}

			switch(((NMHDR *)lParam)->code) {
				case PSN_APPLY:
					Dialog_HardDisc_ReadPopulate(hDlg);
					return(TRUE);
				case PSN_HELP:
					WinSTon_GoWeb("help\\options\\harddiscs.html",FALSE);
					return(TRUE);
			}
			break;

		case WM_HELP:
			// Open help
			WinSTon_GoWeb("help\\options\\harddiscs.html",FALSE);
			return(TRUE);

		case WM_COMMAND:
			switch(LOWORD(wParam)) {
				case IDC_BUTTON_HARDDRIVE:
					Dialog_HardDisc_BrowseDirectory(hDlg);
					return(TRUE);
				case IDC_COMBO_DRIVELIST:
					Dialog_HardDisc_LimitSelectedDrive(hDlg);
					Dialog_HardDisc_EnableItems(hDlg);
					return(TRUE);
			}
			break;
	}

	return(FALSE);	// Not Processed!
}
