/*
	WinSTon

	Disc Image Property Page
*/

#include "..\includes\winston.h"
#include "..\includes\dialog.h"
#include "..\includes\file.h"
#include "..\includes\floppy.h"
#include "..\includes\createblankimage.h"

// Button IDs
static int DiscImage_DialogItems[] = {
	IDC_RADIO_AUTODISCB,
	IDC_BUTTON_DISCIMAGE,
	IDC_EDIT_FLOPPYDISC,
	0,	//term
};

//-----------------------------------------------------------------------
/*
	Set defaults for Disc Image
*/
void Dialog_DiscImage_SetDefaults(void)
{
	// Set defaults for Disc Image
	ConfigureParams.DiscImage.bAutoInsertDiscB = TRUE;
	sprintf(ConfigureParams.DiscImage.szDiscImageDirectory,"%s\\Discs",szWorkingDir);
	File_AddSlashToEndFileName(ConfigureParams.DiscImage.szDiscImageDirectory);
}

//-----------------------------------------------------------------------
/*
	Enable item according to options states
*/
void Dialog_DiscImage_EnableItems(HWND hDlg)
{	
	// Turn on all by default
	Dialog_EnableItems(hDlg,DiscImage_DialogItems,TRUE);

	// Is PC floppy drive enabled? If is grey out
	if (Dialog_ReadButton(hDlg,IDC_RADIO_USEPCFLOPPY))
		Dialog_EnableItems(hDlg,DiscImage_DialogItems,FALSE);
}

//-----------------------------------------------------------------------
/*
	Write settings into dialog page
*/
void Dialog_DiscImage_WritePopulate(HWND hDlg)
{
	// Set items
	Dialog_SetButton(hDlg,IDC_RADIO_AUTODISCB,DialogParams.DiscImage.bAutoInsertDiscB);
	Dialog_SetText(hDlg,IDC_EDIT_FLOPPYDISC,DialogParams.DiscImage.szDiscImageDirectory);

	Dialog_DiscImage_EnableItems(hDlg);

	bOKDialog = TRUE;
}

//-----------------------------------------------------------------------
/*
	Read settings back from dialog page
*/
void Dialog_DiscImage_ReadPopulate(HWND hDlg)
{
	// Read items
	DialogParams.DiscImage.bAutoInsertDiscB = Dialog_ReadButton(hDlg,IDC_RADIO_AUTODISCB);
	Dialog_ReadText(hDlg,IDC_EDIT_FLOPPYDISC,DialogParams.DiscImage.szDiscImageDirectory);
	File_AddSlashToEndFileName(DialogParams.DiscImage.szDiscImageDirectory);
}

//-----------------------------------------------------------------------
/*
	Browse for disc Image directory
*/
void Dialog_DiscImage_BrowseDirectory(HWND hDlg)
{
	// Browse for directory and change edit box if OK
	if (File_OpenBrowseDlg(hWnd,DialogParams.DiscImage.szDiscImageDirectory,FALSE,FALSE)) {
		File_AddSlashToEndFileName(DialogParams.DiscImage.szDiscImageDirectory);
		Dialog_SetText(hDlg,IDC_EDIT_FLOPPYDISC,DialogParams.DiscImage.szDiscImageDirectory);
		strcpy(ConfigureParams.DiscImage.szDiscImageDirectory,DialogParams.DiscImage.szDiscImageDirectory);
	}
}

//-----------------------------------------------------------------------
/*
	Create blank disc image and insert into drive
*/
void Dialog_DiscImage_CreateBlankImage(HWND hDlg, int Drive)
{
	char szString[MAX_FILENAME_LENGTH];

	// Ask user for filename for floppy drive A
	strcpy(szString,EmulationDrives[Drive].szFileName);
	if (File_OpenDlg_NoExtraButtons(hDlg,szString)) {
		// Show dialog for creating a blank disc
		CreateBlankImage_DoDialog(hDlg,Drive,szString);
	}
}

//-----------------------------------------------------------------------
/*
	Disc Image Property page handler
*/
BOOL FAR PASCAL Dialog_DiscImage_DlgProc(HWND hDlg, UINT Message, UINT wParam, LONG lParam)
{
	switch(Message) {
		case WM_INITDIALOG:
			Dialog_DiscImage_WritePopulate(hDlg);
			nLastOpenPage = DIALOG_PAGE_DISCIMAGE;
			return(TRUE);

		case WM_NOTIFY:
			switch(((NMHDR *)lParam)->code) {
				case PSN_APPLY:
					Dialog_DiscImage_ReadPopulate(hDlg);
					return(TRUE);
				case PSN_HELP:
					WinSTon_GoWeb("help\\options\\discimages.html",FALSE);
					return(TRUE);
			}
			break;

		case WM_HELP:
			// Open help
			WinSTon_GoWeb("help\\options\\discimages.html",FALSE);
			return(TRUE);

		case WM_COMMAND:
			switch(LOWORD(wParam)) {
				case IDC_RADIO_USEPCFLOPPY:
					Dialog_DiscImage_EnableItems(hDlg);
					return(TRUE);

				case IDC_BUTTON_CREATEBLANKIMAGE:
					Dialog_DiscImage_CreateBlankImage(hDlg,0);
					return(TRUE);

				case IDC_BUTTON_DISCIMAGE:
					Dialog_DiscImage_BrowseDirectory(hDlg);
					return(TRUE);
			}
			break;
	}

	return(FALSE);	// Not Processed!
}
