/*
	WinSTon

	IKBD Tab Control
*/

#include "..\includes\winston.h"
#include "..\includes\debug.h"
#include "..\includes\debugger.h"
#include "..\includes\debuggertab.h"
#include "..\includes\decode.h"
#include "..\includes\dialog.h"
#include "..\includes\ikbd.h"
#include "..\includes\stmemory.h"

#ifdef USE_DEBUGGER

#define LISTVIEW_LINES_IKBD		32						// Store up to 32 command lines in view
#define LINES_IN_IKBD_LISTVIEW	8						// This many visible at one time

int IKBDListView_Tabs[] = { 0 };
char pszIKBDListViewStrings[LISTVIEW_LINES_IKBD][256];
int IKBDAddLine=0,IKBDAddHead=0;

//-----------------------------------------------------------------------
/*
	Init IKBD Tab Control
*/
void Debugger_TabIKBD_Init(HWND hWnd)
{
	HWND hItem;

	// Set to select full-row
	hItem = GetDlgItem(DebughWnd,IDC_TABIKBD_LISTVIEW);
	ListView_SetExtendedListViewStyle(hItem,LVS_EX_FULLROWSELECT|LVS_EX_SUBITEMIMAGES);

	// Add Columns
	Dialog_AddListViewColumn(DebughWnd,IDC_TABIKBD_LISTVIEW,0,"Command",450);

	ListView_SetItemCountEx(hItem,LISTVIEW_LINES_IKBD,LVSICF_NOSCROLL);

	// Clear circular items
	memset(pszIKBDListViewStrings,0x0,256*LISTVIEW_LINES_IKBD);
}

//-----------------------------------------------------------------------
/*
	Show IKBD Tab Control
*/
void Debugger_TabIKBD_ShowPage(HWND hWnd,BOOL bShow)
{
	// NOTE : Control IDs must be consecutive in resource editor! Ie hand-edited
	Dialog_ShowItemRange(hWnd,IDC_TABIKBD_EDIT_MOUSEMODE,IDC_TABIKBD_LISTVIEW,bShow ? SW_SHOW:SW_HIDE);	
}

//-----------------------------------------------------------------------
/*
	Update IKBD Tab Control
*/
void Debugger_TabIKBD_UpdateDisplay(HWND hWnd)
{
	HWND hItem;
	int Line;
	char szString[256];

	// Mouse/Joystick modes
	switch(KeyboardProcessor.MouseMode) {
		case AUTOMODE_OFF:
			strcpy(szString,"Off");
			break;
		case AUTOMODE_MOUSEREL:
			strcpy(szString,"Relative");
			break;
		case AUTOMODE_MOUSEABS:
			strcpy(szString,"Absolute");
			break;
		case AUTOMODE_MOUSECURSOR:
			strcpy(szString,"Cursor");
			break;
	}
	Dialog_SetText(hWnd,IDC_TABIKBD_EDIT_MOUSEMODE,szString);

	switch(KeyboardProcessor.JoystickMode) {
		case AUTOMODE_OFF:
			strcpy(szString,"Off");
			break;
		case AUTOMODE_JOYSTICK:
			strcpy(szString,"On");
			break;
	}
	Dialog_SetText(hWnd,IDC_TABIKBD_EDIT_JOYSTICKMODE,szString);
	
	// YAxis, MouseAction, Abs, AbsMax
	sprintf(szString,"%d(%s)",KeyboardProcessor.Mouse.YAxis,(KeyboardProcessor.Mouse.YAxis==1) ? "Up":"Down");
	Dialog_SetText(hWnd,IDC_TABIKBD_EDIT_YAXIS,szString);
	sprintf(szString,"$%2.2X",KeyboardProcessor.Mouse.Action);
	Dialog_SetText(hWnd,IDC_TABIKBD_EDIT_MOUSEACTION,szString);
	sprintf(szString,"%d,%d",KeyboardProcessor.Abs.X,KeyboardProcessor.Abs.Y);
	Dialog_SetText(hWnd,IDC_TABIKBD_EDIT_MSEABS,szString);
	sprintf(szString,"%d,%d",KeyboardProcessor.Abs.MaxX,KeyboardProcessor.Abs.MaxY);
	Dialog_SetText(hWnd,IDC_TABIKBD_EDIT_MSEABSMAX,szString);

	// Update all items in list view
	hItem = GetDlgItem(DebughWnd,IDC_TABIKBD_LISTVIEW);
	Line = GetScrollPos(hItem,SB_VERT);
	ListView_RedrawItems(hItem,Line,Line+LINES_IN_IKBD_LISTVIEW);
	UpdateWindow(hItem);
}

//-----------------------------------------------------------------------
/*
	Draw Memory Tab Control
*/
void Debugger_TabIKBD_Draw(DRAWITEMSTRUCT *pDrawItem)
{
/*	char szString[256];
	char *pszStrings[1] = { szString };
	int *pszTabs[1] = { IKBDListView_Tabs };
	int Line;
	int i;

	// Draw each line in list view
	Line = GetScrollPos(pDrawItem->hwndItem,SB_VERT) + IKBDHeadLine;
	for(i=0; i<LINES_IN_IKBD_LISTVIEW; i++) {
		// Draw text
		strcpy(szString,pszIKBDListViewStrings[Line&(LISTVIEW_LINES_IKBD-1)]);
		Debugger_Tab_DrawListViewStrings(pDrawItem,pszStrings,pszTabs,1,i);
		Line++;
	}
*/
}

//-----------------------------------------------------------------------
/*
	Add line into list view
*/
void Debugger_TabIKBD_AddListViewItem(char *format, ...)
{
/*	char szBuffer[1024];
	va_list argptr;

	va_start(argptr, format);
	vsprintf(szBuffer, format, argptr);
	va_end(argptr);

	if (IKBDAddLine==(LISTVIEW_LINES_IKBD-1)) {		argggghhhh!!!!!!!!!!
		IKBDAddLine--;
		memcpy(pszIKBDListViewStrings[0],pszIKBDListViewStrings[1]);
	}
	strcpy(pszIKBDListViewStrings[IKBDAddLine],szBuffer);
	IKBDAddLine++;
*/}

#endif	//USE_DEBUGGER
