/*
	WinSTon

	FDC Tab Control
*/

#include "..\includes\winston.h"
#include "..\includes\debug.h"
#include "..\includes\debugger.h"
#include "..\includes\debuggertab.h"
#include "..\includes\decode.h"
#include "..\includes\dialog.h"
#include "..\includes\mfp.h"
#include "..\includes\stmemory.h"

#ifdef USE_DEBUGGER

//-----------------------------------------------------------------------
/*
	Init FDC Tab Control
*/
void Debugger_TabFDC_Init(HWND hWnd)
{
	HWND hItem;

	// Set to select full-row
	hItem = GetDlgItem(DebughWnd,IDC_TABFDC_LISTVIEW);
	ListView_SetExtendedListViewStyle(hItem,LVS_EX_FULLROWSELECT|LVS_EX_SUBITEMIMAGES);

	// Add Columns
	Dialog_AddListViewColumn(DebughWnd,IDC_TABFDC_LISTVIEW,0,"Commands",300);
}

//-----------------------------------------------------------------------
/*
	Show FDC Tab Control
*/
void Debugger_TabFDC_ShowPage(HWND hWnd,BOOL bShow)
{
	// NOTE : Control IDs must be consecutive in resource editor! Ie hand-edited
	Dialog_ShowItemRange(hWnd,IDC_TABFDC_TEXT_CONTROLSTATUS_R,IDC_TABFDC_LISTVIEW,bShow ? SW_SHOW:SW_HIDE);	
}

//-----------------------------------------------------------------------
/*
	Update FDC Tab Control
*/
void Debugger_TabFDC_UpdateDisplay(HWND hWnd)
{
}

#endif	//USE_DEBUGGER
