;	WinSTon

;	SUBI #<data>,Dn
;	SUBI #<data>,<ea>

;	XNZVC
;	*****

PUBLIC _subi_imm_dn_byte
PUBLIC _subi_imm_dn_word
PUBLIC _subi_imm_dn_long
PUBLIC _subi_imm_ea_byte
PUBLIC _subi_imm_ea_word
PUBLIC _subi_imm_ea_long

;-----------------------------------------------------------------------
;SUBI.B #<data>,Dn
_subi_imm_dn_byte PROC NEAR
	mov		bl,IMM_BYTE[esi]						;Read immediate
	add		esi,SIZE_WORD							;Increase Program Counter
	mov		edx,DECODE_1[ecx]						;<ea>
	sub		[edx],bl								;Dest Dn
	SET_NZV_CX_SAME
_subi_imm_dn_byte ENDP

;SUBI.W #<data>,Dn
_subi_imm_dn_word PROC NEAR
	mov		bx,IMM_WORD[esi]						;Read immediate
	add		esi,SIZE_WORD							;Increase Program Counter
	SWAP_ENDIAN_WORD_BX
	mov		edx,DECODE_1[ecx]						;<ea>
	sub		[edx],bx								;Dest Dn
	SET_NZV_CX_SAME
_subi_imm_dn_word ENDP

;SUBI.L #<data>,Dn
_subi_imm_dn_long PROC NEAR
	mov		ebx,IMM_LONG[esi]						;Read immediate
	add		esi,SIZE_LONG							;Increase Program Counter
	SWAP_ENDIAN_LONG_EBX
	mov		edx,DECODE_1[ecx]						;<ea>
	sub		[edx],ebx								;Dest Dn
	SET_NZV_CX_SAME
_subi_imm_dn_long ENDP

;-----------------------------------------------------------------------
;SUBI.B #<data>,<ea>
_subi_imm_ea_byte PROC NEAR
	mov		dl,IMM_BYTE[esi]						;Read immediate
	add		esi,SIZE_WORD							;Increase Program Counter
	EFFADDR_READ									;Read <ea>
	sub		bl,dl
	WRITE_BYTE_NZV_CX_SAME
_subi_imm_ea_byte ENDP

;SUBI.W #<data>,<ea>
_subi_imm_ea_word PROC NEAR
	mov		dx,IMM_WORD[esi]						;Read immediate
	add		esi,SIZE_WORD							;Increase Program Counter
	SWAP_ENDIAN_WORD_DX
	EFFADDR_READ									;Read <ea>
	sub		bx,dx
	WRITE_WORD_NZV_CX_SAME
_subi_imm_ea_word ENDP

;SUBI.L #<data>,<ea>
_subi_imm_ea_long PROC NEAR
	mov		edx,IMM_LONG[esi]						;Read immediate
	add		esi,SIZE_LONG							;Increase Program Counter
	SWAP_ENDIAN_LONG_EDX
	EFFADDR_READ									;Read <ea>
	sub		ebx,edx
	WRITE_LONG_NZV_CX_SAME
_subi_imm_ea_long ENDP
