;	WinSTon

;	ROXL Dx,Dy
;	ROXL #<data>,Dy
;	ROXL <ea>

;	XNZVC
;	***0*

PUBLIC _roxl_dn_dn_byte
PUBLIC _roxl_dn_dn_word
PUBLIC _roxl_dn_dn_long
PUBLIC _roxl_imm_dn_byte
PUBLIC _roxl_imm_dn_word
PUBLIC _roxl_imm_dn_long
PUBLIC _roxl_ea_word

;-----------------------------------------------------------------------
;ROXL.B Dx,Dy
_roxl_dn_dn_byte PROC NEAR
	mov		ebx,DECODE_1[ecx]						;Dx
	mov		edx,DECODE_2[ecx]						;Dy(can corrupt 'ecx')
	mov		cl,BYTE PTR [ebx]
	and		ecx,63									;Modulus 64
	je		zero_rox_byte							;Check shift count 0
	ADD_SHIFT_CYCLES_BYTEWORD	ecx					;NOTE corrupts 'ebx'

	test	eax,EMU_X								;Is X bit set?
	je		no_auxcarry
	xor		eax,eax									;Clear XNZVC
	stc												;Set carry
	jmp		got_auxcarry
no_auxcarry:
	xor		eax,eax									;Clear XNZVC
got_auxcarry:

	mov		bl,BYTE PTR [edx]						;And shift
shift_loop:
	rcl		bl,1
	loop	shift_loop

	mov		BYTE PTR [edx],bl
	jnc		no_carry
	or		ax,EMU_C+EMU_X
no_carry:
	or		bl,bl									;Test NZ value
	SET_NZ
_roxl_dn_dn_byte ENDP

;ROXL.W Dx,Dy
_roxl_dn_dn_word PROC NEAR
	mov		ebx,DECODE_1[ecx]						;Dx
	mov		edx,DECODE_2[ecx]						;Dy(can corrupt 'ecx')
	mov		cl,BYTE PTR [ebx]
	and		ecx,63									;Modulus 64
	je		zero_rox_word							;Check shift count 0
	ADD_SHIFT_CYCLES_BYTEWORD	ecx					;NOTE corrupts 'ebx'

	test	eax,EMU_X								;Is X bit set?
	je		no_auxcarry
	xor		eax,eax									;Clear XNZVC
	stc												;Set carry
	jmp		got_auxcarry
no_auxcarry:
	xor		eax,eax									;Clear XNZVC
got_auxcarry:

	mov		bx,WORD PTR [edx]						;And shift
shift_loop:
	rcl		bx,1
	loop	shift_loop

	mov		WORD PTR [edx],bx
	jnc		no_carry
	or		ax,EMU_C+EMU_X
no_carry:
	or		bx,bx									;Test NZ value
	SET_NZ
_roxl_dn_dn_word ENDP

;ROXL.L Dx,Dy
_roxl_dn_dn_long PROC NEAR
	mov		ebx,DECODE_1[ecx]						;Dx
	mov		edx,DECODE_2[ecx]						;Dy(can corrupt 'ecx')
	mov		cl,BYTE PTR [ebx]
	and		ecx,63									;Modulus 64
	je		zero_rox_long							;Check shift count 0
	ADD_SHIFT_CYCLES_LONG	ecx						;NOTE corrupts 'ebx'

	test	eax,EMU_X								;Is X bit set?
	je		no_auxcarry
	xor		eax,eax									;Clear XNZVC
	stc												;Set carry
	jmp		got_auxcarry
no_auxcarry:
	xor		eax,eax									;Clear XNZVC
got_auxcarry:

	mov		ebx,DWORD PTR [edx]						;And shift
shift_loop:
	rcl		ebx,1
	loop	shift_loop

	mov		DWORD PTR [edx],ebx
	jnc		no_carry
	or		ax,EMU_C+EMU_X
no_carry:
	or		ebx,ebx									;Test NZ value
	SET_NZ
_roxl_dn_dn_long ENDP

;-----------------------------------------------------------------------
;ROXL.B #<data>,Dy
_roxl_imm_dn_byte PROC NEAR
	mov		edx,DECODE_1[ecx]						;DReg
	mov		ecx,DECODE_2[ecx]						;Count		
	ADD_SHIFT_CYCLES_BYTEWORD	ecx					;NOTE corrupts 'ebx'

	test	eax,EMU_X								;Is X bit set?
	je		no_auxcarry
	xor		eax,eax									;Clear XNZVC
	stc												;Set carry
	jmp		got_auxcarry
no_auxcarry:
	xor		eax,eax									;Clear XNZVC
got_auxcarry:

	mov		bl,BYTE PTR [edx]						;And shift
shift_loop:
	rcl		bl,1
	loop	shift_loop

	mov		BYTE PTR [edx],bl
	jnc		no_carry
	or		ax,EMU_C+EMU_X
no_carry:
	or		bl,bl									;Test NZ value
	SET_NZ
_roxl_imm_dn_byte ENDP

;ROXL.W #<data>,Dy
_roxl_imm_dn_word PROC NEAR
	mov		edx,DECODE_1[ecx]						;DReg
	mov		ecx,DECODE_2[ecx]						;Count		
	ADD_SHIFT_CYCLES_BYTEWORD	ecx					;NOTE corrupts 'ebx'

	test	eax,EMU_X								;Is X bit set?
	je		no_auxcarry
	xor		eax,eax									;Clear XNZVC
	stc												;Set carry
	jmp		got_auxcarry
no_auxcarry:
	xor		eax,eax									;Clear XNZVC
got_auxcarry:

	mov		bx,WORD PTR [edx]						;And shift
shift_loop:
	rcl		bx,1
	loop	shift_loop

	mov		WORD PTR [edx],bx
	jnc		no_carry
	or		ax,EMU_C+EMU_X
no_carry:
	or		bx,bx									;Test NZ value
	SET_NZ
_roxl_imm_dn_word ENDP

;ROXL.L #<data>,Dy
_roxl_imm_dn_long PROC NEAR
	mov		edx,DECODE_1[ecx]						;DReg
	mov		ecx,DECODE_2[ecx]						;Count		
	ADD_SHIFT_CYCLES_LONG	ecx						;NOTE corrupts 'ebx'

	test	eax,EMU_X								;Is X bit set?
	je		no_auxcarry
	xor		eax,eax									;Clear XNZVC
	stc												;Set carry
	jmp		got_auxcarry
no_auxcarry:
	xor		eax,eax									;Clear XNZVC
got_auxcarry:

	mov		ebx,DWORD PTR [edx]						;And shift
shift_loop:
	rcl		ebx,1
	loop	shift_loop

	mov		DWORD PTR [edx],ebx
	jnc		no_carry
	or		ax,EMU_C+EMU_X
no_carry:
	or		ebx,ebx									;Test NZ value
	SET_NZ
_roxl_imm_dn_long ENDP

;-----------------------------------------------------------------------
;ROXL.W <ea>
_roxl_ea_word PROC NEAR
	EFFADDR_READ									;Read <ea>

	test	eax,EMU_X								;Is X bit set?
	je		no_auxcarry
	xor		eax,eax									;Clear XNZVC
	stc												;Set carry
	jmp		got_auxcarry
no_auxcarry:
	xor		eax,eax									;Clear XNZVC
got_auxcarry:
			
	rcl		bx,1									;And shift

	jnc		no_carry
	or		ax,EMU_C+EMU_X
no_carry:
	or		bx,bx									;Test NZ value
	WRITE_WORD_NZ
_roxl_ea_word ENDP
