;	WinSTon

;	ORI #<data>,Dn
;	ORI #<data>,<ea>
;	ORI #<data>,ccr
;	ORI #<data>,sr

;	XNZVC
;	-**00

PUBLIC _ori_imm_dn_byte
PUBLIC _ori_imm_dn_word
PUBLIC _ori_imm_dn_long
PUBLIC _ori_imm_ea_byte
PUBLIC _ori_imm_ea_word
PUBLIC _ori_imm_ea_long
PUBLIC _ori_imm_ccr_byte
PUBLIC _ori_imm_sr_word

;-----------------------------------------------------------------------
;ORI.B #<data>,Dn
_ori_imm_dn_byte PROC NEAR
	mov		bl,IMM_BYTE[esi]						;Immediate data
	add		esi,SIZE_WORD							;Increase program counter
	mov		edx,DECODE_1[ecx]						;<ea>
	xor		al,al									;Clear NZVC(ignore X)
	or		[edx],bl								;Dest Dn
	SET_NZ
_ori_imm_dn_byte ENDP

;ORI.W #<data>,Dn
_ori_imm_dn_word PROC NEAR
	mov		bx,IMM_WORD[esi]						;Immediate data (wrong endian)
	add		esi,SIZE_WORD							;Increase program counter
	SWAP_ENDIAN_WORD_BX
	mov		edx,DECODE_1[ecx]						;<ea>
	xor		al,al									;Clear NZVC(ignore X)
	or		[edx],bx								;Dest Dn
	SET_NZ
_ori_imm_dn_word ENDP

;ORI.L #<data>,Dn
_ori_imm_dn_long PROC NEAR
	mov		ebx,IMM_LONG[esi]						;Immediate data (wrong endian)
	add		esi,SIZE_LONG							;Increase program counter
	SWAP_ENDIAN_LONG_EBX
	mov		edx,DECODE_1[ecx]						;<ea>
	xor		al,al									;Clear NZVC(ignore X)
	or		[edx],ebx								;Dest Dn
	SET_NZ
_ori_imm_dn_long ENDP

;-----------------------------------------------------------------------
;ORI.B #<data>,<ea>
_ori_imm_ea_byte PROC NEAR
	mov		dl,IMM_BYTE[esi]						;Immediate data (wrong endian)
	add		esi,SIZE_WORD							;Increase program counter
	EFFADDR_READ									;Read <ea>
	xor		al,al									;Clear NZVC(ignore X)
	or		bl,dl
	WRITE_BYTE_NZ
_ori_imm_ea_byte ENDP

;ORI.W #<data>,<ea>
_ori_imm_ea_word PROC NEAR
	mov		dx,IMM_WORD[esi]						;Immediate data (wrong endian)
	add		esi,SIZE_WORD							;Increase program counter
	SWAP_ENDIAN_WORD_DX
	EFFADDR_READ									;Read <ea>
	xor		al,al									;Clear NZVC(ignore X)
	or		bx,dx
	WRITE_WORD_NZ
_ori_imm_ea_word ENDP

;ORI.L #<data>,<ea>
_ori_imm_ea_long PROC NEAR
	mov		edx,IMM_LONG[esi]						;Immediate data (wrong endian)
	add		esi,SIZE_LONG							;Increase program counter
	SWAP_ENDIAN_LONG_EDX
	EFFADDR_READ									;Read <ea>
	xor		al,al									;Clear NZVC(ignore X)
	or		ebx,edx
	WRITE_LONG_NZ
_ori_imm_ea_long ENDP

;-----------------------------------------------------------------------
;ORI.B #<data>,ccr
_ori_imm_ccr_byte PROC NEAR
	mov		bl,IMM_BYTE[esi]						;Immediate data
	add		esi,SIZE_WORD							;Increase program counter
	shl		ebx,4									;Convert to emulation format
	or		eax,ebx									;Or to CCR
	FRET
_ori_imm_ccr_byte ENDP

;-----------------------------------------------------------------------
;ORI.W #<data>,sr
_ori_imm_sr_word PROC NEAR
	mov		bx,IMM_WORD[esi]						;Immediate data (wrong endian)
	add		esi,SIZE_WORD							;Increase program counter
	SWAP_ENDIAN_WORD_BX
	COMBINE_SR_TO_AX								;Get 'SR' into 'ax', corrupts 'ecx'
	or		eax,ebx									;Or to SR
	call	asm_check_usersuper_swap				;Write 'eax' to SR, swap modes and return ccodes in 'eax'
	FRET
_ori_imm_sr_word ENDP
