;	WinSTon

;	NEGX Dn
;	NEGX <ea>

;	XNZVC
;	*****

PUBLIC _negx_dn_byte
PUBLIC _negx_dn_word
PUBLIC _negx_dn_long
PUBLIC _negx_ea_byte
PUBLIC _negx_ea_word
PUBLIC _negx_ea_long

;-----------------------------------------------------------------------
;NEGX.B Dn
_negx_dn_byte PROC NEAR
	xor		bl,bl
	mov		edx,DECODE_1[ecx]						;DReg
	test	eax,EMU_X								;Is X bit set? Clears PC's carry
	je		no_carry
	stc												;Set carry
no_carry:
	sbb		bl,[edx]								;0-Dn
	mov		[edx],bl
	SET_NUZV_CX_SAME
_negx_dn_byte ENDP

;NEGX.W Dn
_negx_dn_word PROC NEAR
	xor		bx,bx
	mov		edx,DECODE_1[ecx]						;DReg
	test	eax,EMU_X								;Is X bit set? Clears PC's carry
	je		no_carry
	stc												;Set carry
no_carry:
	sbb		bx,[edx]								;0-Dn
	mov		[edx],bx
	SET_NUZV_CX_SAME
_negx_dn_word ENDP

;NEGX.L Dn
_negx_dn_long PROC NEAR
	xor		ebx,ebx
	mov		edx,DECODE_1[ecx]						;DReg
	test	eax,EMU_X								;Is X bit set? Clears PC's carry
	je		no_carry
	stc												;Set carry
no_carry:
	sbb		ebx,[edx]								;0-Dn
	mov		[edx],ebx
	SET_NUZV_CX_SAME
_negx_dn_long ENDP

;-----------------------------------------------------------------------
;NEGX.B <ea>
_negx_ea_byte PROC NEAR
	EFFADDR_READ									;Read <ea>
	xor		dl,dl
	test	eax,EMU_X								;Is X bit set? Clears PC's carry
	je		no_carry
	stc												;Set carry
no_carry:
	sbb		dl,bl									;0-<ea>
	mov		bl,dl									;Store
	WRITE_BYTE_NUZV_CX_SAME
_negx_ea_byte ENDP

;NEGX.W <ea>
_negx_ea_word PROC NEAR
	EFFADDR_READ									;Read <ea>
	xor		dx,dx
	test	eax,EMU_X								;Is X bit set? Clears PC's carry
	je		no_carry
	stc												;Set carry
no_carry:
	sbb		dx,bx									;0-<ea>
	mov		bx,dx									;Store
	WRITE_WORD_NUZV_CX_SAME
_negx_ea_word ENDP

;NEGX.L <ea>
_negx_ea_long PROC NEAR
	EFFADDR_READ									;Read <ea>
	xor		edx,edx
	test	eax,EMU_X								;Is X bit set? Clears PC's carry
	je		no_carry
	stc												;Set carry
no_carry:
	sbb		edx,ebx									;0-<ea>
	mov		ebx,edx									;Store
	WRITE_LONG_NUZV_CX_SAME
_negx_ea_long ENDP
