;	WinSTon

;	NBCD Dn
;	NBCD <ea>

;	XNZVC
;	-----

PUBLIC _nbcd_dn_byte
PUBLIC _nbcd_ea_byte

;-----------------------------------------------------------------------
;NBCD Dn
_nbcd_dn_byte PROC NEAR
	mov		ecx,DECODE_1[ecx]						;DReg
	mov		bl,BYTE PTR [ecx]
	call	BCDtoDEC								
	mov		edx,ebx									;dl = DReg as decimal
	xor		ebx,ebx									;bl = 0
	
	test	eax,EMU_X
	je		no_carry
	sub		ebx,edx
	dec		ebx										;0-(DReg+1)
	jmp		result
no_carry:
	sub		ebx,edx									;0-DReg
result:

	and		eax,NOT (EMU_X+EMU_C)
	cmp		ebx,0
	jge		no_overflow
	add		ebx,100
	or		eax,EMU_C+EMU_X
no_overflow:
	cmp		ebx,0
	je		not_zero
	and		eax,EMU_CLEAR_Z
not_zero:

	call	DECtoBCD								;bl = Reg as binary coded decimal
	mov		BYTE PTR [ecx],bl

	FRET
_nbcd_dn_byte ENDP

;NBCD <ea>
_nbcd_ea_byte PROC NEAR
	EFFADDR_READ									;Read <ea>
	call	BCDtoDEC
	mov		edx,ebx									;dl = RegX as decimal
	xor		ebx,ebx									;bl = 0

	test	eax,EMU_X
	je		no_carry
	sub		ebx,edx
	dec		ebx										;0-(<ea>+1)
	jmp		result
no_carry:
	sub		ebx,edx									;0-<ea>
result:

	and		eax,NOT (EMU_X+EMU_C)
	cmp		ebx,0
	jge		no_overflow
	add		ebx,100
	or		eax,EMU_C+EMU_X
no_overflow:
	cmp		ebx,0
	je		not_zero
	and		eax,EMU_CLEAR_Z
not_zero:

	call	DECtoBCD								;bl = Reg as binary coded decimal
	INTERCEPT_CHECK_ADDR_WRITEBYTE					;Write 'bl' to 'ebp', corrupts 'ecx'
	FRET
_nbcd_ea_byte ENDP
