;	WinSTon

;	LSR Dx,Dy
;	LSR #<data>,Dy
;	LSR <ea>

;	XNZVC
;	***0*

PUBLIC _lsr_dn_dn_byte
PUBLIC _lsr_dn_dn_word
PUBLIC _lsr_dn_dn_long
PUBLIC _lsr_imm_dn_byte
PUBLIC _lsr_imm_dn_word
PUBLIC _lsr_imm_dn_long
PUBLIC _lsr_ea_word

;-----------------------------------------------------------------------
;LSR.B Dx,Dy
_lsr_dn_dn_byte PROC NEAR
	mov		ebx,DECODE_1[ecx]						;Dx
	mov		edx,DECODE_2[ecx]						;Dy(can corrupt 'ecx')
	mov		cl,BYTE PTR [ebx]
	and		ecx,63									;Modulus 64
	je		zero_shift_byte							;Check shift count 0
	ADD_SHIFT_CYCLES_BYTEWORD	ecx					;NOTE corrupts 'ebx'

	mov		bl,BYTE PTR [edx]						;And shift
shift_loop:
	shr		bl,1
	loop	shift_loop

	mov		BYTE PTR [edx],bl
	SET_NZ_CX_SAME_CLEAR_V
_lsr_dn_dn_byte ENDP

;LSR.W Dx,Dy
_lsr_dn_dn_word PROC NEAR
	mov		ebx,DECODE_1[ecx]						;Dx
	mov		edx,DECODE_2[ecx]						;Dy(can corrupt 'ecx')
	mov		cl,BYTE PTR [ebx]
	and		ecx,63									;Modulus 64
	je		zero_shift_word							;Check shift count 0
	ADD_SHIFT_CYCLES_BYTEWORD	ecx					;NOTE corrupts 'ebx'

	mov		bx,WORD PTR [edx]						;And shift
shift_loop:
	shr		bx,1
	loop	shift_loop

	mov		WORD PTR [edx],bx
	SET_NZ_CX_SAME_CLEAR_V
_lsr_dn_dn_word ENDP

;LSR.L Dx,Dy
_lsr_dn_dn_long PROC NEAR
	mov		ebx,DECODE_1[ecx]						;Dx
	mov		edx,DECODE_2[ecx]						;Dy(can corrupt 'ecx')
	mov		cl,BYTE PTR [ebx]
	and		ecx,63									;Modulus 64
	je		zero_shift_long							;Check shift count 0
	ADD_SHIFT_CYCLES_LONG	ecx						;NOTE corrupts 'ebx'

	mov		ebx,DWORD PTR [edx]						;And shift
shift_loop:
	shr		ebx,1
	loop	shift_loop

	mov		DWORD PTR [edx],ebx
	SET_NZ_CX_SAME_CLEAR_V
_lsr_dn_dn_long ENDP

;-----------------------------------------------------------------------
;LSR.B #<data>,Dy
_lsr_imm_dn_byte PROC NEAR
	mov		edx,DECODE_1[ecx]						;DReg
	mov		ecx,DECODE_2[ecx]						;Count		
	ADD_SHIFT_CYCLES_BYTEWORD	ecx					;NOTE corrupts 'ebx'

	mov		bl,BYTE PTR [edx]						;And shift
shift_loop:
	shr		bl,1
	loop	shift_loop

	mov		BYTE PTR [edx],bl
	SET_NZ_CX_SAME_CLEAR_V
_lsr_imm_dn_byte ENDP

;LSR.W #<data>,Dy
_lsr_imm_dn_word PROC NEAR
	mov		edx,DECODE_1[ecx]						;DReg
	mov		ecx,DECODE_2[ecx]						;Count		
	ADD_SHIFT_CYCLES_BYTEWORD	ecx					;NOTE corrupts 'ebx'

	mov		bx,WORD PTR [edx]						;And shift
shift_loop:
	shr		bx,1
	loop	shift_loop

	mov		WORD PTR [edx],bx
	SET_NZ_CX_SAME_CLEAR_V
_lsr_imm_dn_word ENDP

;LSR.L #<data>,Dy
_lsr_imm_dn_long PROC NEAR
	mov		edx,DECODE_1[ecx]						;DReg
	mov		ecx,DECODE_2[ecx]						;Count		
	ADD_SHIFT_CYCLES_LONG	ecx						;NOTE corrupts 'ebx'

	mov		ebx,DWORD PTR [edx]						;And shift
shift_loop:
	shr		ebx,1
	loop	shift_loop

	mov		DWORD PTR [edx],ebx
	SET_NZ_CX_SAME_CLEAR_V
_lsr_imm_dn_long ENDP

;-----------------------------------------------------------------------
;LSR.W <ea>
_lsr_ea_word PROC NEAR
	EFFADDR_READ									;Read <ea>
	shr		bx,1									;Shift (into condition codes)
	WRITE_WORD_NZ_CX_SAME_CLEAR_V
_lsr_ea_word ENDP
