;	WinSTon

;	LSL Dx,Dy
;	LSL #<data>,Dy
;	LSL <ea>

;	XNZVC
;	***0*

;  NOTE - Could check if shift <31 can be done in one instruction?

PUBLIC _lsl_dn_dn_byte
PUBLIC _lsl_dn_dn_word
PUBLIC _lsl_dn_dn_long
PUBLIC _lsl_imm_dn_byte
PUBLIC _lsl_imm_dn_word
PUBLIC _lsl_imm_dn_long
PUBLIC _lsl_ea_word

;-----------------------------------------------------------------------
;LSL.B Dx,Dy
_lsl_dn_dn_byte PROC NEAR
	mov		ebx,DECODE_1[ecx]						;Dx
	mov		edx,DECODE_2[ecx]						;Dy(can corrupt 'ecx')
	mov		cl,BYTE PTR [ebx]
	and		ecx,63									;Modulus 64
	je		zero_shift_byte							;Check shift count 0
	ADD_SHIFT_CYCLES_BYTEWORD	ecx					;NOTE corrupts 'ebx'

	mov		bl,BYTE PTR [edx]						;And shift
shift_loop:
	shl		bl,1
	loop	shift_loop

	mov		BYTE PTR [edx],bl
	SET_NZ_CX_SAME_CLEAR_V
_lsl_dn_dn_byte ENDP

;LSL.W Dx,Dy
_lsl_dn_dn_word PROC NEAR
	mov		ebx,DECODE_1[ecx]						;Dx
	mov		edx,DECODE_2[ecx]						;Dy(can corrupt 'ecx')
	mov		cl,BYTE PTR [ebx]
	and		ecx,63									;Modulus 64
	je		zero_shift_word							;Check shift count 0
	ADD_SHIFT_CYCLES_BYTEWORD	ecx					;NOTE corrupts 'ebx'

	mov		bx,WORD PTR [edx]						;And shift
shift_loop:
	shl		bx,1
	loop	shift_loop

	mov		WORD PTR [edx],bx
	SET_NZ_CX_SAME_CLEAR_V
_lsl_dn_dn_word ENDP

;LSL.L Dx,Dy
_lsl_dn_dn_long PROC NEAR
	mov		ebx,DECODE_1[ecx]						;Dx
	mov		edx,DECODE_2[ecx]						;Dy(can corrupt 'ecx')
	mov		cl,BYTE PTR [ebx]
	and		ecx,63									;Modulus 64
	je		zero_shift_long							;Check shift count 0
	ADD_SHIFT_CYCLES_LONG	ecx						;NOTE corrupts 'ebx'

	mov		ebx,DWORD PTR [edx]						;And shift
shift_loop:
	shl		ebx,1
	loop	shift_loop

	mov		DWORD PTR [edx],ebx
	SET_NZ_CX_SAME_CLEAR_V
_lsl_dn_dn_long ENDP

;-----------------------------------------------------------------------
;LSL.B #<data>,Dy
_lsl_imm_dn_byte PROC NEAR
	mov		edx,DECODE_1[ecx]						;DReg
	mov		ecx,DECODE_2[ecx]						;Count		
	ADD_SHIFT_CYCLES_BYTEWORD	ecx					;NOTE corrupts 'ebx'

	mov		bl,BYTE PTR [edx]						;And shift
shift_loop:
	shl		bl,1
	loop	shift_loop

	mov		BYTE PTR [edx],bl
	SET_NZ_CX_SAME_CLEAR_V
_lsl_imm_dn_byte ENDP

;LSL.W #<data>,Dy
_lsl_imm_dn_word PROC NEAR
	mov		edx,DECODE_1[ecx]						;DReg
	mov		ecx,DECODE_2[ecx]						;Count		
	ADD_SHIFT_CYCLES_BYTEWORD	ecx					;NOTE corrupts 'ebx'

	mov		bx,WORD PTR [edx]						;And shift
shift_loop:
	shl		bx,1
	loop	shift_loop

	mov		WORD PTR [edx],bx
	SET_NZ_CX_SAME_CLEAR_V
_lsl_imm_dn_word ENDP

;LSL.L #<data>,Dy
_lsl_imm_dn_long PROC NEAR
	mov		edx,DECODE_1[ecx]						;DReg
	mov		ecx,DECODE_2[ecx]						;Count		
	ADD_SHIFT_CYCLES_LONG	ecx						;NOTE corrupts 'ebx'

	mov		ebx,DWORD PTR [edx]						;And shift
shift_loop:
	shl		ebx,1
	loop	shift_loop

	mov		DWORD PTR [edx],ebx
	SET_NZ_CX_SAME_CLEAR_V
_lsl_imm_dn_long ENDP

;-----------------------------------------------------------------------
;LSL.W <ea>
_lsl_ea_word PROC NEAR
	EFFADDR_READ									;Read <ea>
	shl		bx,1									;Shift (into condition codes)
	WRITE_WORD_NZ_CX_SAME_CLEAR_V
_lsl_ea_word ENDP
