;	WinSTon

;	DIVU <ea>,Dn

;	XNZVC
;	-***0

PUBLIC _divu_ea_dn_word

;-----------------------------------------------------------------------
;DIVU.W <ea>,Dn
_divu_ea_dn_word PROC NEAR
	EFFADDR_READ									;Read <ea>

	or		bx,bx									;Is zero?
	jne		ok

	;Divide by zero
	mov		[_ExceptionVector],EXCEPTION_DIVZERO
	call	asm_exception							;Handle error
	FRET

ok:
	push	eax										;Keep our emulation ccodes
	mov		ebp,DECODE_2[ecx]						;DReg
	mov		eax,[ebp]								;Destination ('Dn' so correct endian)

	xor		edx,edx
	and		ebx,0ffffh
	div		ebx										;edx:eax / ebx into eax(quo),edx(rem)

	;Overflow?
	movzx	ecx, ax									;Zero extend
	cmp		ecx, eax
	je		no_overflow

	pop		eax										;Restore emulation ccodes
	mov		al,EMU_V								;Clear ccodes, set overflow
	FRET

no_overflow:
	and		eax,00000ffffh
	shl		edx,16									;Shift and clear lower bits
	or		eax,edx									;eax rem:quo
	mov		[ebp],eax								;And store

	or		ax,ax									;Set condition codes from integer part
	pop		eax										;Restore emulation ccodes
	SET_NZVC
_divu_ea_dn_word ENDP
