;	WinSTon

;	DIVS <ea>,Dn

;	XNZVC
;	-***0

PUBLIC _divs_ea_dn_word

;-----------------------------------------------------------------------
;DIVS.W <ea>,Dn
_divs_ea_dn_word PROC NEAR
	EFFADDR_READ									;Read <ea>

	or		bx,bx									;Is zero?
	jne		ok

	;Divide by zero
	mov		[_ExceptionVector],EXCEPTION_DIVZERO
	call	asm_exception							;Handle error
	FRET

ok:
	push	eax										;Keep our emulation ccodes
	mov		ebp,DECODE_2[ecx]						;DReg
	mov		eax,[ebp]								;Destination ('Dn' so correct endian)

	cdq
	movsx	ebx,bx
	idiv	ebx										;edx:eax / ebx into eax(quo),edx(rem)

	;Overflow?
	movsx	ecx, ax									;Sign extend
	cmp		ecx, eax
	je		no_overflow

	pop		eax										;Restore emulation ccodes
	mov		al,EMU_V								;Clear ccodes, set overflow
	FRET

no_overflow:
	and		eax,00000ffffh
	shl		edx,16									;Shift and clear lower bits
	or		eax,edx									;eax rem:quo
	mov		[ebp],eax								;And store

	or		ax,ax									;Set condition codes from integer part
	pop		eax										;Restore emulation ccodes
	SET_NZVC
_divs_ea_dn_word ENDP
