;	WinSTon

;	BSET Dn,Dn
;	BSET Dn,<ea>
;	BSET #<data>,Dn
;	BSET #<data>,<ea>

;	XNZVC
;	--*--

PUBLIC _bset_dn_dn_long
PUBLIC _bset_dn_ea_byte
PUBLIC _bset_imm_dn_long
PUBLIC _bset_imm_ea_byte

;-----------------------------------------------------------------------
;BSET.L Dn,Dn
_bset_dn_dn_long PROC NEAR
	and		eax,EMU_CLEAR_Z							;Set default condition code
	mov		edx,DECODE_2[ecx]						;DReg
	mov		ebx,[edx]
	and		ebx,31									;Modulo 32

	mov		edx,DECODE_1[ecx]						;DReg
	bts		[edx],ebx								;Set(into carry)
	jc		clear
	or		al,EMU_Z
clear:;
	FRET
_bset_dn_dn_long ENDP

;-----------------------------------------------------------------------
;BSET.B Dn,<ea>
_bset_dn_ea_byte PROC NEAR
	EFFADDR_READ									;Read <ea>
	and		eax,EMU_CLEAR_Z							;Set default condition code
	mov		edx,DECODE_2[ecx]						;DReg
	mov		edx,[edx]
	and		edx,7									;Modulo 8

	bts		ebx,edx									;Set(into carry)
	jc		clear
	or		al,EMU_Z
clear:;
	INTERCEPT_CHECK_ADDR_WRITEBYTE					;Write 'bl' to 'ebp', corrupts 'ecx'
	FRET
_bset_dn_ea_byte ENDP

;-----------------------------------------------------------------------
;BSET.L #<data>,Dn
_bset_imm_dn_long PROC NEAR
	and		eax,EMU_CLEAR_Z							;Set default condition code
	mov		bl,IMM_BYTE[esi]						;Immediate data
	add		esi,SIZE_WORD							;Increase program counter
	and		ebx,31									;Modulo 32

	mov		edx,DECODE_1[ecx]						;DReg
	bts		[edx],ebx								;Set(into carry)
	jc		clear
	or		al,EMU_Z
clear:;
	FRET
_bset_imm_dn_long ENDP

;-----------------------------------------------------------------------
;BSET.B #<data>,<ea>
_bset_imm_ea_byte PROC NEAR
	mov		dl,IMM_BYTE[esi]						;Immediate data
	add		esi,SIZE_WORD							;Increase program counter

	EFFADDR_READ									;Read <ea>
	and		eax,EMU_CLEAR_Z							;Set default condition code
	and		edx,7									;Modulo 8

	bts		ebx,edx									;Set(into carry)
	jc		clear
	or		al,EMU_Z
clear:;
	INTERCEPT_CHECK_ADDR_WRITEBYTE					;Write 'bl' to 'ebp', corrupts 'ecx'
	FRET
_bset_imm_ea_byte ENDP
