;	WinSTon

;	BCHG Dn,Dn
;	BCHG Dn,<ea>
;	BCHG #<data>,Dn
;	BCHG #<data>,<ea>

;	XNZVC
;	--*--

PUBLIC _bchg_dn_dn_long
PUBLIC _bchg_dn_ea_byte
PUBLIC _bchg_imm_dn_long
PUBLIC _bchg_imm_ea_byte

;-----------------------------------------------------------------------
;BCHG.L Dn,Dn
_bchg_dn_dn_long PROC NEAR
	and		eax,EMU_CLEAR_Z							;Set default condition code
	mov		edx,DECODE_2[ecx]						;DReg
	mov		ebx,[edx]
	and		ebx,31									;Modulo 32

	mov		edx,DECODE_1[ecx]						;DReg
	btc		[edx],ebx								;Test(into carry) and clear
	jc		clear
	or		al,EMU_Z
clear:;
	FRET
_bchg_dn_dn_long ENDP

;-----------------------------------------------------------------------
;BCHG.B Dn,<ea>
_bchg_dn_ea_byte PROC NEAR
	EFFADDR_READ									;Read <ea>
	and		eax,EMU_CLEAR_Z							;Set default condition code
	mov		edx,DECODE_2[ecx]						;DReg
	mov		edx,[edx]
	and		edx,7									;Modulo 8

	btc		ebx,edx									;Change(into carry)
	jc		clear
	or		al,EMU_Z
clear:;
	INTERCEPT_CHECK_ADDR_WRITEBYTE					;Write 'bl' to 'ebp', corrupts 'ecx'
	FRET
_bchg_dn_ea_byte ENDP

;-----------------------------------------------------------------------
;BCHG.L #<data>,Dn
_bchg_imm_dn_long PROC NEAR
	and		eax,EMU_CLEAR_Z							;Set default condition code
	mov		bl,IMM_BYTE[esi]						;Immediate data
	add		esi,SIZE_WORD							;Increase program counter
	and		ebx,31									;Modulo 32

	mov		edx,DECODE_1[ecx]						;DReg
	btc		[edx],ebx								;Change(into carry)
	jc		clear
	or		al,EMU_Z
clear:;
	FRET
_bchg_imm_dn_long ENDP

;-----------------------------------------------------------------------
;BCHG.B #<data>,<ea>
_bchg_imm_ea_byte PROC NEAR
	mov		dl,IMM_BYTE[esi]						;Immediate data
	add		esi,SIZE_WORD							;Increase program counter

	EFFADDR_READ									;Read <ea>
	and		eax,EMU_CLEAR_Z							;Set default condition code
	and		edx,7									;Modulo 8

	btc		ebx,edx									;Change(into carry)
	jc		clear
	or		al,EMU_Z
clear:;
	INTERCEPT_CHECK_ADDR_WRITEBYTE					;Write 'bl' to 'ebp', corrupts 'ecx'
	FRET
_bchg_imm_ea_byte ENDP
