;	WinSTon

;	Bcc <label>

;	XNZVC
;	-----

PUBLIC _bcc_s
PUBLIC _bcc_w
PUBLIC _bcs_s
PUBLIC _bcs_w
PUBLIC _beq_s
PUBLIC _beq_w
PUBLIC _bge_s
PUBLIC _bge_w
PUBLIC _bgt_s
PUBLIC _bgt_w
PUBLIC _bhi_s
PUBLIC _bhi_w
PUBLIC _ble_s
PUBLIC _ble_w
PUBLIC _bls_s
PUBLIC _bls_w
PUBLIC _blt_s
PUBLIC _blt_w
PUBLIC _bmi_s
PUBLIC _bmi_w
PUBLIC _bne_s
PUBLIC _bne_w
PUBLIC _bpl_s
PUBLIC _bpl_w
PUBLIC _bvc_s
PUBLIC _bvc_w
PUBLIC _bvs_s
PUBLIC _bvs_w

;-----------------------------------------------------------------------
;NOTE - Already added cycles 8,1,0(for short no-branch), and 12,1,0(for word no-branch)
;As cycles are rounded up to 4 and we have (when branch taken) 10,2,0 for short and word
;we make both round to 12,1,0(nearest 4). This means word is no different(already added)
bcc_bra_s PROC NEAR
	ADD_CYCLES	12-8								;Rounded up to 4
	add		esi,DECODE_1[ecx]						;8-bit offset
	FRET
bcc_bra_s ENDP

bcc_bra_w PROC NEAR
	mov		bx,WORD PTR [esi]
	SWAP_ENDIAN_WORD_BX
	movsx	ebx,bx
	add		esi,ebx
	FRET
bcc_bra_w ENDP

;-----------------------------------------------------------------------
;BCC <label>
_bcc_s PROC NEAR
	;NOT C
	test	eax,EMU_C								;(SR&CARRY)==0
	je		bcc_bra_s
	FRET
_bcc_s ENDP

_bcc_w PROC NEAR
	;NOT C
	test	eax,EMU_C								;(SR&CARRY)==0
	je		bcc_bra_w
	add		esi,SIZE_WORD							;Skip offset
	FRET
_bcc_w ENDP

;-----------------------------------------------------------------------
;BCS <label>
_bcs_s PROC NEAR
	;C
	test	eax,EMU_C								;SR&CARRY
	jne		bcc_bra_s
	FRET
_bcs_s ENDP

_bcs_w PROC NEAR
	;NOT C
	test	eax,EMU_C								;SR&CARRY
	jne		bcc_bra_w
	add		esi,SIZE_WORD							;Skip offset
	FRET
_bcs_w ENDP

;-----------------------------------------------------------------------
;BEQ <label>
_beq_s PROC NEAR
	;Z
	test	eax,EMU_Z								;SR&ZERO
	jne		bcc_bra_s
	FRET
_beq_s ENDP

_beq_w PROC NEAR
	;Z
	test	eax,EMU_Z								;SR&ZERO
	jne		bcc_bra_w
	add		esi,SIZE_WORD							;Skip offset
	FRET
_beq_w ENDP

;-----------------------------------------------------------------------
;BGE <label>
_bge_s PROC NEAR
	; N.V + NOT N.NOT V
	mov		ebx,eax
	and		ebx,EMU_N+EMU_V							;(SR&NEG) && (SR&OVERFLOW)
	cmp		ebx,EMU_N+EMU_V
	je		bcc_bra_s								;||
	or		ebx,ebx									;((SR&NEG)==0) && ((SR&OVERFLOW)==0)
	je		bcc_bra_s
	FRET
_bge_s ENDP

_bge_w PROC NEAR
	; N.V + NOT N.NOT V
	mov		ebx,eax
	and		ebx,EMU_N+EMU_V							;(SR&NEG) && (SR&OVERFLOW)
	cmp		ebx,EMU_N+EMU_V
	je		bcc_bra_w								;||
	or		ebx,ebx									;((SR&NEG)==0) && ((SR&OVERFLOW)==0)
	je		bcc_bra_w
	add		esi,SIZE_WORD							;Skip offset
	FRET
_bge_w ENDP

;-----------------------------------------------------------------------
;BGT <label>
_bgt_s PROC NEAR
	;N.V.NOT Z + NOT N.NOT V.NOT Z
	mov		ebx,eax
	and		ebx,EMU_N+EMU_V+EMU_Z					;(SR&NEG) && (SR&OVERFLOW) && ((SR&ZERO)==0)
	cmp		ebx,EMU_N+EMU_V
	je		bcc_bra_s								;||
	or		ebx,ebx									;((SR&NEG)==0) && ((SR&OVERFLOW)==0) && ((SR&ZERO)==0)
	je		bcc_bra_s
	FRET
_bgt_s ENDP

_bgt_w PROC NEAR
	;N.V.NOT Z + NOT N.NOT V.NOT Z
	mov		ebx,eax
	and		ebx,EMU_N+EMU_V+EMU_Z					;(SR&NEG) && (SR&OVERFLOW) && ((SR&ZERO)==0)
	cmp		ebx,EMU_N+EMU_V
	je		bcc_bra_w								;||
	or		ebx,ebx									;((SR&NEG)==0) && ((SR&OVERFLOW)==0) && ((SR&ZERO)==0)
	je		bcc_bra_w
	add		esi,SIZE_WORD							;Skip offset
	FRET
_bgt_w ENDP

;-----------------------------------------------------------------------
;BHI <label>
_bhi_s PROC NEAR
	;NOT C.NOT Z
	test	eax,EMU_C+EMU_Z							;((SR&CARRY)==0) && ((SR&ZERO)==0)
	je		bcc_bra_s
	FRET
_bhi_s ENDP

_bhi_w PROC NEAR
	;NOT C.NOT Z
	test	eax,EMU_C+EMU_Z							;((SR&CARRY)==0) && ((SR&ZERO)==0)
	je		bcc_bra_w
	add		esi,SIZE_WORD							;Skip offset
	FRET
_bhi_w ENDP

;-----------------------------------------------------------------------
;BLE <label>
_ble_s PROC NEAR
	;Z + N.NOT V + NOT N.V
	test	eax,EMU_Z								;(SR&ZERO)
	jne		bcc_bra_s								;||
	mov		ebx,eax
	and		ebx,EMU_N+EMU_V							;(SR&NEG) && ((SR&OVERFLOW)==0)
	cmp		ebx,EMU_N
	je		bcc_bra_s								;||
	cmp		ebx,EMU_V								;((SR&NEG)==0) && (SR&OVERFLOW)
	je		bcc_bra_s
	FRET
_ble_s ENDP

_ble_w PROC NEAR
	;Z + N.NOT V + NOT N.V
	test	eax,EMU_Z								;(SR&ZERO)
	jne		bcc_bra_w								;||
	mov		ebx,eax
	and		ebx,EMU_N+EMU_V							;(SR&NEG) && ((SR&OVERFLOW)==0)
	cmp		ebx,EMU_N
	je		bcc_bra_w								;||
	cmp		ebx,EMU_V								;((SR&NEG)==0) && (SR&OVERFLOW)
	je		bcc_bra_w
	add		esi,SIZE_WORD							;Skip offset
	FRET
_ble_w ENDP

;-----------------------------------------------------------------------
;BLS <label>
_bls_s PROC NEAR
	; C + Z
	test	eax,EMU_C								;(SR&CARRY)
	jne		bcc_bra_s								;||
	test	eax,EMU_Z								;(SR&ZERO)
	jne		bcc_bra_s
	FRET
_bls_s ENDP

_bls_w PROC NEAR
	; C + Z
	test	eax,EMU_C								;(SR&CARRY)
	jne		bcc_bra_w								;||
	test	eax,EMU_Z								;(SR&ZERO)
	jne		bcc_bra_w
	add		esi,SIZE_WORD							;Skip offset
	FRET
_bls_w ENDP

;-----------------------------------------------------------------------
;BLT <label>
_blt_s PROC NEAR
	;N.NOT V + NOT N.V
	mov		ebx,eax
	and		ebx,EMU_N+EMU_V							;(SR&NEG) && ((SR&OVERFLOW)==0)
	cmp		ebx,EMU_N
	je		bcc_bra_s								;||
	cmp		ebx,EMU_V								;((SR&NEG)==0) && (SR&OVERFLOW)
	je		bcc_bra_s
	FRET
_blt_s ENDP

_blt_w PROC NEAR
	;N.NOT V + NOT N.V
	mov		ebx,eax
	and		ebx,EMU_N+EMU_V							;(SR&NEG) && ((SR&OVERFLOW)==0)
	cmp		ebx,EMU_N
	je		bcc_bra_w								;||
	cmp		ebx,EMU_V								;((SR&NEG)==0) && (SR&OVERFLOW)
	je		bcc_bra_w
	add		esi,SIZE_WORD							;Skip offset
	FRET
_blt_w ENDP

;-----------------------------------------------------------------------
;BMI <label>
_bmi_s PROC NEAR
	;N
	test	eax,EMU_N								;(SR&NEG)
	jne		bcc_bra_s
	FRET
_bmi_s ENDP

_bmi_w PROC NEAR
	;N
	test	eax,EMU_N								;(SR&NEG)
	jne		bcc_bra_w
	add		esi,SIZE_WORD							;Skip offset
	FRET
_bmi_w ENDP

;-----------------------------------------------------------------------
;BNE <label>
_bne_s PROC NEAR
	;NOT Z
	test	eax,EMU_Z								;(SR&ZERO)==0
	je		bcc_bra_s
	FRET
_bne_s ENDP

_bne_w PROC NEAR
	;NOT Z
	test	eax,EMU_Z								;(SR&ZERO)==0
	je		bcc_bra_w
	add		esi,SIZE_WORD							;Skip offset
	FRET
_bne_w ENDP

;-----------------------------------------------------------------------
;BPL <label>
_bpl_s PROC NEAR
	;NOT N
	test	eax,EMU_N								;(SR&NEG)==0
	je		bcc_bra_s
	FRET
_bpl_s ENDP

_bpl_w PROC NEAR
	;NOT N
	test	eax,EMU_N								;(SR&NEG)==0
	je		bcc_bra_w
	add		esi,SIZE_WORD							;Skip offset
	FRET
_bpl_w ENDP

;-----------------------------------------------------------------------
;Bvc <label>
_bvc_s PROC NEAR
	;NOT V
	test	eax,EMU_V								;(SR&OVERFLOW)==0
	je		bcc_bra_s
	FRET
_bvc_s ENDP

_bvc_w PROC NEAR
	;NOT V
	test	eax,EMU_V							;(SR&OVERFLOW)==0
	je		bcc_bra_w
	add		esi,SIZE_WORD							;Skip offset
	FRET
_bvc_w ENDP

;-----------------------------------------------------------------------
;Bvs <label>
_bvs_s PROC NEAR
	;V
	test	eax,EMU_V								;(SR&OVERFLOW)
	jne		bcc_bra_s
	FRET
_bvs_s ENDP

_bvs_w PROC NEAR
	;V
	test	eax,EMU_V								;(SR&OVERFLOW)
	jne		bcc_bra_w
	add		esi,SIZE_WORD							;Skip offset
	FRET
_bvs_w ENDP
