#include "stdafx.h"

#include "SongCacheIndex.h"
#include "RageLog.h"
#include "RageUtil.h"
#include "Song.h"

SongCacheIndex *SONGINDEX;

SongCacheIndex::SongCacheIndex()
{
	CacheIndex.SetPath( "D:\\Cache\\index.cache" );
	ReadCacheIndex();
}

SongCacheIndex::~SongCacheIndex()
{

}

void SongCacheIndex::ReadCacheIndex()
{
	CacheIndex.ReadFile();	// don't care if this fails

	int iCacheVersion;
	CacheIndex.GetValueI( "Cache", "CacheVersion", iCacheVersion );
	if( iCacheVersion == FILE_CACHE_VERSION )
		return; /* OK */

	LOG->Trace( "Cache format is out of date.  Deleting all cache files." );
	CStringArray asCacheFileNames;
	GetDirListing( "D:\\Cache\\*.*", asCacheFileNames );
	for( int i=0; i<asCacheFileNames.GetSize(); i++ )
		DeleteFile( "D:\\Cache\\" + asCacheFileNames[i] );
	CacheIndex.Reset();
}

void SongCacheIndex::AddCacheIndex(const CString &path, int hash)
{
	CacheIndex.SetValueI( "Cache", "CacheVersion", FILE_CACHE_VERSION );
	CacheIndex.SetValueI( "Cache", path, hash );
	CacheIndex.WriteFile();
}

int SongCacheIndex::GetCacheHash( const CString &path )
{
	int iDirHash;
	CacheIndex.GetValueI( "Cache", path, iDirHash );
	return iDirHash;
}
