#pragma once
/*
-----------------------------------------------------------------------------
 Class: ScreenNetworkGame

 Desc: Area for testing.

 Copyright (c) 2001-2002 by the person(s) listed below.  All rights reserved.
	Brendan Walker
	Chris Danford
-----------------------------------------------------------------------------
*/

#include "Screen.h"
#include "Sprite.h"
#include "BitmapText.h"
#include "Quad.h"
#include "TransitionStarWipe.h"
#include "MenuElements.h"
#include "TipDisplay.h"
#include "RageSoundStream.h"


const int MAX_USER_LINES = 14;
const int MAX_SESSION_LINES = 8;
const int MAX_CHAT_LINES = 9;

class ScreenNetworkGame : public Screen
{
public:
	ScreenNetworkGame();

	virtual void Update( float fDeltaTime );
	virtual void DrawPrimitives();
	virtual void Input( const DeviceInput& DeviceI, const InputEventType type, const GameInput &GameI, const MenuInput &MenuI, const StyleInput &StyleI );
	virtual void HandleScreenMessage( const ScreenMessage SM );

	MenuElements m_Menu;

	BitmapText m_textUsers[MAX_USER_LINES];
	BitmapText m_textSessions[MAX_SESSION_LINES];
	BitmapText m_textSessionDetails;
	BitmapText m_textChat[MAX_CHAT_LINES];

};

