/*
-----------------------------------------------------------------------------
 Class: RageSoundSample

 Desc: A wrapper for Bass's SAMPLE type.  This class holds a single sound sample 
	from which and multiple channels (instances) can be generated.

 Copyright (c) 2001-2002 by the person(s) listed below.  All rights reserved.
	Chris Danford
-----------------------------------------------------------------------------
*/

#ifndef RAGE_SOUND_SAMPLE_H
#define RAGE_SOUND_SAMPLE_H


#include "RageSound.h"

#include "..\Mp3Player.h"

class RageSoundSample
{
public:
	RageSoundSample();
	~RageSoundSample();

	bool Load( CString sSoundFilePath, int iMaxChannels = 5 );
	void Unload();

	void Play();
	void Pause();
	void Stop();
	float GetLengthSeconds();
	float GetPositionSeconds();	// position of the most recent channel played
	bool SetPlaybackRate( float fScale );
	float GetPlaybackRate();
	bool IsPlaying();

	Mp3Player **m_mp3players ;
	DWORD m_dwThreadId ;
	HANDLE m_hThread ;
	DWORD m_numPlayers ;
	Mp3Player *m_lastPlayed ;
	CString m_filename ;

private:

	HSAMPLE m_hSample;
	float m_fLastKnownPosition;	// Bass will not report a sample position while it's paused,
								// so keep a record of the last position we saw so that we
								// can use this as the return value of GetPositionSeconds()
								// while the sample is paused.

	HCHANNEL m_hLastChannelPlayed;
};




#endif