#pragma once
/*
-----------------------------------------------------------------------------
 File: RageSound.h

 Desc: Sound effects library (currently a wrapper around Bass Sound Library).

 Copyright (c) 2001-2002 by the person(s) listed below.  All rights reserved.
	Chris Danford
-----------------------------------------------------------------------------
*/


#include "bass/bass.h"
#include "..\cstring.h"
#include "..\Mp3Player.h"

#define NUM_STREAMS		16


class RageSound
{
public:
	RageSound( HWND hWnd );
	~RageSound();

	float GetPlayLatency() { return m_info.latency / 1000.0f; };	// latency between when Play() is called and sound starts coming out

	void PlayOnceStreamed( CString sPath );
	void PlayOnceStreamedFromDir( CString sDir );
    HANDLE m_hThread; 
	CString m_filename ;
	Mp3Player **m_mp3players ;
	DWORD m_numPlayers ;

private:
	HWND		m_hWndApp;	// this is set on GRAPHICS_Create()
	BASS_INFO	m_info;
};



extern RageSound*		SOUND;	// global and accessable from anywhere in our program
