#include <xtl.h>
#include <XBApp.h>

#include <string.h>
#include "SDLInputDevice.h"

// Text for error messages
const CHAR* inputErrorMessages[1] = {
    "Unable to initialize joystick",
};

char* g_lpszPOVDescriptions[4] = {
    "Up", "Right", "Down", "Left"
};

float buttons[TOTAL_CONTROL_COUNT] ;


/*
SDLKey DEFAULT_KEYS_PLAYER_ONE[28] = {
    SDLK_UP, (SDLKey)0, SDLK_RIGHT, (SDLKey)0, SDLK_DOWN, (SDLKey)0, SDLK_LEFT,
    (SDLKey)0,
    SDLK_LCTRL, SDLK_z, SDLK_x, (SDLKey)0, (SDLKey)0, (SDLKey)0,
    SDLK_1, SDLK_2, SDLK_3, SDLK_4, SDLK_5, SDLK_6, SDLK_7, SDLK_8, SDLK_9,
    SDLK_0, SDLK_DELETE, SDLK_RETURN, SDLK_ASTERISK, SDLK_PLUS
};

SDLKey DEFAULT_KEYS_PLAYER_TWO[28] = {
    SDLK_LEFTBRACKET, (SDLKey)0, SDLK_RIGHTBRACKET, (SDLKey)0, SDLK_BACKSLASH,
    (SDLKey)0,
    SDLK_QUOTE, (SDLKey)0, SDLK_RCTRL, SDLK_PERIOD, SDLK_BACKSLASH, (SDLKey)0,
    (SDLKey)0,
    (SDLKey)0,
    SDLK_q, SDLK_w, SDLK_e, SDLK_r, SDLK_t, SDLK_y, SDLK_u, SDLK_i, SDLK_o,
    SDLK_p, SDLK_k, SDLK_l, SDLK_COMMA, SDLK_m,
};

SDLKey DEFAULT_KEYS_KEYBOARD[49] = {
    SDLK_a, SDLK_b, SDLK_c, SDLK_d, SDLK_e, SDLK_f, SDLK_g, SDLK_h, SDLK_i,
    SDLK_j, SDLK_k, SDLK_l, SDLK_m, SDLK_n, SDLK_o, SDLK_p, SDLK_q, SDLK_r,
    SDLK_s, SDLK_t, SDLK_u, SDLK_v, SDLK_w, SDLK_x, SDLK_y, SDLK_z, SDLK_0,
    SDLK_1, SDLK_2, SDLK_3, SDLK_4, SDLK_5, SDLK_6, SDLK_7, SDLK_8, SDLK_9,
    SDLK_UP, SDLK_DOWN, SDLK_LEFT, SDLK_RIGHT,
    SDLK_COMMA, SDLK_PERIOD, SDLK_SPACE, SDLK_SEMICOLON, SDLK_COLON,
    SDLK_ESCAPE, SDLK_RETURN, SDLK_LCTRL, SDLK_LSHIFT,
};

SDLKey DEFAULT_KEYS_EMULATOR[5] = {
    SDLK_F1, SDLK_F5, SDLK_F6, SDLK_F9, SDLK_F12
};

SDLKey DEFAULT_KEYS_MENU[6] = {
    SDLK_ESCAPE, SDLK_UP, SDLK_DOWN, SDLK_PAGEUP, SDLK_PAGEDOWN, SDLK_RETURN
};
*/

SDLInputDevice::SDLInputDevice()
{
	m_requestFlags = 0;

	/*
    m_pMappedSignals = new SDLInputSignal*[TOTAL_CONTROL_COUNT];
//    memset(m_pMappedSignals, 0, sizeof(m_pMappedSignals));	// sizeof = 4
	memset(m_pMappedSignals, 0, sizeof(SDLInputSignal*)*TOTAL_CONTROL_COUNT);

    //initialize the player one input signals
    INT32 size = (PLAYER_ONE_ID_END - PLAYER_ONE_ID_START)+1;
    INT32 i;
    for (i = 0; i < size; i++) {
        if (!DEFAULT_KEYS_PLAYER_ONE[i])
            continue;

        m_pMappedSignals[PLAYER_ONE_ID_START+i] = new SDLInputSignal(0,
                DEFAULT_KEYS_PLAYER_ONE[i],
                SDL_GetKeyName(DEFAULT_KEYS_PLAYER_ONE[i]));
    }

    //initialize the player two input signals
    size = (PLAYER_TWO_ID_END - PLAYER_TWO_ID_START)+1;
    for (i = 0; i < size; i++) {
        if (!DEFAULT_KEYS_PLAYER_TWO[i])
            continue;

        m_pMappedSignals[PLAYER_TWO_ID_START+i] = new SDLInputSignal(0,
                DEFAULT_KEYS_PLAYER_TWO[i],
                SDL_GetKeyName(DEFAULT_KEYS_PLAYER_TWO[i]));
    }

    //initialize the ecs keyboard input signals
    size = (KEYBOARD_ID_END - KEYBOARD_ID_START)+1;
    for (i = 0; i < size; i++) {
        if (!DEFAULT_KEYS_KEYBOARD[i])
            continue;

        m_pMappedSignals[KEYBOARD_ID_START+i] = new SDLInputSignal(0,
                DEFAULT_KEYS_KEYBOARD[i],
                SDL_GetKeyName(DEFAULT_KEYS_KEYBOARD[i]));
    }

    //initialize the emulator control input signals
    size = (EMULATOR_ID_END - EMULATOR_ID_START)+1;
    for (i = 0; i < size; i++) {
        if (!DEFAULT_KEYS_EMULATOR[i])
            continue;

        m_pMappedSignals[EMULATOR_ID_START+i] = new SDLInputSignal(0,
                DEFAULT_KEYS_EMULATOR[i],
                SDL_GetKeyName(DEFAULT_KEYS_EMULATOR[i]));
    }

    //initialize the menu control input signals
    size = (MENU_ID_END - MENU_ID_START)+1;
    for (i = 0; i < size; i++) {
        if (!DEFAULT_KEYS_MENU[i])
            continue;

        m_pMappedSignals[MENU_ID_START+i] = new SDLInputSignal(0,
                DEFAULT_KEYS_MENU[i],
                SDL_GetKeyName(DEFAULT_KEYS_MENU[i]));
    }
    m_KeyStates = SDL_GetKeyState(NULL);
*/
}

SDLInputDevice::~SDLInputDevice()
{
    // Cleanup before shutdown
    release();

    //delete[] m_pMappedSignals;
}


const CHAR* SDLInputDevice::getErrorDescription(ERRCODE errorCode) {
    return inputErrorMessages[errorCode-1];
}

// init: Activate input
ERRCODE SDLInputDevice::init()
{
	/*
#ifdef _TRACE_INPUT
  fprintf(stderr, "SDLInputDevice::init()\n");
#endif

    if(SDL_Init(SDL_INIT_JOYSTICK))
        return ERR_INIT_INPUT;

    m_iNumJoysticks = SDL_NumJoysticks(); 

    INT32 x;
    for(x = 0; x < m_iNumJoysticks; x++)
        joy[x] = SDL_JoystickOpen(x);
*/
    return OK;
}

// release: Cleanup
void SDLInputDevice::release()
{
#ifdef _TRACE_INPUT
  fprintf(stderr, "SDLInputDevice::release()\n");
#endif
/*
    for(int x = 0; x < m_iNumJoysticks; x++) {
        if(SDL_JoystickOpened(x))
            SDL_JoystickClose(joy[x]);
    }
    m_iNumJoysticks = 0;

    SDL_QuitSubSystem(SDL_INIT_JOYSTICK);
	*/
}

#ifdef __cplusplus
extern "C" {
#endif


int xbox_check_events() ;
void writexbox( char *msg) ;

#ifdef __cplusplus
}
#endif


// poll: Get input events
void SDLInputDevice::poll()
{
	char xmsg[100] ;
#ifdef _TRACE_INPUT
  fprintf(stderr, "SDLInputDevice::poll()... ");
#endif


	xbox_check_events() ;

	memset(buttons, 0, sizeof(buttons) ) ;


	if ( g_Gamepads[0].hDevice )
	{
		if ( g_Gamepads[0].fY1 || g_Gamepads[0].fX1 )
		{
			buttons[PLAYER_ONE_NORTH] = ( g_Gamepads[0].fY1 > 0 ) ? g_Gamepads[0].fY1 : 0 ;
			buttons[PLAYER_ONE_SOUTH] = ( g_Gamepads[0].fY1 < 0 ) ? g_Gamepads[0].fY1*-1.0 : 0 ;
			buttons[PLAYER_ONE_EAST] = ( g_Gamepads[0].fX1 > 0 ) ? g_Gamepads[0].fX1 : 0 ;
			buttons[PLAYER_ONE_WEST] = ( g_Gamepads[0].fX1 < 0 ) ? g_Gamepads[0].fX1*-1.0 : 0 ;
		}
		else
		{
			//buttons[PLAYER_ONE_NORTHWEST] = ( ( g_Gamepads[0].wButtons & XINPUT_GAMEPAD_DPAD_UP ) && ( g_Gamepads[0].wButtons & XINPUT_GAMEPAD_DPAD_LEFT ) ) ;
			//buttons[PLAYER_ONE_NORTHEAST] = ( ( g_Gamepads[0].wButtons & XINPUT_GAMEPAD_DPAD_UP ) && ( g_Gamepads[0].wButtons & XINPUT_GAMEPAD_DPAD_RIGHT ) ) ;
			//buttons[PLAYER_ONE_SOUTHWEST] = ( ( g_Gamepads[0].wButtons & XINPUT_GAMEPAD_DPAD_DOWN ) && ( g_Gamepads[0].wButtons & XINPUT_GAMEPAD_DPAD_LEFT ) ) ;
			//buttons[PLAYER_ONE_SOUTHEAST] = ( ( g_Gamepads[0].wButtons & XINPUT_GAMEPAD_DPAD_DOWN ) && ( g_Gamepads[0].wButtons & XINPUT_GAMEPAD_DPAD_LEFT ) ) ;
			buttons[PLAYER_ONE_NORTH] = g_Gamepads[0].wButtons & XINPUT_GAMEPAD_DPAD_UP ;
			buttons[PLAYER_ONE_SOUTH] = g_Gamepads[0].wButtons & XINPUT_GAMEPAD_DPAD_DOWN ;
			buttons[PLAYER_ONE_EAST] = g_Gamepads[0].wButtons & XINPUT_GAMEPAD_DPAD_RIGHT ;
			buttons[PLAYER_ONE_WEST] = g_Gamepads[0].wButtons & XINPUT_GAMEPAD_DPAD_LEFT ;
		}

		if ( g_Gamepads[0].bAnalogButtons[ XINPUT_GAMEPAD_A ] ) 
			buttons[PLAYER_ONE_BUTTON_ONE] = 1 ;
		if ( g_Gamepads[0].bAnalogButtons[ XINPUT_GAMEPAD_B ] ) 
			buttons[PLAYER_ONE_BUTTON_THREE] = 1 ;
		if ( g_Gamepads[0].bAnalogButtons[ XINPUT_GAMEPAD_X ] ) 
			buttons[PLAYER_ONE_BUTTON_TWO] = 1 ;
		if ( g_Gamepads[0].wButtons & XINPUT_GAMEPAD_START )  
			buttons[PLAYER_ONE_KEYPAD_ENTER] = 1 ;

		if ( g_Gamepads[0].wButtons & XINPUT_GAMEPAD_BACK )  
			buttons[EMULATOR_RESET] = 1 ;
		if ( g_Gamepads[0].wButtons & XINPUT_GAMEPAD_RIGHT_THUMB )
			buttons[PLAYER_ONE_KEYPAD_FIVE] = 1 ;

		if ( g_Gamepads[0].bAnalogButtons[XINPUT_GAMEPAD_WHITE]) 
		{
			buttons[PLAYER_ONE_KEYPAD_ZERO] = 1 ;
		}
		if ( g_Gamepads[0].bAnalogButtons[XINPUT_GAMEPAD_BLACK]) 
		{
			buttons[PLAYER_ONE_KEYPAD_DELETE] = 1 ;
		}

		if ( ( fabs(g_Gamepads[0].fX2) > .3 ) && ( fabs(g_Gamepads[0].fY2) > .3 ) )
		{
			//sprintf( xmsg, "33-x=%f,y=%f\r\n", g_Gamepads[0].fX2, g_Gamepads[0].fY2 ) ;
			//writexbox( xmsg ) ;
			if ( g_Gamepads[0].fX2 > 0 )
			{
				if ( g_Gamepads[0].fY2 > 0 )
				{
					buttons[PLAYER_ONE_KEYPAD_THREE] = 1 ;
				}
				else
				{
					buttons[PLAYER_ONE_KEYPAD_NINE] = 1 ;
				}
			}
			else
			{
				if ( g_Gamepads[0].fY2 > 0 )
				{
					buttons[PLAYER_ONE_KEYPAD_ONE] = 1 ;
				}
				else
				{
					buttons[PLAYER_ONE_KEYPAD_SEVEN] = 1 ;
				}
			}
		}
		else if ( fabs(g_Gamepads[0].fX2) > .5 )
		{
			//sprintf( xmsg, "xx-x=%f,y=%f\r\n", g_Gamepads[0].fX2, g_Gamepads[0].fY2 ) ;
			//writexbox( xmsg ) ;
			if ( g_Gamepads[0].fX2 < 0 )
			{
				buttons[PLAYER_ONE_KEYPAD_FOUR] = 1 ;
			}
			else
			{
				buttons[PLAYER_ONE_KEYPAD_SIX] = 1 ;
			}
		}
		else if ( fabs( g_Gamepads[0].fY2) > .5 ) 
		{
			//sprintf( xmsg, "yy-x=%f,y=%f\r\n", g_Gamepads[0].fX2, g_Gamepads[0].fY2 ) ;
			//writexbox( xmsg ) ;
			if ( g_Gamepads[0].fY2 < 0 )
			{
				buttons[PLAYER_ONE_KEYPAD_EIGHT] = 1 ;
			}
			else
			{
				buttons[PLAYER_ONE_KEYPAD_TWO] = 1 ;
			}
		}

	}


/*
    PLAYER_ONE_KEYPAD_ONE     = PLAYER_ONE_ID_START + 14,
    PLAYER_ONE_KEYPAD_TWO     = PLAYER_ONE_ID_START + 15,
    PLAYER_ONE_KEYPAD_THREE   = PLAYER_ONE_ID_START + 16,
    PLAYER_ONE_KEYPAD_FOUR    = PLAYER_ONE_ID_START + 17,
    PLAYER_ONE_KEYPAD_FIVE    = PLAYER_ONE_ID_START + 18,
    PLAYER_ONE_KEYPAD_SIX     = PLAYER_ONE_ID_START + 19,
    PLAYER_ONE_KEYPAD_SEVEN   = PLAYER_ONE_ID_START + 20,
    PLAYER_ONE_KEYPAD_EIGHT   = PLAYER_ONE_ID_START + 21,
    PLAYER_ONE_KEYPAD_NINE    = PLAYER_ONE_ID_START + 22,
    PLAYER_ONE_KEYPAD_DELETE  = PLAYER_ONE_ID_START + 24,
    PLAYER_ONE_KEYPAD_ZERO    = PLAYER_ONE_ID_START + 23,
    PLAYER_ONE_KEYPAD_ENTER   = PLAYER_ONE_ID_START + 25,

*/

	if ( g_Gamepads[1].hDevice )
	{
		if ( g_Gamepads[1].fY1 || g_Gamepads[1].fX1 )
		{
			buttons[PLAYER_TWO_NORTH] = ( g_Gamepads[1].fY1 > 0 ) ? g_Gamepads[1].fY1 : 0 ;
			buttons[PLAYER_TWO_SOUTH] = ( g_Gamepads[1].fY1 < 0 ) ? g_Gamepads[1].fY1*-1.0 : 0 ;
			buttons[PLAYER_TWO_EAST] = ( g_Gamepads[1].fX1 > 0 ) ? g_Gamepads[1].fX1 : 0 ;
			buttons[PLAYER_TWO_WEST] = ( g_Gamepads[1].fX1 < 0 ) ? g_Gamepads[1].fX1*-1.0 : 0 ;
		}
		else
		{
			buttons[PLAYER_TWO_NORTH] = g_Gamepads[1].wButtons & XINPUT_GAMEPAD_DPAD_UP;
			buttons[PLAYER_TWO_SOUTH] = g_Gamepads[1].wButtons & XINPUT_GAMEPAD_DPAD_DOWN;
			buttons[PLAYER_TWO_EAST] = g_Gamepads[1].wButtons & XINPUT_GAMEPAD_DPAD_RIGHT;
			buttons[PLAYER_TWO_WEST] = g_Gamepads[1].wButtons & XINPUT_GAMEPAD_DPAD_LEFT;
		}

		if ( g_Gamepads[1].wButtons & XINPUT_GAMEPAD_BACK )  
			buttons[EMULATOR_RESET] = 1 ;

		if ( g_Gamepads[1].bAnalogButtons[ XINPUT_GAMEPAD_A ] ) 
			buttons[PLAYER_TWO_BUTTON_ONE] = 1 ;
		if ( g_Gamepads[1].bAnalogButtons[ XINPUT_GAMEPAD_B ] ) 
			buttons[PLAYER_TWO_BUTTON_THREE] = 1 ;
		if ( g_Gamepads[1].bAnalogButtons[ XINPUT_GAMEPAD_X ] ) 
			buttons[PLAYER_TWO_BUTTON_TWO] = 1 ;
		if ( g_Gamepads[1].wButtons & XINPUT_GAMEPAD_START )  
			buttons[PLAYER_TWO_KEYPAD_ENTER] = 1 ;

		if ( g_Gamepads[1].wButtons & XINPUT_GAMEPAD_RIGHT_THUMB )
			buttons[PLAYER_TWO_KEYPAD_FIVE] = 1 ;

		if ( g_Gamepads[1].bAnalogButtons[XINPUT_GAMEPAD_WHITE]) 
		{
			buttons[PLAYER_TWO_KEYPAD_ZERO] = 1 ;
		}
		if ( g_Gamepads[1].bAnalogButtons[XINPUT_GAMEPAD_BLACK]) 
		{
			buttons[PLAYER_TWO_KEYPAD_DELETE] = 1 ;
		}

		if ( ( fabs(g_Gamepads[1].fX2) > .3 ) && ( fabs(g_Gamepads[1].fY2) > .3 ) )
		{
			//sprintf( xmsg, "33-x=%f,y=%f\r\n", g_Gamepads[1].fX2, g_Gamepads[1].fY2 ) ;
			//writexbox( xmsg ) ;
			if ( g_Gamepads[1].fX2 > 0 )
			{
				if ( g_Gamepads[1].fY2 > 0 )
				{
					buttons[PLAYER_TWO_KEYPAD_THREE] = 1 ;
				}
				else
				{
					buttons[PLAYER_TWO_KEYPAD_NINE] = 1 ;
				}
			}
			else
			{
				if ( g_Gamepads[1].fY2 > 0 )
				{
					buttons[PLAYER_TWO_KEYPAD_ONE] = 1 ;
				}
				else
				{
					buttons[PLAYER_TWO_KEYPAD_SEVEN] = 1 ;
				}
			}
		}
		else if ( fabs(g_Gamepads[1].fX2) > .5 )
		{
			//sprintf( xmsg, "xx-x=%f,y=%f\r\n", g_Gamepads[1].fX2, g_Gamepads[1].fY2 ) ;
			//writexbox( xmsg ) ;
			if ( g_Gamepads[1].fX2 < 0 )
			{
				buttons[PLAYER_TWO_KEYPAD_FOUR] = 1 ;
			}
			else
			{
				buttons[PLAYER_TWO_KEYPAD_SIX] = 1 ;
			}
		}
		else if ( fabs( g_Gamepads[1].fY2) > .5 ) 
		{
			//sprintf( xmsg, "yy-x=%f,y=%f\r\n", g_Gamepads[1].fX2, g_Gamepads[1].fY2 ) ;
			//writexbox( xmsg ) ;
			if ( g_Gamepads[1].fY2 < 0 )
			{
				buttons[PLAYER_TWO_KEYPAD_EIGHT] = 1 ;
			}
			else
			{
				buttons[PLAYER_TWO_KEYPAD_TWO] = 1 ;
			}
		}
  }



}

/*

	if ( g_Gamepads[port].hDevice )
	{

		if ( g_Gamepads[port].bAnalogButtons[ XINPUT_GAMEPAD_A ] ) 
			value |= JOY_A ;
		if ( g_Gamepads[port].bAnalogButtons[ XINPUT_GAMEPAD_X ] ) 
			value |= JOY_B ;
		if ( g_Gamepads[port].wButtons & XINPUT_GAMEPAD_DPAD_LEFT ) 
			value |= JOY_LEFT ;
		if ( g_Gamepads[port].wButtons & XINPUT_GAMEPAD_DPAD_UP ) 
			value |= JOY_UP ;
		if ( g_Gamepads[port].wButtons & XINPUT_GAMEPAD_DPAD_RIGHT ) 
			value |= JOY_RIGHT ;
		if ( g_Gamepads[port].wButtons & XINPUT_GAMEPAD_DPAD_DOWN ) 
			value |= JOY_DOWN ;
		if ( g_Gamepads[port].wButtons & XINPUT_GAMEPAD_START )  
			value |= JOY_START ;
		if ( g_Gamepads[port].wButtons & XINPUT_GAMEPAD_BACK )  
			value |= JOY_SELECT ;

		if ( g_Gamepads[port].bPressedAnalogButtons[XINPUT_GAMEPAD_RIGHT_TRIGGER])
		{
			//bkgHalt = bkgHalt ^ 1 ;
		}

		if ( ( g_Gamepads[port].bAnalogButtons[XINPUT_GAMEPAD_LEFT_TRIGGER]) && 
			 (g_Gamepads[port].bPressedAnalogButtons[XINPUT_GAMEPAD_WHITE]) )
		{
			loadgame() ;
		}
		else if ( ( g_Gamepads[port].bAnalogButtons[XINPUT_GAMEPAD_LEFT_TRIGGER]) && 
			 (g_Gamepads[port].bPressedAnalogButtons[XINPUT_GAMEPAD_BLACK]) )
		{
			savegame() ;
		}

		//sprintf( xmsg, "x=%d,y=%d,x=%d,y=%d\r\n", g_Gamepads[port].sThumbRX, g_Gamepads[port].sThumbRX, g_Gamepads[port].fX2, g_Gamepads[port].fY2 ) ;

		if ( g_Gamepads[port].fX2 )
		{
			m_sound.adjust_volume( (int) ( g_Gamepads[port].fX2 * 25.0 ) ) ;
		}
		if ( g_Gamepads[port].fY2 )
		{
			m_mp3player.adjust_volume( (int) ( g_Gamepads[port].fY2 * 25.0 ) ) ;
		}
	
*/

//  if ( 
	//XBInput_GetInput();
  //xbox_check_event() ;

    //SDL_PumpEvents();
//    SDL_Event event;
//    while (SDL_PollEvent(&event));			// Going to lose non-keyboard events?
/*
    SDL_PumpEvents();

	if(m_KeyStates[SDLK_RETURN]) {
		if(SDL_GetModState() & KMOD_ALT) {
			m_requestFlags	|= MSG_TOGGLE;
            m_KeyStates[SDLK_RETURN] = 0;
		}
	}
	*/
//}
/*
bool SDLInputDevice::altPressed()
{
    if(SDL_GetModState() & KMOD_ALT)
        return true;

    return false;
}
*/


float SDLInputDevice::getJoystickSignalValue(INT32 joystickNum, INT32 inputCode)
{
	/*
    if (joystickNum >= SDL_NumJoysticks())
        return 0.0f;

    if (inputCode < 6) {
        long inputValue = 0;
        long maxValue = 32768;
        switch (inputCode) {
            case 0:
                inputValue = -(SDL_JoystickGetAxis(joy[joystickNum], 0));
                break;
            case 1:
                inputValue = -(SDL_JoystickGetAxis(joy[joystickNum], 1));
                break;
            case 2:
                inputValue = -(SDL_JoystickGetAxis(joy[joystickNum], 2));
                break;
            case 3:
                inputValue = SDL_JoystickGetAxis(joy[joystickNum], 0);
                break;
            case 4:
                inputValue = SDL_JoystickGetAxis(joy[joystickNum], 1);
                break;
            case 5:
                inputValue = SDL_JoystickGetAxis(joy[joystickNum], 2);
                break;
				*/

/*                inputValue = -(m_JoystickStates[joystickNum].lX -
                        m_JoystickAxes[joystickNum].lCenterX);
                maxValue = m_JoystickAxes[joystickNum].lMaxDeltaX;
                break;
            case 1:
                inputValue = -(m_JoystickStates[joystickNum].lY -
                        m_JoystickAxes[joystickNum].lCenterY);
                maxValue = m_JoystickAxes[joystickNum].lMaxDeltaY;
                break;
            case 2:
                inputValue = -(m_JoystickStates[joystickNum].lZ -
                        m_JoystickAxes[joystickNum].lCenterZ);
                maxValue = m_JoystickAxes[joystickNum].lMaxDeltaZ;
                break;
            case 3:
                inputValue = m_JoystickStates[joystickNum].lX -
                        m_JoystickAxes[joystickNum].lCenterX;
                maxValue = m_JoystickAxes[joystickNum].lMaxDeltaX;
                break;
            case 4:
                inputValue = m_JoystickStates[joystickNum].lY -
                        m_JoystickAxes[joystickNum].lCenterY;
                maxValue = m_JoystickAxes[joystickNum].lMaxDeltaY;
                break;
            case 5:
                inputValue = m_JoystickStates[joystickNum].lZ -
                        m_JoystickAxes[joystickNum].lCenterZ;
                maxValue = m_JoystickAxes[joystickNum].lMaxDeltaZ;
                break; */
/*        }

        if (inputValue <= 0)
            return 0.0f;

        return (float)((float)inputValue)/((float)maxValue);
    }
    else if (inputCode < 262) {
        return SDL_JoystickGetButton(joy[joystickNum], inputCode-6);
//        m_JoystickStates[joystickNum].
//                rgbButtons[inputCode-6] & 0x80 ? 1.0f : 0.0f);
    }
	*/
/*    else if (inputCode < 278) {
        INT32 directionToCheck = (inputCode-262) & 0x03;
        DWORD povValue = m_
//            m_JoystickStates[joystickNum].
//                rgdwPOV[((inputCode-262) & 0x0C) >> 2];
        if (LOWORD(povValue) == 0xFFFF)
            return 0.0f;

        INT32 direction = ((povValue + 4500) / 9000) & 0x03;
        return (direction == directionToCheck ? 1.0f : 0.0f);
    } */


    return 0.0f;
}

float SDLInputDevice::getControlValue(INT32 inputID)
{
	return buttons[inputID] ;
	/*
    SDLInputSignal* inputSignal = m_pMappedSignals[inputID];
    if (inputSignal) {
        if (inputSignal->deviceID == 0) {
						if(m_KeyStates[inputSignal->controlID])
						{
								if(m_bRepeatKeys == FALSE)
								{
										m_KeyStates[inputSignal->controlID] = 0;
								}
								return SIGNAL_ON;
						}
						else
						{
								return SIGNAL_OFF;
						}
        }
        else
            return getJoystickSignalValue((int)inputSignal->deviceID-1,
                    (int)inputSignal->controlID);
    }
*/
	switch ( inputID )
	{
	}

    return 0.0f;
}
