#ifndef _WIN32
#include "RDTSCClockDevice.h"
#include <unistd.h>

inline INT64 read_rdtsc()
{
	INT32 high,low;
  INT64 val;
	__asm__ __volatile__ ("rdtsc" : "=a" (((INT32*)&high)[0]),"=d" (((INT32*)&low)[0]):);
  val = (INT64)(((INT64)high << 32) | (INT64)low);
	return(val);
}

RDTSCClockDevice::RDTSCClockDevice()
{
    INT64 start, stop;
    start = read_rdtsc();
    usleep(1000);
    stop = read_rdtsc();
    m_OneSecDiff = (INT32)(stop - start);
}

INT64 RDTSCClockDevice::getTickFrequency()
{
    return m_OneSecDiff;
} 

INT64 RDTSCClockDevice::getTick()
{
    return read_rdtsc();
} 

#endif
