
#include "MicroSequencer.h"
#include "MicroSequencer_Registers.h"

void MicroSequencer_Registers::init(MicroSequencer* ms)
{
    this->ms = ms;
}

void MicroSequencer_Registers::reset() {}

UINT16 MicroSequencer_Registers::getSize()
{
    return 2;
}

UINT16 MicroSequencer_Registers::getNumLocations()
{
    return 1;
}

UINT16 MicroSequencer_Registers::getLocation(UINT16 i)
{
    return 0x0080;
}

BOOL MicroSequencer_Registers::isLocationReadable(UINT16 i)
{
    return TRUE;
}

BOOL MicroSequencer_Registers::isLocationWriteable(UINT16 i)
{
    return TRUE;
}

void MicroSequencer_Registers::poke(UINT16 location, UINT16 value)
{
    switch(location) {
        case 0x0080:
            if (ms->lrqHigh) {
                ms->command = value & 0xFF;
                ms->lrqHigh = FALSE;
                if (!ms->speaking)
                    ms->isIdle = FALSE;
            }
            break;
        case 0x0081:
            if ((value & 0x0400) != 0)
                ms->reset();
            else if (ms->fifoSize < MicroSequencer::FIFO_MAX_SIZE) {
                ms->fifoBytes[(ms->fifoHead+ms->fifoSize) & 0x3F] = value;
                ms->fifoSize++;
            }
            break;
    }
}

UINT16 MicroSequencer_Registers::peek(UINT16 location) {
    switch(location) {
        case 0x0080:
            return (ms->lrqHigh ? 0x8000 : 0);
        case 0x0081:
        default:
            return (ms->fifoSize == MicroSequencer::FIFO_MAX_SIZE ? 0x8000 : 0);
    }
}

