
#ifndef GROM_H
#define GROM_H

#include "../core/Memory.h"

#define GROM_SIZE 0x800

class GROM : public Memory16Bit
{

    friend class AY38900;

    public:
		GROM();

        void reset();
        UINT16 getSize();
        UINT16 getNumLocations();
        UINT16 getLocation(UINT16 i);
        BOOL isLocationReadable(UINT16 i);
        BOOL isLocationWriteable(UINT16 i);
        UINT16 peek(UINT16 location);
        void poke(UINT16 location, UINT16 value);

    private:
        UINT16       image[GROM_SIZE];
        BOOL         visible;

};

#endif
