
#ifndef AY38900_REGISTERS_H
#define AY38900_REGISTERS_H

#include "../core/Memory.h"

class AY38900;

class AY38900_Registers : Memory16Bit
{
    friend class AY38900;

    public:
        void reset();
        UINT16 getSize();
        UINT16 getNumLocations();
        UINT16 getLocation(UINT16 i);
        BOOL isLocationReadable(UINT16 i);
        BOOL isLocationWriteable(UINT16 i);
        void poke(UINT16 location, UINT16 value);
        UINT16 peek(UINT16 location);

    private:
        AY38900_Registers();
        void init(AY38900* ay38900);

        AY38900* ay38900;
        UINT16   memory[0x40];
        BOOL     visible;

};

#endif
