
#ifndef RAM_H
#define RAM_H

#include "Memory.h"

template <typename A, typename W>
class RAM : public Memory<A, W>
{

    public:
        RAM(A size, A location);
        RAM(A size, A location, W bitWidth);
        ~RAM();
        void reset();
        A getSize();
        A getNumLocations();
        A getLocation(A i);
        BOOL isLocationReadable(A i);
        BOOL isLocationWriteable(A i);
        virtual W peek(A location);
        virtual W* getmemory();
        virtual void poke(A location, W value);
        W* image;

    protected:
        A  size;
        A  location;

    private:
        W  bitWidth;
        W  trimmer;

};

template <typename A, typename W>
RAM<A, W>::RAM(A size, A location)
{
    this->size = size;
    this->location = location;
    this->bitWidth = bitWidth;
    this->trimmer = (W)((1 << (sizeof(W) << 3)) - 1);
    image = new W[size];
}

template <typename A, typename W>
RAM<A, W>::RAM(A size, A location, W bitWidth)
{
    this->size = size;
    this->location = location;
    this->bitWidth = bitWidth;
    this->trimmer = (W)((1 << bitWidth) - 1);
    image = new W[size];
}

template <typename A, typename W>
RAM<A, W>::~RAM()
{
    delete[] image;
}

template <typename A, typename W>
void RAM<A, W>::reset()
{
    for (W i = 0; i < size; i++)
        image[i] = 0;
}

template <typename A, typename W>
A RAM<A, W>::getSize()
{
    return size;
}

template <typename A, typename W>
A RAM<A, W>::getNumLocations()
{
    return 1;
}

template <typename A, typename W>
A RAM<A, W>::getLocation(A i)
{
    return location;
}

template <typename A, typename W>
BOOL RAM<A, W>::isLocationReadable(A i)
{
    return TRUE;
}

template <typename A, typename W>
BOOL RAM<A, W>::isLocationWriteable(A i)
{
    return TRUE;
}

template <typename A, typename W>
W RAM<A, W>::peek(A location)
{
    return image[location-this->location];
}

template <typename A, typename W>
W* RAM<A, W>::getmemory()
{
    return image;
}

template <typename A, typename W>
void RAM<A, W>::poke(A location, W value)
{
    image[location-this->location] = (value & trimmer);
}

typedef RAM<UINT16, UINT16> RAM16Bit;
typedef RAM<UINT16, UINT8> RAM8Bit;

#endif
