
#ifndef PROCESSOR_H
#define PROCESSOR_H

#include "FileInputStream.h"
#include "FileOutputStream.h"
#include "osd/types.h"

/**
 * An abstract class representing a processor, which is a hardware component
 * that requires a clock input.
 *
 * @author Kyle Davis
 */
class Processor
{

    public:
        Processor() : isIdle(FALSE) {};
        virtual void reset() = 0;
        virtual INT32 getClockSpeed() = 0;
        virtual INT32 tick() = 0;

        //saving and loading support
        //virtual void save(FileOutputStream*) = 0;
        //virtual void load(FileInputStream*) = 0;

        //16-bit register debugging info
        virtual INT32 getNum16BitRegisters() { return 0; }
        virtual const CHAR* get16BitRegisterName(INT32) { return 0; }
        virtual UINT16 get16BitRegisterValue(INT32) { return 0; }

        //8-bit register debugging info
        virtual INT32 getNum8BitRegisters() { return 0; }
        virtual const CHAR* get8BitRegisterName(INT32) { return 0; }
        virtual UINT8 get8BitRegisterValue(INT32) { return 0; }

        //status bit debugging info
        virtual INT32 getNumStatusBits() { return 0; }
        virtual CHAR getStatusBitLetter(INT32) { return ' '; }
        virtual BOOL isStatusBitOn(INT32) { return FALSE; }

        //text output
        virtual void describeNextOperation(CHAR*) {}

        BOOL isIdle;

};

#endif
