
#include "Atari5200.h"

Atari5200::Atari5200()
    : ram(0x4000, 0x0000),
      pokeyRegisters(0x0100, 0xE800),
      biosROM(0x0800, 0xF800)
{
fprintf(stderr, "pokey: %04X\n", pokeyRegisters.getSize());
    currentCart = NULL;
    init();
}

void Atari5200::setBIOSImage(UINT8* biosImage)
{
    biosROM.loadImage(biosImage);
}

void Atari5200::insertCartridge(ROM8Bit* rom)
{
    if (currentCart)
        removeCartridge();

    currentCart = rom;
    if (currentCart)
        memoryBus.addMemory(rom);
}

void Atari5200::removeCartridge()
{
    if (!currentCart)
        return;

    memoryBus.removeMemory(currentCart);
    currentCart = NULL;
}

void Atari5200::init()
{
    //add the 16K of 8-bit RAM
    memoryBus.addMemory(&ram);

    //add the *fake* (for now) Pokey registers
    memoryBus.addMemory(&pokeyRegisters);
    
    //add the BIOS ROM
    memoryBus.addMemory(&biosROM);

    //add the main CPU
    cpu.init(&memoryBus, &readyLine, &haltLine, &nmiLine);
    processorBus.addProcessor(&cpu);

    //add the Antic
    antic.init(&memoryBus, &gtia, &readyLine, &haltLine, &nmiLine, &cpu);
    processorBus.addProcessor(&antic);
    setVideoProducer(&antic);
}

void Atari5200::reset()
{
    haltLine.isHigh = FALSE;
    readyLine.isHigh = TRUE;
    nmiLine.isHigh = FALSE;
    memoryBus.reset();
    Emulator::reset();
}

