
#ifdef _WIN32
#include <windows.h>
#endif
#include <iostream>
#include <SDL.h>
#include "AtariTest.h"
#include "../atari5200/Atari5200.h"
#include "../core/cartridge/CRC32.h"
#include "../core/ROM.h"
#include "../core/std_file.h"

#pragma warning(disable:4786)	// Suppress STL debug info > 255 chars messages
using namespace std;

const UINT32 AtariTest::CRC_BIOS_ROM              = 0x4248D3E3;
const CHAR* AtariTest::FILENAME_BIOS_ROM          = "5200.rom";

#ifndef MAX_PATH
#define MAX_PATH 255
#endif

int main(int argc, char** argv)
{
    CHAR tmp[MAX_PATH];
    if (argc != 2)
    {
        fprintf(stdout, "Usage:  Atari <cart_filename>\n");
        return -1;
    }

    AtariTest atariTest;
    //return atariTest.run(lpCmdLine);
    if(argc > 1)
    {
        strcpy((char*)tmp, (char *)argv[1]);
    }
    else
    {
        strcpy((char*)tmp, "");
    }
    return atariTest.run(tmp);
}

AtariTest::AtariTest()
{
}

INT32 AtariTest::run(CHAR* lpCmdLine)
{
fprintf(stderr, "run 1\n");
    CHAR currentDir[MAX_PATH];
    INT32 len = 0;
#ifdef _WIN32
    GetModuleFileName(NULL, currentDir, MAX_PATH);
    len = strlen(currentDir);
    while (currentDir[len] != '\\')
        len--;
    currentDir[len+1] = 0;
#else
    currentDir[0] = 0;
#endif
    CHAR nextFile[MAX_PATH];

fprintf(stderr, "run 2\n");
    //form the BIOS rom filename
    strcpy(nextFile, currentDir);
    strcat(nextFile, FILENAME_BIOS_ROM);

	//verify that the BIOS rom exists.
	if(!fileExists(nextFile)) {
        fprintf(stderr, "ERROR: BIOS ROM file '5200.rom' not found\n");
		return -1;
    }

fprintf(stderr, "run 3: %s\n", nextFile);
    //verify the CRC of the BIOS rom file
    UINT32 crc = CRC32::getCrc(nextFile);
    if (crc != CRC_BIOS_ROM) {
        fprintf(stderr, "ERROR: File '5200.rom' does not contain the correct BIOS ROM\n");
        return -1;
    }

    Atari5200 atari5200;

fprintf(stderr, "run 4\n");
/*
    //load the BIOS rom file
    UINT8* biosImage;
    UINT16 size;
    ROM8Bit::loadROMImage(&biosImage, &size, nextFile, FALSE);
    atari5200.setBIOSImage(biosImage);
    delete[] biosImage;

fprintf(stderr, "run 5\n");
    strcpy(nextFile, currentDir);
    strcat(nextFile, lpCmdLine);
    if (!fileExists(nextFile)) {
        fprintf(stderr, "ERROR: File '%s' not found\n", lpCmdLine);
        return -1;
    }

fprintf(stderr, "run 6\n");
    UINT8* cartImage;
fprintf(stderr, "run 6a: %s\n", nextFile);
    ROM8Bit::loadROMImage(&cartImage, &size, nextFile, FALSE);
fprintf(stderr, "run 6b\n");
    if (size > 32768) {
        fprintf(stderr, "ERROR: Cartridge image is too big.  Must be less than 32K\n");
        delete[] cartImage;
        return -1;
    }
fprintf(stderr, "run 6c\n");

    ROM8Bit cartROM(cartImage, size, 0xC000-size);
    delete[] cartImage;

    atari5200.insertCartridge(&cartROM);
*/

fprintf(stderr, "run 7\n");
    atari5200.reset();

//while (TRUE)
    //atari5200.run();

fprintf(stderr, "run 8\n");
    return 0;
}

